/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks;

import com.carpentersblocks.util.ModLogger;
import com.carpentersblocks.util.handler.DesignHandler;
import com.google.common.base.Charsets;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.ResourcePackFileNotFoundException;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class CarpentersBlocksCachedResources
extends DummyModContainer {
    public static final CarpentersBlocksCachedResources INSTANCE = new CarpentersBlocksCachedResources();
    private String MODID = "CarpentersBlocksCachedResources";
    private String resourceDir;
    private static ZipFile resourcePackZipFile;
    private static ArrayList<Object[]> resources;
    private final int RESOURCE_PATH = 0;
    private final int RESOURCE_IMAGE = 1;

    private CarpentersBlocksCachedResources() {
        super(new ModMetadata());
        this.resourceDir = FilenameUtils.normalizeNoEndSeparator((String)Minecraft.func_71410_x().field_71412_D.getAbsolutePath()) + File.separator + "mods" + File.separator + "CarpentersBlocks".toLowerCase();
        this.RESOURCE_PATH = 0;
        this.RESOURCE_IMAGE = 1;
        ModMetadata meta = this.getMetadata();
        meta.modId = this.MODID;
        meta.name = "Carpenter's Blocks Cached Resources";
        meta.description = "Holds dynamically-created resources used with Carpenter's Blocks.";
    }

    public void init() {
        FMLClientHandler.instance().addModAsResource((ModContainer)this);
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110545_a(FMLClientHandler.instance().getResourcePackFor(this.MODID));
    }

    public File getSource() {
        return new File(this.resourceDir, this.MODID + ".zip");
    }

    public Class<?> getCustomResourcePackClass() {
        return DynamicFileResourcePack.class;
    }

    public void addResource(String path, BufferedImage bufferedImage) {
        resources.add(new Object[]{path, bufferedImage});
    }

    private void createResourceZipFile() {
        try {
            if (this.createDirectory()) {
                this.createZip(this.resourceDir, this.MODID + ".zip");
                resourcePackZipFile = new ZipFile(this.getSource());
            }
        }
        catch (Exception e) {
            ModLogger.log(Level.WARN, "Cache rebuild failed: " + e.getMessage(), new Object[0]);
        }
    }

    private boolean createDirectory() throws Exception {
        File dir = new File(this.resourceDir);
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir.exists();
    }

    private void createZip(String dir, String fileName) throws Exception {
        File file = new File(dir, fileName);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));
        for (Object[] object : resources) {
            out.putNextEntry(new ZipEntry("assets/" + this.MODID.toLowerCase() + (String)object[0] + ".png"));
            ImageIO.write((RenderedImage)((BufferedImage)object[1]), "png", out);
            out.closeEntry();
        }
        out.flush();
        out.close();
    }

    public void rebuildCache() {
        DesignHandler.addResources(Minecraft.func_71410_x().func_110442_L());
        this.createResourceZipFile();
        resources.clear();
    }

    static {
        resources = new ArrayList();
    }

    public static class DynamicFileResourcePack
    extends FMLFileResourcePack {
        public DynamicFileResourcePack(ModContainer container) {
            super(container);
        }

        public ZipFile func_110599_c() {
            if (resourcePackZipFile == null) {
                INSTANCE.rebuildCache();
            }
            return resourcePackZipFile;
        }

        protected InputStream func_110591_a(String resourceName) throws IOException {
            ZipFile zipfile = this.func_110599_c();
            ZipEntry zipentry = zipfile.getEntry(resourceName);
            try {
                if ("pack.mcmeta".equals(resourceName)) {
                    return new ByteArrayInputStream(("{\n \"pack\": {\n   \"description\": \"dummy FML pack for " + this.func_130077_b() + "\",\n" + "   \"pack_format\": 1\n" + "}\n" + "}").getBytes(Charsets.UTF_8));
                }
                return zipfile.getInputStream(zipentry);
            }
            catch (IOException e) {
                throw new ResourcePackFileNotFoundException(this.field_110597_b, resourceName);
            }
        }

        public boolean func_110593_b(String resourceName) {
            return this.func_110599_c().getEntry(resourceName) != null;
        }
    }
}

