/*
 * Decompiled with CFR 0.152.
 */
package sync.common.tileentity;

import cofh.api.tileentity.IEnergyInfo;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import sync.common.Sync;
import sync.common.shell.ShellHandler;
import sync.common.tileentity.TileEntityDualVertical;

@Optional.Interface(iface="cofh.api.tileentity.IEnergyInfo", modid="CoFHCore")
public class TileEntityShellConstructor
extends TileEntityDualVertical
implements IEnergyInfo {
    public float constructionProgress = 0.0f;
    public int doorTime = 0;
    public int rfBuffer;
    public boolean doorOpen = false;
    public float prevPower;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.top && this.pair != null) {
            this.constructionProgress = ((TileEntityShellConstructor)this.pair).constructionProgress;
            this.doorOpen = ((TileEntityShellConstructor)this.pair).doorOpen;
        }
        if (this.isPowered()) {
            float power = this.powerAmount();
            if (this.field_145850_b.func_72820_D() % 200L == 0L && this.prevPower != power) {
                EntityPlayerMP player;
                this.prevPower = power;
                if (!this.top && !this.field_145850_b.field_72995_K && (player = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152612_a(this.playerName)) != null) {
                    ShellHandler.updatePlayerOfShells((EntityPlayer)player, null, true);
                }
            }
            this.constructionProgress += power;
            if (this.constructionProgress > (float)Sync.config.getSessionInt("shellConstructionPowerRequirement")) {
                this.constructionProgress = Sync.config.getSessionInt("shellConstructionPowerRequirement");
            }
            if (this.field_145850_b.func_72820_D() % 40L == 0L) {
                this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            }
        }
        if (!this.top) {
            if (this.doorOpen) {
                List list;
                if (this.doorTime < 40) {
                    ++this.doorTime;
                }
                if (!this.field_145850_b.field_72995_K && this.doorTime == 40 && (list = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1)))).isEmpty()) {
                    this.doorOpen = false;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            } else if (this.doorTime > 0) {
                --this.doorTime;
            }
            if (!(this.field_145850_b.field_72995_K || this.playerName.equalsIgnoreCase("") || ShellHandler.isShellAlreadyRegistered(this))) {
                ShellHandler.addShell(this.playerName, this, true);
            }
        }
        if (!this.top && !this.field_145850_b.field_72995_K) {
            this.rfBuffer += Math.abs(this.powReceived - this.rfIntake);
            if ((float)this.rfBuffer / (float)Sync.config.getSessionInt("shellConstructionPowerRequirement") > 0.05f || Math.abs((float)(this.powReceived - this.rfIntake) / (float)this.powReceived) > 0.1f) {
                this.rfIntake = this.powReceived;
                this.rfBuffer = 0;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.powReceived = 0;
        }
    }

    @Override
    public void setup(TileEntityDualVertical scPair, boolean isTop, int placeYaw) {
        this.pair = scPair;
        this.top = isTop;
        this.face = placeYaw;
    }

    public boolean isPowered() {
        if (this.top && this.pair != null) {
            return ((TileEntityShellConstructor)this.pair).isPowered();
        }
        return !this.playerName.equalsIgnoreCase("");
    }

    @Override
    public float getBuildProgress() {
        return this.constructionProgress;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74776_a("constructionProgress", this.constructionProgress);
        tag.func_74757_a("doorOpen", this.doorOpen);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.constructionProgress = tag.func_74760_g("constructionProgress");
        this.doorOpen = tag.func_74767_n("doorOpen");
        this.resync = true;
    }

    @Override
    public void reset() {
        super.reset();
        this.constructionProgress = 0.0f;
    }

    @Optional.Method(modid="CoFHCore")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int powReq = Math.max((int)Math.ceil((float)Sync.config.getSessionInt("shellConstructionPowerRequirement") - this.constructionProgress), 0);
        if (powReq == 0 || this.playerName.equalsIgnoreCase("")) {
            return 0;
        }
        int pow = maxReceive;
        if (pow > 24) {
            pow = 24;
        }
        if (pow > powReq) {
            pow = powReq;
        }
        if (!simulate) {
            this.powReceived = (int)((float)this.powReceived + (float)pow * (float)Sync.config.getInt("ratioRF"));
        }
        return pow;
    }

    @Optional.Method(modid="CoFHCore")
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean doExtract) {
        return 0;
    }

    @Optional.Method(modid="CoFHCore")
    public boolean canConnectEnergy(ForgeDirection from) {
        return !this.top;
    }

    @Optional.Method(modid="CoFHCore")
    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Optional.Method(modid="CoFHCore")
    public int getMaxEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Optional.Method(modid="CoFHCore")
    public int getInfoEnergyPerTick() {
        return this.powReceived;
    }

    @Optional.Method(modid="CoFHCore")
    public int getInfoMaxEnergyPerTick() {
        return 24;
    }

    @Optional.Method(modid="CoFHCore")
    public int getInfoEnergyStored() {
        return 0;
    }

    @Optional.Method(modid="CoFHCore")
    public int getInfoMaxEnergyStored() {
        return 0;
    }
}

