/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer;

import com.google.common.collect.Maps;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;
import openmods.renderer.DefaultBlockRenderer;
import openmods.renderer.IBlockRenderer;

public class BlockRenderingHandler
implements ISimpleBlockRenderingHandler {
    private final boolean itemsIn3d;
    private final int renderId;
    protected static final IBlockRenderer<Block> DEFAULT_RENDERER = new DefaultBlockRenderer();
    protected final Map<Block, IBlockRenderer<Block>> blockRenderers = Maps.newIdentityHashMap();

    public BlockRenderingHandler(int renderId) {
        this(renderId, true);
    }

    public BlockRenderingHandler(int renderId, boolean itemsIn3d) {
        this.renderId = renderId;
        this.itemsIn3d = itemsIn3d;
    }

    public <B extends Block> void addRenderer(B block, IBlockRenderer<B> renderer) {
        if (block != null) {
            this.blockRenderers.put(block, renderer);
        }
    }

    protected IBlockRenderer<Block> getRenderer(Block block) {
        IBlockRenderer<Block> renderer = this.blockRenderers.get(block);
        return renderer != null ? renderer : DEFAULT_RENDERER;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        this.getRenderer(block).renderInventoryBlock(block, metadata, modelID, renderer);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        return this.getRenderer(block).renderWorldBlock(world, x, y, z, block, modelId, renderer);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return this.itemsIn3d;
    }

    public int getRenderId() {
        return this.renderId;
    }
}

