/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.renderers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.headcrumbs.libs.SkullTypes;
import java.util.HashMap;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelEnderman;
import net.minecraft.client.model.ModelRenderer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelHead
extends ModelBase {
    private static HashMap<SkullTypes, ModelHead> heads;
    private ModelRenderer head;
    private ModelRenderer overlay;
    private boolean renderOverlay;

    private ModelHead() {
        this(32);
    }

    private ModelHead(int height) {
        this.field_78090_t = 64;
        this.field_78089_u = height;
        this.renderOverlay = true;
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.overlay = new ModelRenderer((ModelBase)this, 32, 0);
        this.head.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, 0.0f);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.overlay.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, 0.5f);
        this.overlay.func_78793_a(0.0f, 0.0f, 0.0f);
    }

    public static ModelHead getHead(SkullTypes type) {
        if (heads == null) {
            heads = new HashMap();
            for (SkullTypes skull : SkullTypes.values()) {
                heads.put(skull, new ModelHead().setHeadType(skull));
            }
        }
        ModelHead.transform(type);
        return heads.get((Object)type);
    }

    private static void transform(SkullTypes skull) {
        switch (skull) {
            case squid: 
            case pinky: {
                GL11.glScaled((double)0.6666666865348816, (double)0.6666666865348816, (double)0.6666666865348816);
                break;
            }
            case mistWolf: 
            case winterWolf: {
                GL11.glScaled((double)1.5, (double)1.5, (double)1.5);
                break;
            }
            case bat: 
            case fireBat: 
            case enderDragon: {
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                break;
            }
            case slime: 
            case mazeSlime: 
            case thaumicSlime: {
                GL11.glEnable((int)2977);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                break;
            }
            case enderminy: {
                GL11.glScalef((float)1.0f, (float)0.5f, (float)1.0f);
                break;
            }
        }
    }

    private ModelHead hideOverlay() {
        this.renderOverlay = false;
        return this;
    }

    public void render(float rotationX) {
        this.render(rotationX, 0.0f);
    }

    public void render(float rotationX, float rotationY) {
        this.head.field_78796_g = rotationX / 57.295776f;
        this.head.field_78795_f = rotationY / 57.295776f;
        this.head.func_78785_a(0.0625f);
        if (this.renderOverlay) {
            this.renderOverlay(rotationX, rotationY);
        }
    }

    public void renderOverlay(float rotationX) {
        this.renderOverlay(rotationX, 0.0f);
    }

    public void renderOverlay(float rotationX, float rotationY) {
        this.overlay.field_78796_g = rotationX / 57.295776f;
        this.overlay.field_78795_f = rotationY / 57.295776f;
        this.overlay.func_78785_a(0.0625f);
    }

    private ModelHead setHeadType(SkullTypes type) {
        switch (type) {
            case enderminy: 
            case enderman: {
                this.setEnderman();
                break;
            }
            case pigman: {
                return new ModelHead(64);
            }
            case spider: 
            case caveSpider: 
            case hedgeSpider: 
            case kingSpider: 
            case swarmSpider: 
            case towerBroodling: 
            case heatscarSpider: {
                this.setSpider();
                break;
            }
            case pig: 
            case taintedPig: {
                this.setPig();
                break;
            }
            case mooshroom: 
            case cow: 
            case taintedCow: {
                this.setCow();
                break;
            }
            case sheep: 
            case taintedSheep: {
                this.setSheep();
                break;
            }
            case mistWolf: 
            case winterWolf: 
            case wolf: 
            case hostileWolf: {
                this.setWolf();
                break;
            }
            case direWolf: {
                this.setDireWolf();
                break;
            }
            case villager: 
            case taintedVillager: {
                this.setVillager(64);
                break;
            }
            case chicken: 
            case taintedChicken: {
                this.setChicken();
                break;
            }
            case witch: 
            case witherWitch: {
                this.setWitch();
                break;
            }
            case zombieVillager: {
                this.setZombieVillager();
                break;
            }
            case ironGolem: {
                this.setVillager(128);
                break;
            }
            case squid: {
                this.setSquid();
                break;
            }
            case wither: 
            case angryZombie: {
                return new ModelHead(64).hideOverlay();
            }
            case bunnyDutch: 
            case bunnyBrown: 
            case bunnyWhite: {
                this.setBunny();
                break;
            }
            case penguin: {
                this.setPenguin();
                break;
            }
            case bighorn: {
                this.setBighorn();
                break;
            }
            case wildDeer: {
                this.setDeer();
                break;
            }
            case wildBoar: {
                this.setBoar();
                break;
            }
            case redcap: {
                this.setRedcap();
                break;
            }
            case ghast: 
            case miniGhast: 
            case guardGhast: {
                this.setGhast();
                break;
            }
            case kobold: {
                this.setKobold();
                break;
            }
            case slimeBeetle: {
                this.setSlimeBeetle();
                break;
            }
            case fireBeetle: {
                this.setFireBeetle();
                break;
            }
            case pinchBeetle: {
                this.setPinchBeetle();
                break;
            }
            case towerGolem: {
                this.setTowerGolem();
                break;
            }
            case enderDragon: {
                this.setEnderDragon();
                break;
            }
            case squirrel: {
                this.setSquirrel();
                break;
            }
            case ocelot: 
            case ocelotBlack: 
            case ocelotRed: 
            case ocelotSiamese: 
            case witherCat: {
                this.setOcelot();
                break;
            }
            case bat: 
            case fireBat: {
                this.setBat();
                break;
            }
            case slime: 
            case mazeSlime: 
            case thaumicSlime: {
                this.setSlime();
                break;
            }
            case magmaCube: {
                this.setMagmaCube();
                break;
            }
            case horseBlack: 
            case horseBrown: 
            case horseChestnut: 
            case horseCreamy: 
            case horseDarkBrown: 
            case horseGrey: 
            case horseWhite: 
            case horseSkeleton: 
            case horseUndead: {
                this.setHorse(false);
                break;
            }
            case donkey: 
            case mule: {
                this.setHorse(true);
                break;
            }
            case snowMan: {
                this.setSnowman();
                break;
            }
            case silverfish: 
            case towerwoodBorer: {
                this.setSilverfish();
                break;
            }
            case imp: {
                this.setImp();
                break;
            }
            case nitroCreeper: 
            case concussionCreeper: 
            case fallenKnight: {
                this.hideOverlay();
                break;
            }
            case pech: {
                this.setPech();
                break;
            }
            case eldritchGuardian: {
                this.setEldrichGuardian();
                break;
            }
            case pinky: {
                this.setPinky();
                break;
            }
            case behemoth: {
                this.setBehemoth();
                break;
            }
            case belph: {
                this.setBelph();
                break;
            }
        }
        return this;
    }

    private void setDireWolf() {
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78790_a(-3.0f, -3.0f, -4.0f, 6, 6, 6, 0.0f);
        this.head.func_78793_a(2.0f, -3.0f, 0.0f);
        this.head.func_78784_a(16, 18).func_78790_a(-2.5f, -5.0f, -1.5f, 1, 2, 2, 0.0f);
        this.head.func_78784_a(16, 18).func_78790_a(1.5f, -5.0f, -1.5f, 1, 2, 2, 0.0f);
        this.head.func_78784_a(0, 14).func_78790_a(-1.5f, 0.0f, -7.0f, 3, 3, 4, 0.0f);
        this.hideOverlay();
    }

    private void setPinky() {
        this.field_78090_t = 128;
        this.field_78089_u = 64;
        float f1 = 11.0f;
        float f2 = -3.0f;
        float f3 = 6.0f;
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78789_a(-5.0f, -4.0f, -9.0f + f3, 10, 11, 9);
        this.head.func_78793_a(0.0f, -4.0f + f2, -11.0f + f1);
        this.setRotation(this.head, 0.7853982f, 0.0f, 0.0f);
        ModelRenderer topjaw = new ModelRenderer((ModelBase)this, 38, 0);
        this.head.func_78792_a(topjaw);
        topjaw.func_78789_a(-6.0f, 0.0f, -12.0f, 12, 6, 6);
        topjaw.func_78793_a(0.0f, 0.0f, 0.0f + f3);
        this.setRotation(topjaw, -0.57595867f, 0.0f, 0.0f);
        ModelRenderer topteeth = new ModelRenderer((ModelBase)this, 38, 12);
        this.head.func_78792_a(topteeth);
        topteeth.func_78789_a(-5.0f, 5.0f, -11.0f, 10, 3, 0);
        topteeth.func_78793_a(0.0f, 0.0f, 0.0f + f3);
        this.setRotation(topteeth, -0.57595867f, 0.0f, 0.0f);
        ModelRenderer leftmouth = new ModelRenderer((ModelBase)this, 120, 0);
        this.head.func_78792_a(leftmouth);
        leftmouth.func_78789_a(4.9f, -2.0f, -11.0f, 1, 8, 3);
        leftmouth.func_78793_a(0.0f, 0.0f, 0.0f + f3);
        this.setRotation(leftmouth, 0.0f, 0.0f, 0.0f);
        ModelRenderer rightmouth = new ModelRenderer((ModelBase)this, 120, 0);
        this.head.func_78792_a(rightmouth);
        rightmouth.field_78809_i = true;
        rightmouth.func_78789_a(-5.9f, -2.0f, -11.0f, 1, 8, 3);
        rightmouth.func_78793_a(0.0f, 0.0f, 0.0f + f3);
        this.setRotation(rightmouth, 0.0f, 0.0f, 0.0f);
        rightmouth.field_78809_i = false;
        ModelRenderer bottomjaw = new ModelRenderer((ModelBase)this, 74, 0);
        this.head.func_78792_a(bottomjaw);
        bottomjaw.func_78789_a(-6.0f, 8.0f, -13.0f, 12, 4, 12);
        bottomjaw.func_78793_a(0.0f, 0.0f, 0.0f + f3);
        this.setRotation(bottomjaw, -0.3316126f, 0.0f, 0.0f);
        ModelRenderer bottomteeth = new ModelRenderer((ModelBase)this, 38, 15);
        bottomjaw.func_78792_a(bottomteeth);
        bottomteeth.func_78789_a(-5.0f, 5.0f, -12.0f, 10, 4, 0);
        bottomteeth.func_78793_a(0.0f, 0.0f, 0.0f);
        this.setRotation(bottomteeth, 0.0f, 0.0f, 0.0f);
        ModelRenderer lefthorn01 = new ModelRenderer((ModelBase)this, 110, 17);
        this.head.func_78792_a(lefthorn01);
        lefthorn01.func_78789_a(5.0f, -2.0f, -7.0f, 4, 4, 3);
        lefthorn01.func_78793_a(0.0f, 0.0f, 0.0f + f3);
        this.setRotation(lefthorn01, -0.3316126f, 0.0f, 0.0f);
        ModelRenderer lefthorn02 = new ModelRenderer((ModelBase)this, 110, 17);
        this.head.func_78792_a(lefthorn02);
        lefthorn02.func_78789_a(-1.0f, -2.0f, -15.0f, 3, 2, 6);
        lefthorn02.func_78793_a(0.0f, 0.0f, 0.0f + f3);
        this.setRotation(lefthorn02, (float)Math.toRadians(-8.0), (float)Math.toRadians(-49.0), (float)Math.toRadians(3.0));
        ModelRenderer lefthorn03 = new ModelRenderer((ModelBase)this, 110, 17);
        this.head.func_78792_a(lefthorn03);
        lefthorn03.func_78789_a(13.0f, -3.0f, -9.0f, 2, 2, 7);
        lefthorn03.func_78793_a(0.0f, 0.0f, 0.0f + f3);
        this.setRotation(lefthorn03, (float)Math.toRadians(-4.0), (float)Math.toRadians(30.0), (float)Math.toRadians(-3.0));
        ModelRenderer righthorn01 = new ModelRenderer((ModelBase)this, 110, 17);
        this.head.func_78792_a(righthorn01);
        righthorn01.field_78809_i = true;
        righthorn01.func_78789_a(-9.0f, -2.0f, -7.0f, 4, 4, 3);
        righthorn01.func_78793_a(0.0f, 0.0f, 0.0f + f3);
        this.setRotation(righthorn01, -0.3316126f, 0.0f, 0.0f);
        righthorn01.field_78809_i = false;
        ModelRenderer righthorn02 = new ModelRenderer((ModelBase)this, 110, 17);
        this.head.func_78792_a(righthorn02);
        righthorn02.field_78809_i = true;
        righthorn02.func_78789_a(-2.0f, -2.0f, -15.0f, 3, 2, 6);
        righthorn02.func_78793_a(0.0f, 0.0f, 0.0f + f3);
        this.setRotation(righthorn02, (float)Math.toRadians(-8.0), (float)Math.toRadians(49.0), (float)Math.toRadians(-3.0));
        righthorn02.field_78809_i = false;
        ModelRenderer righthorn03 = new ModelRenderer((ModelBase)this, 110, 17);
        this.head.func_78792_a(righthorn03);
        righthorn03.field_78809_i = true;
        righthorn03.func_78789_a(-15.0f, -3.0f, -9.0f, 2, 2, 7);
        righthorn03.func_78793_a(0.0f, 0.0f, 0.0f + f3);
        this.setRotation(righthorn03, (float)Math.toRadians(-4.0), (float)Math.toRadians(-30.0), (float)Math.toRadians(3.0));
        righthorn03.field_78809_i = false;
        this.hideOverlay();
    }

    private void setBehemoth() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        float f1 = 22.0f;
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78789_a(-4.0f, -10.0f + f1, -4.0f, 8, 10, 8);
        this.head.func_78793_a(0.0f, -21.0f, 0.0f);
        this.head.func_78787_b(128, 128);
        this.setRotation(this.head, 0.0f, 0.0f, 0.0f);
        ModelRenderer mouth = new ModelRenderer((ModelBase)this, 32, 0);
        this.head.func_78792_a(mouth);
        mouth.func_78789_a(-2.0f, -2.0f, -4.5f, 4, 3, 2);
        mouth.func_78793_a(0.0f, 0.0f + f1, 0.0f);
        mouth.func_78787_b(128, 128);
        this.setRotation(mouth, 0.2094395f, 0.0f, 0.0f);
        ModelRenderer lefthorn01 = new ModelRenderer((ModelBase)this, 32, 5);
        this.head.func_78792_a(lefthorn01);
        lefthorn01.func_78789_a(3.0f, -5.0f, -0.5f, 5, 5, 6);
        lefthorn01.func_78793_a(0.0f, 0.0f + f1, 0.0f);
        lefthorn01.func_78787_b(128, 128);
        this.setRotation(lefthorn01, 0.1745329f, 0.3141593f, -0.4363323f);
        ModelRenderer lefthorn02 = new ModelRenderer((ModelBase)this, 50, 0);
        this.head.func_78792_a(lefthorn02);
        lefthorn02.func_78789_a(-3.0f, -10.0f, 6.0f, 3, 7, 4);
        lefthorn02.func_78793_a(0.0f, 0.0f + f1, 0.0f);
        lefthorn02.func_78787_b(128, 128);
        this.setRotation(lefthorn02, 1.204277f, -0.1396263f, 1.012291f);
        ModelRenderer lefthorn03 = new ModelRenderer((ModelBase)this, 53, 0);
        this.head.func_78792_a(lefthorn03);
        lefthorn03.func_78789_a(3.5f, -7.5f, 11.0f, 2, 7, 2);
        lefthorn03.func_78793_a(0.0f, 0.0f + f1, 0.0f);
        lefthorn03.func_78787_b(128, 128);
        this.setRotation(lefthorn03, 1.989675f, 0.0f, 0.5235988f);
        ModelRenderer righthorn01 = new ModelRenderer((ModelBase)this, 32, 5);
        this.head.func_78792_a(righthorn01);
        righthorn01.field_78809_i = true;
        righthorn01.func_78789_a(-8.0f, -5.0f, -0.5f, 5, 5, 6);
        righthorn01.func_78793_a(0.0f, 0.0f + f1, 0.0f);
        righthorn01.func_78787_b(128, 128);
        this.setRotation(righthorn01, 0.1745329f, -0.3141593f, 0.4363323f);
        righthorn01.field_78809_i = false;
        ModelRenderer righthorn02 = new ModelRenderer((ModelBase)this, 50, 0);
        this.head.func_78792_a(righthorn02);
        righthorn02.field_78809_i = true;
        righthorn02.func_78789_a(0.0f, -10.0f, 6.0f, 3, 7, 4);
        righthorn02.func_78793_a(0.0f, 0.0f + f1, 0.0f);
        righthorn02.func_78787_b(128, 128);
        this.setRotation(righthorn02, 1.204277f, 0.1396263f, -1.012291f);
        righthorn02.field_78809_i = false;
        ModelRenderer righthorn03 = new ModelRenderer((ModelBase)this, 53, 0);
        this.head.func_78792_a(righthorn03);
        righthorn03.field_78809_i = true;
        righthorn03.func_78789_a(-5.5f, -7.5f, 11.0f, 2, 7, 2);
        righthorn03.func_78793_a(0.0f, 0.0f + f1, 0.0f);
        righthorn03.func_78787_b(128, 128);
        this.setRotation(righthorn03, 1.989675f, 0.0f, -0.5235988f);
        righthorn03.field_78809_i = false;
        this.hideOverlay();
    }

    private void setBelph() {
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        float f1 = -4.0f;
        float f2 = 3.0f;
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78789_a(-3.0f, -6.0f + f1, -5.0f + f2, 6, 10, 6);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_78787_b(64, 32);
        this.setRotation(this.head, 0.0f, 0.0f, 0.0f);
        this.hideOverlay();
    }

    private void setEldrichGuardian() {
        this.field_78090_t = 128;
        this.field_78089_u = 64;
        this.head = new ModelRenderer((ModelBase)this, 40, 12);
        this.head.func_78789_a(-4.0f, -8.0f, -4.0f, 8, 8, 8);
        this.setRotation(this.head, 0.0f, 0.0f, 0.0f);
        ModelRenderer hood1 = new ModelRenderer((ModelBase)this, 36, 28);
        hood1.func_78789_a(-3.5f, -8.7f, 2.0f, 7, 7, 3);
        this.setRotation(hood1, -0.2268928f, 0.0f, 0.0f);
        ModelRenderer hood2 = new ModelRenderer((ModelBase)this, 22, 19);
        hood2.func_78789_a(-3.0f, -9.0f, 2.5f, 6, 6, 3);
        this.setRotation(hood2, -0.3490659f, 0.0f, 0.0f);
        ModelRenderer hood3 = new ModelRenderer((ModelBase)this, 40, 4);
        hood3.func_78789_a(-2.5f, -9.7f, 3.5f, 5, 5, 3);
        this.setRotation(hood3, -0.5759587f, 0.0f, 0.0f);
        this.head.func_78792_a(hood1);
        this.head.func_78792_a(hood2);
        this.head.func_78792_a(hood3);
        this.hideOverlay();
    }

    private void setPech() {
        this.field_78090_t = 128;
        this.field_78089_u = 64;
        float f1 = -2.0f;
        float f2 = 4.0f;
        this.head = new ModelRenderer((ModelBase)this, 2, 11);
        this.head.func_78789_a(-3.5f, -5.0f + f1, -5.0f + f2, 7, 5, 5);
        this.overlay = new ModelRenderer((ModelBase)this, 1, 21);
        this.overlay.func_78789_a(-4.0f, -1.0f + f1, -6.0f + f2, 8, 3, 5);
    }

    private void setImp() {
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78790_a(-5.0f, -8.0f, -4.0f, 10, 8, 8, 0.0f);
        this.hideOverlay();
    }

    private void setSilverfish() {
        float f = -1.9f;
        float f1 = -24.0f;
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        ModelRenderer[] silverfishBodyParts = new ModelRenderer[7];
        int[][] silverfishBoxLength = new int[][]{{3, 2, 2}, {4, 3, 2}, {6, 4, 3}, {3, 3, 3}, {2, 2, 3}, {2, 1, 2}, {1, 1, 2}};
        int[][] silverfishTexturePositions = new int[][]{{0, 0}, {0, 4}, {0, 9}, {0, 16}, {0, 22}, {11, 0}, {13, 4}};
        float[] field_78170_c = new float[7];
        for (int i = 0; i < silverfishBodyParts.length; ++i) {
            silverfishBodyParts[i] = new ModelRenderer((ModelBase)this, silverfishTexturePositions[i][0], silverfishTexturePositions[i][1]);
            silverfishBodyParts[i].func_78789_a((float)silverfishBoxLength[i][0] * -0.5f, 0.0f + f1, (float)silverfishBoxLength[i][2] * -0.5f, silverfishBoxLength[i][0], silverfishBoxLength[i][1], silverfishBoxLength[i][2]);
            silverfishBodyParts[i].func_78793_a(0.0f, (float)(24 - silverfishBoxLength[i][1]), f);
            field_78170_c[i] = f;
            if (i < silverfishBodyParts.length - 1) {
                f += (float)(silverfishBoxLength[i][2] + silverfishBoxLength[i + 1][2]) * 0.5f;
            }
            if (i >= 3) continue;
            this.head.func_78792_a(silverfishBodyParts[i]);
        }
        ModelRenderer[] silverfishWings = new ModelRenderer[2];
        silverfishWings[0] = new ModelRenderer((ModelBase)this, 20, 0);
        silverfishWings[0].func_78789_a(-5.0f, 0.0f + f1, (float)silverfishBoxLength[2][2] * -0.5f, 10, 8, silverfishBoxLength[2][2]);
        silverfishWings[0].func_78793_a(0.0f, 16.0f, field_78170_c[2]);
        silverfishWings[1] = new ModelRenderer((ModelBase)this, 20, 18);
        silverfishWings[1].func_78789_a(-3.0f, 0.0f + f1, (float)silverfishBoxLength[4][2] * -0.5f, 6, 5, silverfishBoxLength[1][2]);
        silverfishWings[1].func_78793_a(0.0f, 19.0f, field_78170_c[1]);
        this.head.func_78792_a(silverfishWings[0]);
        this.head.func_78792_a(silverfishWings[1]);
        this.hideOverlay();
    }

    private void setSnowman() {
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, 0.0f);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.hideOverlay();
    }

    private void setHorse(boolean isMule) {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        float f1 = -2.0f;
        float f2 = -4.0f;
        ModelRenderer head2 = new ModelRenderer((ModelBase)this, 0, 0);
        head2.func_78789_a(-2.5f, -10.0f + f2, -1.5f + f1, 5, 5, 7);
        ModelRenderer mouthTop = new ModelRenderer((ModelBase)this, 24, 18);
        mouthTop.func_78789_a(-2.0f, -10.0f + f2, -7.0f + f1, 4, 3, 6);
        ModelRenderer mouthBottom = new ModelRenderer((ModelBase)this, 24, 27);
        mouthBottom.func_78789_a(-2.0f, -7.0f + f2, -6.5f + f1, 4, 2, 5);
        ModelRenderer neck = new ModelRenderer((ModelBase)this, 0, 12);
        neck.func_78789_a(-2.05f, -9.8f + f2, -2.0f + f1, 4, 14, 8);
        ModelRenderer mane = new ModelRenderer((ModelBase)this, 58, 0);
        mane.func_78789_a(-1.0f, -11.5f + f2, 5.0f + f1, 2, 16, 4);
        if (isMule) {
            ModelRenderer muleLeftEar = new ModelRenderer((ModelBase)this, 0, 12);
            muleLeftEar.func_78789_a(-2.0f, -16.0f + f2, 4.0f + f1, 2, 7, 1);
            ModelRenderer muleRightEar = new ModelRenderer((ModelBase)this, 0, 12);
            muleRightEar.func_78789_a(0.0f, -16.0f + f2, 4.0f + f1, 2, 7, 1);
            this.setRotation(muleLeftEar, 0.0f, 0.0f, -0.06f);
            this.setRotation(muleRightEar, 0.0f, 0.0f, 0.06f);
            this.head.func_78792_a(muleRightEar);
            this.head.func_78792_a(muleLeftEar);
        } else {
            ModelRenderer horseLeftEar = new ModelRenderer((ModelBase)this, 0, 0);
            horseLeftEar.func_78789_a(0.45f, -12.0f + f2, 4.0f + f1, 2, 3, 1);
            ModelRenderer horseRightEar = new ModelRenderer((ModelBase)this, 0, 0);
            horseRightEar.func_78789_a(-2.45f, -12.0f + f2, 4.0f + f1, 2, 3, 1);
            this.head.func_78792_a(horseRightEar);
            this.head.func_78792_a(horseLeftEar);
        }
        this.head.func_78792_a(head2);
        this.head.func_78792_a(neck);
        this.head.func_78792_a(mane);
        this.head.func_78792_a(mouthTop);
        this.head.func_78792_a(mouthBottom);
        this.hideOverlay();
    }

    private void setMagmaCube() {
        this.hideOverlay();
        this.head = new ModelRenderer((ModelBase)this, 0, 16);
        this.head.func_78789_a(-2.0f, -6.0f, -2.0f, 4, 4, 4);
        for (int i = 0; i < 8; ++i) {
            int x = 0;
            int y = i;
            if (i == 2) {
                x = 24;
                y = 10;
            } else if (i == 3) {
                x = 24;
                y = 19;
            }
            ModelRenderer segment = new ModelRenderer((ModelBase)this, x, y);
            segment.func_78789_a(-4.0f, (float)(16 + i - 24), -4.0f, 8, 1, 8);
            this.head.func_78792_a(segment);
        }
    }

    private void setSlime() {
        float f1 = -24.0f;
        this.head = new ModelRenderer((ModelBase)this, 0, 16);
        this.head.func_78789_a(-3.0f, 17.0f + f1, -3.0f, 6, 6, 6);
        ModelRenderer slimeRightEye = new ModelRenderer((ModelBase)this, 32, 0);
        slimeRightEye.func_78789_a(-3.25f, 18.0f + f1, -3.5f, 2, 2, 2);
        ModelRenderer slimeLeftEye = new ModelRenderer((ModelBase)this, 32, 4);
        slimeLeftEye.func_78789_a(1.25f, 18.0f + f1, -3.5f, 2, 2, 2);
        ModelRenderer slimeMouth = new ModelRenderer((ModelBase)this, 32, 8);
        slimeMouth.func_78789_a(0.0f, 21.0f + f1, -3.5f, 1, 1, 1);
        this.head.func_78792_a(slimeMouth);
        this.head.func_78792_a(slimeRightEye);
        this.head.func_78792_a(slimeLeftEye);
        this.overlay = new ModelRenderer((ModelBase)this, 0, 0);
        this.overlay.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, 0.0f);
    }

    private void setBat() {
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.hideOverlay();
        float f1 = -3.0f;
        float f2 = 5.0f;
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78789_a(-3.0f, -3.0f + f1, -3.0f + f2, 6, 6, 6);
        ModelRenderer ear1 = new ModelRenderer((ModelBase)this, 24, 0);
        ear1.func_78789_a(-4.0f, -6.0f + f1, -2.0f + f2, 3, 4, 1);
        this.head.func_78792_a(ear1);
        ModelRenderer ear2 = new ModelRenderer((ModelBase)this, 24, 0);
        ear2.field_78809_i = true;
        ear2.func_78789_a(1.0f, -6.0f + f1, -2.0f + f2, 3, 4, 1);
        this.head.func_78792_a(ear2);
    }

    private void setOcelot() {
        this.func_78085_a("head.main", 0, 0);
        this.func_78085_a("head.nose", 0, 24);
        this.func_78085_a("head.ear1", 0, 10);
        this.func_78085_a("head.ear2", 6, 10);
        this.hideOverlay();
        this.head = new ModelRenderer((ModelBase)this, "head");
        float f1 = -2.0f;
        float f2 = 2.0f;
        this.head.func_78786_a("main", -2.5f, -2.0f + f1, -3.0f + f2, 5, 4, 5);
        this.head.func_78786_a("nose", -1.5f, 0.0f + f1, -4.0f + f2, 3, 2, 2);
        this.head.func_78786_a("ear1", -2.0f, -3.0f + f1, 0.0f + f2, 1, 1, 2);
        this.head.func_78786_a("ear2", 1.0f, -3.0f + f1, 0.0f + f2, 1, 1, 2);
    }

    private void setSquirrel() {
        this.field_78090_t = 32;
        this.field_78089_u = 32;
        this.hideOverlay();
        this.func_78085_a("head.head", 0, 0);
        this.func_78085_a("head.ear2", 16, 0);
        this.func_78085_a("head.ear1", 16, 0);
        this.head = new ModelRenderer((ModelBase)this, "head");
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.setRotation(this.head, 0.0f, 0.0f, 0.0f);
        float f = 3.0f;
        float f2 = 1.0f;
        this.head.func_78786_a("head", -2.0f, -5.0f + f2, -3.0f + f, 4, 4, 4);
        this.head.func_78786_a("ear2", -2.0f, -6.0f + f2, -0.5f + f, 1, 1, 1);
        this.head.func_78786_a("ear1", 1.0f, -6.0f + f2, -0.5f + f, 1, 1, 1);
    }

    private void setTowerGolem() {
        this.field_78090_t = 128;
        this.field_78089_u = 64;
        this.hideOverlay();
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        float f = 2.0f;
        this.head.func_78784_a(0, 0).func_78789_a(-3.5f, -10.0f + f, -3.0f + f, 7, 8, 6);
        this.head.func_78784_a(0, 14).func_78789_a(-4.0f, -6.0f + f, -3.5f + f, 8, 4, 6);
    }

    private void setPinchBeetle() {
        this.hideOverlay();
        float f = 4.0f;
        float f2 = -2.0f;
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78789_a(-4.0f, -4.0f + f2, -6.0f + f, 8, 6, 6);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        ModelRenderer jaw1a = new ModelRenderer((ModelBase)this, 40, 6);
        jaw1a.func_78789_a(-1.0f, -1.0f, -1.5f, 8, 2, 3);
        jaw1a.func_78793_a(-3.0f, 1.0f + f2, -6.0f + f);
        this.setRotation(jaw1a, 0.0f, 2.635447f, 0.0f);
        ModelRenderer jaw1b = new ModelRenderer((ModelBase)this, 40, 10);
        jaw1b.func_78789_a(-1.0f, -1.0f, -1.0f, 10, 2, 2);
        jaw1b.func_78793_a(7.0f, 0.0f, 0.0f);
        this.setRotation(jaw1b, 0.0f, -1.047197f, 0.0f);
        ModelRenderer jaw2a = new ModelRenderer((ModelBase)this, 40, 6);
        jaw2a.func_78789_a(-1.0f, -1.0f, -1.5f, 8, 2, 3);
        jaw2a.func_78793_a(3.0f, 1.0f + f2, -6.0f + f);
        this.setRotation(jaw2a, 0.0f, 0.541052f, 0.0f);
        ModelRenderer jaw2b = new ModelRenderer((ModelBase)this, 40, 10);
        jaw2b.func_78789_a(-1.0f, -1.0f, -1.0f, 10, 2, 2);
        jaw2b.func_78793_a(7.0f, 0.0f, 0.0f);
        this.setRotation(jaw2b, 0.0f, 1.047197f, 0.0f);
        ModelRenderer antenna1 = new ModelRenderer((ModelBase)this, 42, 4);
        antenna1.func_78789_a(0.0f, -0.5f, -0.5f, 10, 1, 1);
        antenna1.func_78793_a(1.0f, -3.0f + f2, -5.0f + f);
        this.setRotation(antenna1, 0.0f, 1.047198f, -0.296706f);
        ModelRenderer antenna2 = new ModelRenderer((ModelBase)this, 42, 4);
        antenna2.func_78789_a(0.0f, -0.5f, -0.5f, 10, 1, 1);
        antenna2.func_78793_a(-1.0f, -3.0f + f2, -5.0f + f);
        this.setRotation(antenna2, 0.0f, 2.094395f, 0.296706f);
        ModelRenderer eye1 = new ModelRenderer((ModelBase)this, 15, 12);
        eye1.func_78789_a(-1.5f, -1.5f, -1.5f, 3, 3, 3);
        eye1.func_78793_a(-3.0f, -2.0f + f2, -5.0f + f);
        ModelRenderer eye2 = new ModelRenderer((ModelBase)this, 15, 12);
        eye2.func_78789_a(-1.5f, -1.5f, -1.5f, 3, 3, 3);
        eye2.func_78793_a(3.0f, -2.0f + f2, -5.0f + f);
        ModelRenderer tooth1a = new ModelRenderer((ModelBase)this, 0, 0);
        tooth1a.func_78789_a(0.0f, -0.5f, -0.0f, 2, 1, 1);
        tooth1a.func_78793_a(9.0f, 0.0f, 0.0f);
        this.setRotation(tooth1a, 0.0f, -0.5235987f, 0.0f);
        ModelRenderer tooth1b = new ModelRenderer((ModelBase)this, 0, 0);
        tooth1b.func_78789_a(-2.5f, -0.5f, -0.0f, 2, 1, 1);
        tooth1b.func_78793_a(6.0f, 0.0f, 0.0f);
        this.setRotation(tooth1b, 0.0f, 1.5707963f, 0.0f);
        ModelRenderer tooth1c = new ModelRenderer((ModelBase)this, 0, 0);
        tooth1c.func_78789_a(-2.5f, -0.5f, -0.0f, 2, 1, 1);
        tooth1c.func_78793_a(3.0f, 0.0f, 0.0f);
        this.setRotation(tooth1c, 0.0f, 1.5707963f, 0.0f);
        ModelRenderer tooth2a = new ModelRenderer((ModelBase)this, 0, 0);
        tooth2a.func_78789_a(0.0f, -0.5f, -1.0f, 2, 1, 1);
        tooth2a.func_78793_a(9.0f, 0.0f, 0.0f);
        this.setRotation(tooth2a, 0.0f, 0.5235987f, 0.0f);
        ModelRenderer tooth2b = new ModelRenderer((ModelBase)this, 0, 0);
        tooth2b.func_78789_a(-2.5f, -0.5f, -1.0f, 2, 1, 1);
        tooth2b.func_78793_a(6.0f, 0.0f, 0.0f);
        this.setRotation(tooth2b, 0.0f, -1.5707963f, 0.0f);
        ModelRenderer tooth2c = new ModelRenderer((ModelBase)this, 0, 0);
        tooth2c.func_78789_a(-2.5f, -0.5f, -1.0f, 2, 1, 1);
        tooth2c.func_78793_a(3.0f, 0.0f, 0.0f);
        this.setRotation(tooth2c, 0.0f, -1.5707963f, 0.0f);
        this.head.func_78792_a(jaw1a);
        jaw1a.func_78792_a(jaw1b);
        jaw1b.func_78792_a(tooth1a);
        jaw1b.func_78792_a(tooth1b);
        jaw1b.func_78792_a(tooth1c);
        jaw2b.func_78792_a(tooth2a);
        jaw2b.func_78792_a(tooth2b);
        jaw2b.func_78792_a(tooth2c);
        this.head.func_78792_a(jaw2a);
        jaw2a.func_78792_a(jaw2b);
        this.head.func_78792_a(antenna1);
        this.head.func_78792_a(antenna2);
        this.head.func_78792_a(eye1);
        this.head.func_78792_a(eye2);
    }

    private void setFireBeetle() {
        this.hideOverlay();
        float f = 4.0f;
        float f2 = -2.0f;
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78789_a(-4.0f, -4.0f + f2, -6.0f + f, 8, 6, 6);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        ModelRenderer jaw1a = new ModelRenderer((ModelBase)this, 0, 0);
        jaw1a.func_78789_a(0.0f, 0.0f, -2.0f, 1, 1, 2);
        jaw1a.func_78793_a(-3.0f, 0.0f + f2, -6.0f + f);
        this.setRotation(jaw1a, 0.3490659f, 0.0f, 0.0f);
        ModelRenderer jaw1b = new ModelRenderer((ModelBase)this, 0, 0);
        jaw1b.func_78789_a(0.0f, 0.0f, 0.0f, 1, 1, 2);
        jaw1b.func_78793_a(0.0f, 0.0f + f2, -2.0f + f);
        this.setRotation(jaw1b, 0.0f, 1.570796f, 0.0f);
        ModelRenderer jaw2a = new ModelRenderer((ModelBase)this, 0, 0);
        jaw2a.func_78789_a(-1.0f, 0.0f, -2.0f, 1, 1, 2);
        jaw2a.func_78793_a(3.0f, 0.0f + f2, -6.0f + f);
        this.setRotation(jaw2a, 0.3490659f, 0.0f, 0.0f);
        ModelRenderer jaw2b = new ModelRenderer((ModelBase)this, 0, 0);
        jaw2b.func_78789_a(0.0f, 0.0f, -2.0f, 1, 1, 2);
        jaw2b.func_78793_a(0.0f, 0.0f + f2, -2.0f + f);
        this.setRotation(jaw2b, 0.0f, 1.570796f, 0.0f);
        ModelRenderer antenna1 = new ModelRenderer((ModelBase)this, 42, 4);
        antenna1.func_78789_a(0.0f, -0.5f, -0.5f, 10, 1, 1);
        antenna1.func_78793_a(1.0f, -3.0f + f2, -5.0f + f);
        this.setRotation(antenna1, 0.0f, 1.047198f, -0.296706f);
        ModelRenderer antenna2 = new ModelRenderer((ModelBase)this, 42, 4);
        antenna2.func_78789_a(0.0f, -0.5f, -0.5f, 10, 1, 1);
        antenna2.func_78793_a(-1.0f, -3.0f + f2, -5.0f + f);
        this.setRotation(antenna2, 0.0f, 2.094395f, 0.296706f);
        ModelRenderer eye1 = new ModelRenderer((ModelBase)this, 15, 12);
        eye1.func_78789_a(-1.5f, -1.5f, -1.5f, 3, 3, 3);
        eye1.func_78793_a(-3.0f, -2.0f + f2, -5.0f + f);
        ModelRenderer eye2 = new ModelRenderer((ModelBase)this, 15, 12);
        eye2.func_78789_a(-1.5f, -1.5f, -1.5f, 3, 3, 3);
        eye2.func_78793_a(3.0f, -2.0f + f2, -5.0f + f);
        this.head.func_78792_a(jaw1a);
        jaw1a.func_78792_a(jaw1b);
        this.head.func_78792_a(jaw2a);
        jaw2a.func_78792_a(jaw2b);
        this.head.func_78792_a(antenna1);
        this.head.func_78792_a(antenna2);
        this.head.func_78792_a(eye1);
        this.head.func_78792_a(eye2);
    }

    private void setSlimeBeetle() {
        this.field_78089_u = 64;
        this.hideOverlay();
        float f = 4.0f;
        float f2 = -2.0f;
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78789_a(-4.0f, -4.0f + f2, -6.0f + f, 8, 6, 6);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        ModelRenderer antenna1 = new ModelRenderer((ModelBase)this, 38, 4);
        antenna1.func_78789_a(0.0f, -0.5f, -0.5f, 12, 1, 1);
        antenna1.func_78793_a(1.0f, -3.0f + f2, -5.0f + f);
        antenna1.field_78795_f = 0.0f;
        antenna1.field_78796_g = 1.047198f;
        antenna1.field_78808_h = -0.296706f;
        ModelRenderer antenna2 = new ModelRenderer((ModelBase)this, 38, 4);
        antenna2.func_78789_a(0.0f, -0.5f, -0.5f, 12, 1, 1);
        antenna2.func_78793_a(-1.0f, -3.0f + f2, -5.0f + f);
        antenna2.field_78795_f = 0.0f;
        antenna2.field_78796_g = 2.094395f;
        antenna2.field_78808_h = 0.296706f;
        ModelRenderer eye1 = new ModelRenderer((ModelBase)this, 15, 12);
        eye1.func_78789_a(-1.5f, -1.5f, -1.5f, 3, 3, 3);
        eye1.func_78793_a(-3.0f, -2.0f + f2, -5.0f + f);
        ModelRenderer eye2 = new ModelRenderer((ModelBase)this, 15, 12);
        eye2.func_78789_a(-1.5f, -1.5f, -1.5f, 3, 3, 3);
        eye2.func_78793_a(3.0f, -2.0f + f2, -5.0f + f);
        ModelRenderer mouth = new ModelRenderer((ModelBase)this, 17, 12);
        mouth.func_78789_a(-1.0f, -1.0f, -1.0f, 2, 2, 1);
        mouth.func_78793_a(0.0f, 1.0f + f2, -6.0f + f);
        this.head.func_78792_a(antenna1);
        this.head.func_78792_a(antenna2);
        this.head.func_78792_a(eye1);
        this.head.func_78792_a(eye2);
        this.head.func_78792_a(mouth);
    }

    private void setPig() {
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, 0.0f);
        this.head.func_78784_a(16, 16).func_78790_a(-2.0f, -4.0f, -5.0f, 4, 3, 1, 0.0f);
        this.hideOverlay();
    }

    private void setCow() {
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78790_a(-4.0f, -8.0f, -2.0f, 8, 8, 6, 0.0f);
        this.head.func_78784_a(22, 0).func_78790_a(-5.0f, -9.0f, 0.0f, 1, 3, 1, 0.0f);
        this.head.func_78784_a(22, 0).func_78790_a(4.0f, -9.0f, 0.0f, 1, 3, 1, 0.0f);
        this.hideOverlay();
    }

    private void setSpider() {
        this.head = new ModelRenderer((ModelBase)this, 32, 4);
        this.head.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, 0.0f);
        this.hideOverlay();
    }

    private void setSheep() {
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78790_a(-3.0f, -7.0f, -4.5f, 6, 6, 8, 0.0f);
        this.overlay = new ModelRenderer((ModelBase)this, 0, 0);
        this.overlay.func_78790_a(-3.0f, -7.0f, -2.5f, 6, 6, 6, 0.6f);
        this.hideOverlay();
    }

    private void setWolf() {
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78790_a(-3.0f, -6.0f, 0.0f, 6, 6, 4, 0.0f);
        this.head.func_78784_a(16, 14).func_78790_a(-3.0f, -8.0f, 2.0f, 2, 2, 1, 0.0f);
        this.head.func_78784_a(16, 14).func_78790_a(1.0f, -8.0f, 2.0f, 2, 2, 1, 0.0f);
        this.head.func_78784_a(0, 10).func_78790_a(-1.5f, -3.0f, -3.0f, 3, 3, 4, 0.0f);
        this.hideOverlay();
    }

    private void setEnderman() {
        ModelEnderman model = new ModelEnderman();
        this.head = model.field_78116_c;
        this.overlay = model.field_78114_d;
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.overlay.func_78793_a(0.0f, 0.0f, 0.0f);
    }

    private void setVillager(int textureSize) {
        this.head = new ModelRenderer((ModelBase)this).func_78787_b(textureSize, textureSize);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_78784_a(0, 0).func_78790_a(-4.0f, -10.0f, -4.0f, 8, 10, 8, 0.0f);
        this.overlay = new ModelRenderer((ModelBase)this).func_78787_b(textureSize, textureSize);
        this.overlay.func_78793_a(0.0f, -2.0f, 0.0f);
        this.overlay.func_78784_a(24, 0).func_78790_a(-1.0f, -1.0f, -6.0f, 2, 4, 2, 0.0f);
    }

    private void setChicken() {
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78790_a(-2.0f, -6.0f, 1.0f, 4, 6, 3, 0.0f);
        this.overlay = new ModelRenderer((ModelBase)this, 14, 0);
        this.overlay.func_78790_a(-2.0f, -4.0f, -1.0f, 4, 2, 2, 0.0f);
        ModelRenderer overlay2 = new ModelRenderer((ModelBase)this, 14, 4);
        overlay2.func_78790_a(-1.0f, -2.0f, 0.0f, 2, 2, 2, 0.0f);
        this.overlay.func_78792_a(overlay2);
    }

    private void setWitch() {
        this.head = new ModelRenderer((ModelBase)this).func_78787_b(64, 128);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_78784_a(0, 0).func_78790_a(-4.0f, -10.0f, -4.0f, 8, 10, 8, 0.0f);
        this.overlay = new ModelRenderer((ModelBase)this).func_78787_b(64, 128);
        this.overlay.func_78793_a(0.0f, -2.0f, 0.0f);
        this.overlay.func_78784_a(24, 0).func_78790_a(-1.0f, -1.0f, -6.0f, 2, 4, 2, 0.0f);
        ModelRenderer wart = new ModelRenderer((ModelBase)this).func_78787_b(64, 128);
        wart.func_78793_a(0.0f, -2.0f, 0.0f);
        wart.func_78784_a(0, 0).func_78790_a(0.0f, 3.0f, -6.75f, 1, 1, 1, -0.25f);
        this.overlay.func_78792_a(wart);
        ModelRenderer hatBase = new ModelRenderer((ModelBase)this).func_78787_b(64, 128);
        hatBase.func_78793_a(-5.0f, -10.03125f, -5.0f);
        hatBase.func_78784_a(0, 64).func_78789_a(0.0f, 0.0f, 0.0f, 10, 2, 10);
        hatBase.field_78795_f = this.head.field_78795_f;
        hatBase.field_78796_g = this.head.field_78796_g;
        this.head.func_78792_a(hatBase);
        ModelRenderer hat1 = new ModelRenderer((ModelBase)this).func_78787_b(64, 128);
        hat1.func_78793_a(1.75f, -4.0f, 2.0f);
        hat1.func_78784_a(0, 76).func_78789_a(0.0f, 0.0f, 0.0f, 7, 4, 7);
        hat1.field_78795_f = -0.05235988f;
        hat1.field_78808_h = 0.02617994f;
        hatBase.func_78792_a(hat1);
        ModelRenderer hat2 = new ModelRenderer((ModelBase)this).func_78787_b(64, 128);
        hat2.func_78793_a(1.75f, -4.0f, 2.0f);
        hat2.func_78784_a(0, 87).func_78789_a(0.0f, 0.0f, 0.0f, 4, 4, 4);
        hat2.field_78795_f = -0.10471976f;
        hat2.field_78808_h = 0.05235988f;
        hat1.func_78792_a(hat2);
        ModelRenderer hat3 = new ModelRenderer((ModelBase)this).func_78787_b(64, 128);
        hat3.func_78793_a(1.75f, -2.0f, 2.0f);
        hat3.func_78784_a(0, 95).func_78790_a(0.0f, 0.0f, 0.0f, 1, 2, 1, 0.25f);
        hat3.field_78795_f = -0.20943952f;
        hat3.field_78808_h = 0.10471976f;
        hat2.func_78792_a(hat3);
    }

    private void setZombieVillager() {
        this.head = new ModelRenderer((ModelBase)this).func_78787_b(64, 64);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_78784_a(0, 32).func_78790_a(-4.0f, -10.0f, -4.0f, 8, 10, 8, 0.0f);
        this.overlay = new ModelRenderer((ModelBase)this).func_78787_b(64, 64);
        this.overlay.func_78793_a(0.0f, -2.0f, 0.0f);
        this.overlay.func_78784_a(24, 32).func_78790_a(-1.0f, -1.0f, -6.0f, 2, 4, 2, 0.0f);
    }

    private void setSquid() {
        this.head = new ModelRenderer((ModelBase)this).func_78787_b(64, 32);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_78789_a(-6.0f, -16.0f, -5.75f, 12, 16, 12);
        this.hideOverlay();
    }

    private void setBunny() {
        this.hideOverlay();
        this.func_78085_a("head.head", 0, 0);
        this.func_78085_a("head.ear2", 16, 0);
        this.func_78085_a("head.ear1", 16, 0);
        this.head = new ModelRenderer((ModelBase)this, "head").func_78787_b(32, 32);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.field_78795_f = 0.0f;
        this.head.field_78796_g = 0.0f;
        this.head.field_78808_h = 0.0f;
        this.head.field_78809_i = true;
        this.head.func_78786_a("head", -2.0f, -4.0f, 0.0f, 4, 4, 4);
        this.head.func_78786_a("ear2", -2.5f, -8.0f, 2.5f, 2, 4, 1);
        this.head.func_78786_a("ear1", 0.5f, -8.0f, 2.5f, 2, 4, 1);
    }

    private void setPenguin() {
        this.head = new ModelRenderer((ModelBase)this, 0, 0).func_78787_b(64, 32);
        this.head.func_78789_a(-3.5f, -5.0f, -3.5f, 7, 5, 7);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.overlay = new ModelRenderer((ModelBase)this, 0, 13);
        this.overlay.func_78789_a(-1.0f, -2.0f, -5.0f, 2, 1, 2);
        this.overlay.func_78793_a(0.0f, 0.0f, 0.0f);
    }

    private void setBighorn() {
        this.setSheep();
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78790_a(-3.0f, -7.0f, -4.5f, 6, 6, 7, 0.0f);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_78784_a(28, 16).func_78790_a(-5.0f, -7.0f, -1.0f, 2, 2, 2, 0.0f);
        this.head.func_78784_a(16, 13).func_78790_a(-6.0f, -8.0f, 0.0f, 2, 2, 4, 0.0f);
        this.head.func_78784_a(16, 19).func_78790_a(-7.0f, -7.0f, 3.0f, 2, 5, 2, 0.0f);
        this.head.func_78784_a(18, 27).func_78790_a(-8.0f, -3.0f, 1.0f, 2, 2, 3, 0.0f);
        this.head.func_78784_a(28, 27).func_78790_a(-9.0f, -4.0f, 0.0f, 2, 2, 1, 0.0f);
        this.head.func_78784_a(28, 16).func_78790_a(3.0f, -7.0f, -1.0f, 2, 2, 2, 0.0f);
        this.head.func_78784_a(16, 13).func_78790_a(4.0f, -8.0f, 0.0f, 2, 2, 4, 0.0f);
        this.head.func_78784_a(16, 19).func_78790_a(5.0f, -7.0f, 3.0f, 2, 5, 2, 0.0f);
        this.head.func_78784_a(18, 27).func_78790_a(6.0f, -3.0f, 1.0f, 2, 2, 3, 0.0f);
        this.head.func_78784_a(28, 27).func_78790_a(7.0f, -4.0f, 0.0f, 2, 2, 1, 0.0f);
        this.overlay = new ModelRenderer((ModelBase)this, 0, 0);
        this.overlay.func_78790_a(-3.0f, -7.0f, -2.5f, 6, 6, 6, 0.6f);
        this.hideOverlay();
    }

    private void setDeer() {
        this.hideOverlay();
        this.head = new ModelRenderer((ModelBase)this, 0, 5);
        this.head.func_78790_a(-2.0f, -8.0f, -2.0f, 4, 6, 6, 0.0f);
        this.head.func_78793_a(0.0f, 2.0f, 0.0f);
        this.head.func_78784_a(52, 0).func_78790_a(-1.5f, -5.0f, -5.0f, 3, 3, 3, 0.0f);
        this.head.func_78784_a(20, 0);
        this.head.func_78790_a(-3.0f, -10.0f, 2.0f, 2, 2, 2, 0.0f);
        this.head.func_78790_a(-3.0f, -10.0f, 2.0f, 2, 2, 2, 0.0f);
        this.head.func_78790_a(-4.0f, -10.0f, 3.0f, 1, 1, 3, 0.0f);
        this.head.func_78790_a(-5.0f, -11.0f, 5.0f, 1, 1, 5, 0.0f);
        this.head.func_78790_a(-5.0f, -14.0f, 7.0f, 1, 4, 1, 0.0f);
        this.head.func_78790_a(-6.0f, -17.0f, 6.0f, 1, 4, 1, 0.0f);
        this.head.func_78790_a(-6.0f, -13.0f, 4.0f, 1, 1, 3, 0.0f);
        this.head.func_78790_a(-6.0f, -14.0f, 1.0f, 1, 1, 4, 0.0f);
        this.head.func_78790_a(-7.0f, -15.0f, -2.0f, 1, 1, 4, 0.0f);
        this.head.func_78790_a(-6.0f, -16.0f, -5.0f, 1, 1, 4, 0.0f);
        this.head.func_78790_a(-7.0f, -18.0f, 3.0f, 1, 5, 1, 0.0f);
        this.head.func_78790_a(-6.0f, -19.0f, -2.0f, 1, 5, 1, 0.0f);
        this.head.func_78790_a(1.0f, -10.0f, 2.0f, 2, 2, 2, 0.0f);
        this.head.func_78790_a(3.0f, -10.0f, 3.0f, 1, 1, 3, 0.0f);
        this.head.func_78790_a(4.0f, -11.0f, 5.0f, 1, 1, 5, 0.0f);
        this.head.func_78790_a(4.0f, -14.0f, 6.0f, 1, 4, 1, 0.0f);
        this.head.func_78790_a(5.0f, -17.0f, 7.0f, 1, 4, 1, 0.0f);
        this.head.func_78790_a(5.0f, -13.0f, 4.0f, 1, 1, 3, 0.0f);
        this.head.func_78790_a(5.0f, -14.0f, 1.0f, 1, 1, 4, 0.0f);
        this.head.func_78790_a(6.0f, -15.0f, -2.0f, 1, 1, 4, 0.0f);
        this.head.func_78790_a(5.0f, -16.0f, -5.0f, 1, 1, 4, 0.0f);
        this.head.func_78790_a(6.0f, -18.0f, 3.0f, 1, 5, 1, 0.0f);
        this.head.func_78790_a(5.0f, -19.0f, -2.0f, 1, 5, 1, 0.0f);
    }

    private void setBoar() {
        this.hideOverlay();
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78790_a(-4.0f, -2.0f, -2.0f, 8, 7, 6, 0.0f);
        this.head.func_78793_a(0.0f, -5.0f, 0.0f);
        this.head.func_78784_a(28, 0).func_78790_a(-3.0f, 1.0f, -5.0f, 6, 4, 3, 0.0f);
        this.head.func_78784_a(17, 17).func_78790_a(3.0f, 2.0f, -5.0f, 1, 2, 1, 0.0f);
        this.head.func_78784_a(17, 17).func_78790_a(-4.0f, 2.0f, -5.0f, 1, 2, 1, 0.0f);
    }

    private void setRedcap() {
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78790_a(-3.4f, -7.0f, -4.0f, 7, 7, 7, 0.0f);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.overlay = new ModelRenderer((ModelBase)this, 32, 0);
        this.overlay.func_78790_a(-2.0f, -8.0f, -3.0f, 4, 5, 7, 0.0f);
        this.overlay.func_78793_a(0.0f, 0.0f, 0.0f);
        ModelRenderer goblinRightEar = new ModelRenderer((ModelBase)this, 48, 20);
        goblinRightEar.func_78790_a(3.0f, -7.0f, -1.0f, 2, 3, 1, 0.0f);
        goblinRightEar.func_78793_a(0.0f, 0.0f, 0.0f);
        ModelRenderer goblinLeftEar = new ModelRenderer((ModelBase)this, 48, 24);
        goblinLeftEar.func_78790_a(-5.0f, -7.0f, -1.0f, 2, 3, 1, 0.0f);
        goblinLeftEar.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_78792_a(goblinLeftEar);
        this.head.func_78792_a(goblinRightEar);
    }

    private void setGhast() {
        this.hideOverlay();
        this.field_78090_t = 32;
        this.field_78089_u = 16;
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, 0.0f);
    }

    private void setEnderDragon() {
        float f1 = -14.0f;
        float f2 = -8.0f;
        this.field_78090_t = 256;
        this.field_78089_u = 256;
        this.func_78085_a("head.upperhead", 112, 30);
        this.func_78085_a("head.upperlip", 176, 44);
        this.func_78085_a("head.scale", 0, 0);
        this.func_78085_a("head.nostril", 112, 0);
        this.func_78085_a("jaw.jaw", 176, 65);
        this.head = new ModelRenderer((ModelBase)this, "head");
        this.head.func_78786_a("upperlip", -6.0f, -1.0f + f2, -8.0f + f1, 12, 5, 16);
        this.head.func_78786_a("upperhead", -8.0f, -8.0f + f2, 6.0f + f1, 16, 16, 16);
        this.head.field_78809_i = true;
        this.head.func_78786_a("scale", -5.0f, -12.0f + f2, 12.0f + f1, 2, 4, 6);
        this.head.func_78786_a("nostril", -5.0f, -3.0f + f2, -6.0f + f1, 2, 2, 4);
        this.head.field_78809_i = false;
        this.head.func_78786_a("scale", 3.0f, -12.0f + f2, 12.0f + f1, 2, 4, 6);
        this.head.func_78786_a("nostril", 3.0f, -3.0f + f2, -6.0f + f1, 2, 2, 4);
        this.overlay = new ModelRenderer((ModelBase)this, "jaw");
        this.overlay.func_78793_a(0.0f, 4.0f + f2, 8.0f + f1);
        this.overlay.func_78786_a("jaw", -6.0f, 0.0f, -16.0f, 12, 4, 16);
        this.overlay.field_78795_f = 0.2f;
        this.head.func_78792_a(this.overlay);
        this.hideOverlay();
    }

    private void setKobold() {
        float f = 1.0f;
        this.hideOverlay();
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78789_a(-3.5f, -7.0f + f, -3.0f + f, 7, 6, 6);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        ModelRenderer rightear = new ModelRenderer((ModelBase)this, 48, 20);
        rightear.func_78789_a(0.0f, -4.0f, 0.0f, 4, 4, 1);
        rightear.func_78793_a(3.5f, -3.0f + f, -1.0f + f);
        rightear.field_78796_g = 0.2617994f;
        rightear.field_78808_h = -0.3490659f;
        this.head.func_78792_a(rightear);
        ModelRenderer leftear = new ModelRenderer((ModelBase)this, 48, 25);
        leftear.func_78789_a(-4.0f, -4.0f, 0.0f, 4, 4, 1);
        leftear.func_78793_a(-3.5f, -3.0f + f, -1.0f + f);
        leftear.field_78796_g = -0.2617994f;
        leftear.field_78808_h = 0.3490659f;
        this.head.func_78792_a(leftear);
        ModelRenderer snout = new ModelRenderer((ModelBase)this, 28, 0);
        snout.func_78789_a(-1.5f, -2.0f, -2.0f, 3, 2, 3);
        snout.func_78793_a(0.0f, -2.0f + f, -3.0f + f);
        this.head.func_78792_a(snout);
        ModelRenderer jaw = new ModelRenderer((ModelBase)this, 28, 5);
        jaw.func_78789_a(-1.5f, 0.0f, -2.0f, 3, 1, 3);
        jaw.func_78793_a(0.0f, -2.0f + f, -3.0f + f);
        jaw.field_78795_f = 0.20944f;
        this.head.func_78792_a(jaw);
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }
}

