/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.devdelight;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.rftools.items.devdelight.DelightingInfoHelper;
import mcjty.rftools.items.devdelight.GuiDevelopersDelight;
import mcjty.rftools.network.NetworkTools;

public class PacketDelightingInfoReady
implements IMessage,
IMessageHandler<PacketDelightingInfoReady, IMessage> {
    private List<String> blockClasses;
    private List<String> teClasses;
    private Map<String, DelightingInfoHelper.NBTDescription> nbtData;
    private int metadata;

    public void fromBytes(ByteBuf buf) {
        int i;
        int size = buf.readInt();
        this.blockClasses = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.blockClasses.add(NetworkTools.readString(buf));
        }
        size = buf.readInt();
        this.teClasses = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.teClasses.add(NetworkTools.readString(buf));
        }
        size = buf.readInt();
        this.nbtData = new HashMap<String, DelightingInfoHelper.NBTDescription>(size);
        for (i = 0; i < size; ++i) {
            String key = NetworkTools.readString(buf);
            String type = NetworkTools.readString(buf);
            String value = NetworkTools.readString(buf);
            this.nbtData.put(key, new DelightingInfoHelper.NBTDescription(type, value));
        }
        this.metadata = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.blockClasses.size());
        for (String string : this.blockClasses) {
            NetworkTools.writeString(buf, string);
        }
        buf.writeInt(this.teClasses.size());
        for (String string : this.teClasses) {
            NetworkTools.writeString(buf, string);
        }
        buf.writeInt(this.nbtData.size());
        for (Map.Entry entry : this.nbtData.entrySet()) {
            String key = (String)entry.getKey();
            DelightingInfoHelper.NBTDescription value = (DelightingInfoHelper.NBTDescription)entry.getValue();
            NetworkTools.writeString(buf, key);
            NetworkTools.writeString(buf, value.getType());
            NetworkTools.writeString(buf, value.getValue());
        }
        buf.writeInt(this.metadata);
    }

    public PacketDelightingInfoReady() {
    }

    public PacketDelightingInfoReady(List<String> blockClasses, List<String> teClasses, Map<String, DelightingInfoHelper.NBTDescription> nbtData, int metadata) {
        this.blockClasses = new ArrayList<String>(blockClasses);
        this.teClasses = new ArrayList<String>(teClasses);
        this.nbtData = new HashMap<String, DelightingInfoHelper.NBTDescription>(nbtData);
        this.metadata = metadata;
    }

    public IMessage onMessage(PacketDelightingInfoReady message, MessageContext ctx) {
        GuiDevelopersDelight.setServerBlockClasses(message.blockClasses);
        GuiDevelopersDelight.setServerTEClasses(message.teClasses);
        GuiDevelopersDelight.setServerNBTData(message.nbtData);
        GuiDevelopersDelight.setMetadata(message.metadata);
        return null;
    }
}

