/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;
import powercrystals.minefactoryreloaded.api.ReplacementBlock;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiPlanter;
import powercrystals.minefactoryreloaded.gui.container.ContainerPlanter;
import powercrystals.minefactoryreloaded.gui.container.ContainerUpgradable;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityPlanter
extends TileEntityFactoryPowered {
    protected boolean keepLastItem = false;

    public TileEntityPlanter() {
        super(Machine.Planter);
        TileEntityPlanter.createHAM(this, 1);
        this._areaManager.setOverrideDirection(ForgeDirection.UP);
        this._areaManager.setOriginOffset(0, 1, 0);
        this.setManageSolids(true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiPlanter(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerUpgradable getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerPlanter(this, inventoryPlayer);
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._areaManager.updateUpgradeLevel(this._inventory[9]);
    }

    @Override
    public boolean activateMachine() {
        BlockPosition blockPosition = this._areaManager.getNextBlock();
        if (!this.field_145850_b.func_72899_e(blockPosition.x, blockPosition.y, blockPosition.z)) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        ItemStack itemStack = this._inventory[this.getPlanterSlotIdFromBp(blockPosition)];
        for (int i = 10; i <= 25; ++i) {
            IFactoryPlantable iFactoryPlantable;
            ItemStack itemStack2 = this.func_70301_a(i);
            if (itemStack2 == null || itemStack != null && !this.stacksEqual(itemStack, itemStack2) || !MFRRegistry.getPlantables().containsKey(itemStack2.func_77973_b()) || this.keepLastItem && itemStack2.field_77994_a < 2 || !(iFactoryPlantable = MFRRegistry.getPlantables().get(itemStack2.func_77973_b())).canBePlanted(itemStack2, false) || !iFactoryPlantable.canBePlantedHere(this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z, itemStack2)) continue;
            iFactoryPlantable.prePlant(this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z, itemStack2);
            ReplacementBlock replacementBlock = iFactoryPlantable.getPlantedBlock(this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z, itemStack2);
            if (replacementBlock == null || !replacementBlock.replaceBlock(this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z, itemStack2)) continue;
            iFactoryPlantable.postPlant(this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z, itemStack2);
            this.func_70298_a(i, 1);
            return true;
        }
        this.setIdleTicks(this.getIdleTicksMax());
        return false;
    }

    @Override
    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74757_a("keepLastItem", this.keepLastItem);
    }

    @Override
    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        this.keepLastItem = nBTTagCompound.func_74767_n("keepLastItem");
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        nBTTagCompound.func_74757_a("keepLastItem", this.keepLastItem);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.keepLastItem = nBTTagCompound.func_74767_n("keepLastItem");
    }

    protected boolean stacksEqual(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null || !itemStack.func_77973_b().equals(itemStack2.func_77973_b()) || itemStack.func_77960_j() != itemStack2.func_77960_j() || itemStack.func_77942_o() != itemStack2.func_77942_o()) {
            return false;
        }
        if (!itemStack.func_77942_o()) {
            return true;
        }
        NBTTagCompound nBTTagCompound = (NBTTagCompound)itemStack.func_77978_p().func_74737_b();
        NBTTagCompound nBTTagCompound2 = (NBTTagCompound)itemStack2.func_77978_p().func_74737_b();
        nBTTagCompound.func_82580_o("display");
        nBTTagCompound2.func_82580_o("display");
        nBTTagCompound.func_82580_o("ench");
        nBTTagCompound2.func_82580_o("ench");
        nBTTagCompound.func_82580_o("RepairCost");
        nBTTagCompound2.func_82580_o("RepairCost");
        return nBTTagCompound.equals((Object)nBTTagCompound2);
    }

    protected int getPlanterSlotIdFromBp(BlockPosition blockPosition) {
        int n = this._areaManager.getRadius();
        int n2 = Math.round(1.49f * (float)(blockPosition.x - this.field_145851_c) / (float)n);
        int n3 = Math.round(1.49f * (float)(blockPosition.z - this.field_145849_e) / (float)n);
        return 4 + n2 + 3 * n3;
    }

    public boolean getConsumeAll() {
        return this.keepLastItem;
    }

    public void setConsumeAll(boolean bl) {
        this.keepLastItem = bl;
    }

    public int func_70302_i_() {
        return 26;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 5;
    }

    @Override
    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 9;
    }

    @Override
    public boolean shouldDropSlotWhenBroken(int n) {
        return n > 8;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 17;
    }

    @Override
    protected int getUpgradeSlot() {
        return 9;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        if (itemStack != null) {
            if (n > 9) {
                IFactoryPlantable iFactoryPlantable = MFRRegistry.getPlantables().get(itemStack.func_77973_b());
                return iFactoryPlantable != null && iFactoryPlantable.canBePlanted(itemStack, false);
            }
            if (n == 9) {
                return this.isUsableAugment(itemStack);
            }
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return n >= 10;
    }
}

