/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.render.block;

import cofh.repack.codechicken.lib.lighting.LightModel;
import cofh.repack.codechicken.lib.render.CCModel;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.render.uv.IconTransformation;
import cofh.repack.codechicken.lib.vec.Rotation;
import cofh.repack.codechicken.lib.vec.Scale;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.Translation;
import cofh.repack.codechicken.lib.vec.Vector3;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.io.InputStream;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;

public class RedNetLogicRenderer
implements ISimpleBlockRenderingHandler {
    protected static CCModel base;
    protected static CCModel cards;
    public static IconTransformation uvt;
    private static final double rotAmt = 1.5707963267948966;
    private static final Vector3 axis;
    private static final Rotation itemRot;

    private static void compute(CCModel cCModel) {
        cCModel.apply((Transformation)new Rotation(Math.PI, axis));
        cCModel.computeNormals();
        cCModel.shrinkUVs(9.765625E-4);
    }

    public static void updateUVT(IIcon iIcon) {
        uvt = new IconTransformation(iIcon);
    }

    public void renderInventoryBlock(Block block, int n, int n2, RenderBlocks renderBlocks) {
        CCRenderState.reset();
        CCRenderState.useNormals = true;
        CCRenderState.computeLighting = false;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        base.render(new CCRenderState.IVertexOperation[]{itemRot, uvt});
        cards.render(new CCRenderState.IVertexOperation[]{itemRot, uvt});
        tessellator.func_78381_a();
    }

    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int n, int n2, int n3, Block block, int n4, RenderBlocks renderBlocks) {
        CCRenderState.reset();
        CCRenderState.useNormals = true;
        int n5 = block.func_149677_c(iBlockAccess, n, n2, n3);
        int n6 = iBlockAccess.func_72805_g(n, n2, n3);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        tessellator.func_78380_c(n5);
        Rotation rotation = new Rotation(1.5707963267948966 * (double)(~n6 & 3), axis);
        Translation translation = new Translation(new Vector3((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5));
        base.render(new CCRenderState.IVertexOperation[]{rotation.with((Transformation)translation), LightModel.standardLightModel, uvt});
        cards.render(new CCRenderState.IVertexOperation[]{rotation.with((Transformation)translation), LightModel.standardLightModel, uvt});
        return true;
    }

    public boolean shouldRender3DInInventory(int n) {
        return true;
    }

    public int getRenderId() {
        return MineFactoryReloadedCore.renderIdRedNetLogic;
    }

    static {
        axis = Rotation.axes[1];
        itemRot = new Rotation(-1.5707963267948966, axis);
        try {
            Map map = CCModel.parseObjModels((InputStream)MineFactoryReloadedCore.class.getResourceAsStream("/powercrystals/minefactoryreloaded/models/RedComp.obj"), (int)7, (Transformation)new Scale(0.0625));
            base = ((CCModel)map.get("case")).backfacedCopy();
            RedNetLogicRenderer.compute(base);
            cards = ((CCModel)map.get("cards")).backfacedCopy();
            RedNetLogicRenderer.compute(cards);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

