/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.rpc;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import openmods.datastore.IDataVisitor;
import openmods.network.rpc.IRpcTarget;

public class TargetWrapperRegistry
implements IDataVisitor<String, Integer> {
    private BiMap<Class<? extends IRpcTarget>, Integer> wrapperCls = HashBiMap.create();

    @Override
    public void begin(int size) {
        this.wrapperCls.clear();
    }

    @Override
    public void entry(String clsName, Integer clsId) {
        Class<?> cls;
        try {
            cls = Class.forName(clsName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Failed to load class %s", clsName), e);
        }
        Preconditions.checkArgument((boolean)IRpcTarget.class.isAssignableFrom(cls), (String)"Class %s is not ITargetWrapper", (Object[])new Object[]{cls});
        try {
            cls.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Class %s has no parameterless constructor", clsName), e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        Class<?> wrapperCls = cls;
        this.wrapperCls.put(wrapperCls, (Object)clsId);
    }

    @Override
    public void end() {
    }

    public int getWrapperId(Class<? extends IRpcTarget> cls) {
        Integer id = (Integer)this.wrapperCls.get(cls);
        Preconditions.checkNotNull((Object)id, (String)"Wrapper class %s is not registered", (Object[])new Object[]{cls});
        return id;
    }

    public IRpcTarget createWrapperFromId(int id) {
        Class cls = (Class)this.wrapperCls.inverse().get((Object)id);
        Preconditions.checkNotNull((Object)cls, (String)"Can't find class for id %s", (Object[])new Object[]{id});
        try {
            return (IRpcTarget)cls.newInstance();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

