/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.debughelper;

import cofh.core.network.ITileInfoPacketHandler;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketTileInfo;
import cofh.lib.util.position.BlockPosition;
import cofh.lib.util.position.ChunkCoord;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.chunk.Chunk;

public class PacketMultiTileInfo
extends PacketCoFHBase {
    public ByteArrayInputStream stream;
    public byte[] data;

    public static HashMap<ChunkCoord, List<BlockPosition>> buildList(Collection<IMultiBlock> collection) {
        HashMap<ChunkCoord, List<BlockPosition>> hashMap = new HashMap<ChunkCoord, List<BlockPosition>>();
        for (IMultiBlock iMultiBlock : collection) {
            BlockPosition blockPosition = new BlockPosition(iMultiBlock.x(), iMultiBlock.y(), iMultiBlock.z());
            ChunkCoord chunkCoord = new ChunkCoord(blockPosition);
            List<BlockPosition> list = hashMap.get(chunkCoord);
            if (list == null) {
                list = new LinkedList<BlockPosition>();
                hashMap.put(chunkCoord, list);
            }
            list.add(blockPosition);
        }
        return hashMap;
    }

    public PacketMultiTileInfo() {
    }

    public PacketMultiTileInfo(HashMap<ChunkCoord, List<BlockPosition>> hashMap) {
        this.addInt(hashMap.entrySet().size());
        for (Map.Entry<ChunkCoord, List<BlockPosition>> entry : hashMap.entrySet()) {
            this.addInt(entry.getKey().chunkX);
            this.addInt(entry.getKey().chunkZ);
            this.addShort(entry.getValue().size());
            for (BlockPosition blockPosition : entry.getValue()) {
                this.addByte((blockPosition.x & 0xF) << 4 | blockPosition.z & 0xF);
                this.addByte(blockPosition.y);
            }
        }
    }

    public void handlePacket(EntityPlayer entityPlayer, boolean bl) {
        int n = this.getInt();
        ArrayList<ITileInfoPacketHandler> arrayList = new ArrayList<ITileInfoPacketHandler>();
        for (int i = 0; i < n; ++i) {
            Chunk chunk = entityPlayer.field_70170_p.func_72964_e(this.getInt(), this.getInt());
            int n2 = this.getShort();
            for (int j = 0; j < n2; ++j) {
                byte by = this.getByte();
                TileEntity tileEntity = chunk.getTileEntityUnsafe(by >> 4, this.getInt(), by & 0xF);
                if (!(tileEntity instanceof ITileInfoPacketHandler)) continue;
                arrayList.add((ITileInfoPacketHandler)tileEntity);
            }
        }
        byte[] byArray = new byte[this.stream.available()];
        assert (this.stream.read(byArray, 0, byArray.length) == byArray.length);
        PacketTileInfo packetTileInfo = new PacketTileInfo();
        for (ITileInfoPacketHandler iTileInfoPacketHandler : arrayList) {
            packetTileInfo.datain = new DataInputStream(new ByteArrayInputStream(byArray));
            iTileInfoPacketHandler.handleTileInfoPacket((PacketCoFHBase)packetTileInfo, bl, entityPlayer);
        }
    }

    public void decodeInto(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        this.stream = new ByteArrayInputStream(byteBuf.array());
        this.datain = new DataInputStream(this.stream);
        try {
            this.datain.skipBytes(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

