/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.PacketPowerStorage;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.ICapacitor;
import crazypants.enderio.power.IInternalPoweredTile;
import crazypants.vecmath.VecmathUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractPoweredMachineEntity
extends AbstractMachineEntity
implements IInternalPoweredTile {
    protected Capacitors capacitorType = Capacitors.BASIC_CAPACITOR;
    private int storedEnergyRF;
    protected float lastSyncPowerStored = -1.0f;

    protected AbstractPoweredMachineEntity(SlotDefinition slotDefinition) {
        super(slotDefinition);
    }

    @Override
    public void func_145845_h() {
        boolean powerChanged;
        super.func_145845_h();
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        boolean bl = powerChanged = this.lastSyncPowerStored != (float)this.storedEnergyRF && this.field_145850_b.func_82737_E() % 5L == 0L;
        if (powerChanged) {
            this.lastSyncPowerStored = this.storedEnergyRF;
            PacketHandler.sendToAllAround(new PacketPowerStorage(this), this);
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return !this.isSideDisabled(from.ordinal());
    }

    @Override
    public int getMaxEnergyRecieved(ForgeDirection dir) {
        if (this.isSideDisabled(dir.ordinal())) {
            return 0;
        }
        return this.getCapacitor().getMaxEnergyReceived();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.getCapacitor().getMaxEnergyStored();
    }

    @Override
    public void setEnergyStored(int stored) {
        this.storedEnergyRF = MathHelper.func_76125_a((int)stored, (int)0, (int)this.getMaxEnergyStored());
    }

    @Override
    public int getEnergyStored() {
        return this.storedEnergyRF;
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    public boolean hasPower() {
        return this.storedEnergyRF > 0;
    }

    public ICapacitor getCapacitor() {
        return this.capacitorType.capacitor;
    }

    public int getEnergyStoredScaled(int scale) {
        return VecmathUtil.clamp(Math.round((float)scale * ((float)this.storedEnergyRF / (float)this.getMaxEnergyStored())), 0, scale);
    }

    public void setCapacitor(Capacitors capacitorType) {
        this.capacitorType = capacitorType;
        this.forceClientUpdate = true;
        this.setEnergyStored(this.getEnergyStored());
    }

    public int getPowerUsePerTick() {
        return this.getCapacitor().getMaxEnergyExtracted();
    }

    @Override
    public void func_70299_a(int slot, ItemStack contents) {
        super.func_70299_a(slot, contents);
        if (this.slotDefinition.isUpgradeSlot(slot)) {
            this.updateCapacitorFromSlot();
        }
    }

    @Override
    public ItemStack func_70298_a(int fromSlot, int amount) {
        ItemStack res = super.func_70298_a(fromSlot, amount);
        if (this.slotDefinition.isUpgradeSlot(fromSlot)) {
            this.updateCapacitorFromSlot();
        }
        return res;
    }

    private void updateCapacitorFromSlot() {
        if (this.slotDefinition.getNumUpgradeSlots() <= 0) {
            this.setCapacitor(Capacitors.BASIC_CAPACITOR);
            return;
        }
        ItemStack contents = this.inventory[this.slotDefinition.minUpgradeSlot];
        if (contents == null || contents.func_77973_b() != EnderIO.itemBasicCapacitor) {
            this.setCapacitor(Capacitors.BASIC_CAPACITOR);
        } else {
            this.setCapacitor(Capacitors.values()[contents.func_77960_j()]);
        }
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        int energy;
        super.readCommon(nbtRoot);
        this.setCapacitor(Capacitors.values()[nbtRoot.func_74765_d("capacitorType")]);
        if (nbtRoot.func_74764_b("storedEnergy")) {
            float storedEnergyMJ = nbtRoot.func_74760_g("storedEnergy");
            energy = (int)(storedEnergyMJ * 10.0f);
        } else {
            energy = nbtRoot.func_74762_e("storedEnergyRF");
        }
        this.setEnergyStored(energy);
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        nbtRoot.func_74768_a("storedEnergyRF", this.storedEnergyRF);
        nbtRoot.func_74777_a("capacitorType", (short)this.capacitorType.ordinal());
    }
}

