/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockSided;
import com.carpentersblocks.data.Ladder;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.EntityLivingUtil;
import com.carpentersblocks.util.registry.BlockRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersLadder
extends BlockSided {
    public static final String[] type = new String[]{"default", "rail", "pole"};
    private static Ladder data = new Ladder();

    public BlockCarpentersLadder(Material material) {
        super(material, data);
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int temp = data.getType(TE);
        if (++temp > type.length - 1) {
            temp = 0;
        }
        data.setType(TE, temp);
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        int temp = data.getType(TE);
        if (--temp < 0) {
            temp = type.length - 1;
        }
        data.setType(TE, temp);
        return true;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null) {
            ForgeDirection dir = data.getDirection(TE);
            switch (dir) {
                case DOWN: {
                    this.func_149676_a(0.0f, 0.0f, 0.375f, 1.0f, 1.0f, 0.625f);
                    break;
                }
                case UP: {
                    this.func_149676_a(0.375f, 0.0f, 0.0f, 0.625f, 1.0f, 1.0f);
                    break;
                }
                default: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.1875f, dir);
                }
            }
        }
    }

    @Override
    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        boolean result = super.func_149707_d(world, x, y, z, side);
        if (!result && side < 2) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            result = world.func_147439_a(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ).equals((Object)this);
        }
        return result;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        if (world.func_72805_g(x, y, z) < 2) {
            ForgeDirection facing = EntityLivingUtil.getFacing(entityLiving).getOpposite();
            if (facing.offsetX != 0) {
                world.func_72921_c(x, y, z, 1, 0);
            } else {
                world.func_72921_c(x, y, z, 0, 0);
            }
        }
        for (int side = 0; side < 2; ++side) {
            TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            if (!world.func_147439_a(x, y + dir.offsetY, z).equals((Object)this)) continue;
            TEBase TE_adj = (TEBase)world.func_147438_o(x, y + dir.offsetY, z);
            data.setType(TE, data.getType(TE_adj));
        }
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && !data.isFreestanding(TE)) {
            super.func_149695_a(world, x, y, z, block);
        }
    }

    public boolean isLadder(IBlockAccess blockAccess, int x, int y, int z, EntityLivingBase entityLiving) {
        return true;
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersLadderRenderID;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        ForgeDirection[] axises = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
        return axises;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TEBase) {
            TEBase cbTile = (TEBase)tile;
            int data = cbTile.getData();
            int dataAngle = data % 2;
            switch (dataAngle) {
                case 0: {
                    cbTile.setData(data + 1);
                    break;
                }
                case 1: {
                    cbTile.setData(data - 1);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

