/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.api.IPointable;
import openblocks.common.entity.EntityItemProjectile;
import openblocks.rpc.ICannon;
import openmods.api.ISurfaceAttachment;
import openmods.inventory.legacy.ItemDistribution;
import openmods.sync.SyncableDouble;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.InventoryUtils;
import openmods.utils.render.GeometryUtils;

public class TileEntityCannon
extends SyncedTileEntity
implements IPointable,
ISurfaceAttachment,
ICannon {
    private static final int YAW_CHANGE_SPEED = 3;
    public SyncableDouble targetPitch;
    public SyncableDouble targetYaw;
    public SyncableDouble targetSpeed;
    public double currentPitch = 45.0;
    public double currentYaw = 0.0;
    private double currentSpeed = 1.4;
    public Vec3 motion;
    public boolean renderLine = true;
    private int ticksSinceLastFire = Integer.MAX_VALUE;

    protected void createSyncedFields() {
        this.targetPitch = new SyncableDouble();
        this.targetYaw = new SyncableDouble();
        this.targetSpeed = new SyncableDouble(1.4);
    }

    @SideOnly(value=Side.CLIENT)
    public void prepareForInventoryRender(Block block, int metadata) {
        super.prepareForInventoryRender(block, metadata);
        this.renderLine = false;
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.currentPitch -= (this.currentPitch - this.targetPitch.get()) / 20.0;
        this.currentYaw = GeometryUtils.normalizeAngle((double)this.currentYaw);
        double targetYaw = GeometryUtils.normalizeAngle((double)this.targetYaw.get());
        if (Math.abs(this.currentYaw - targetYaw) < 3.0) {
            this.currentYaw = targetYaw;
        } else {
            double dist = GeometryUtils.getAngleDistance((double)this.currentYaw, (double)targetYaw);
            this.currentYaw += 3.0 * Math.signum(dist);
        }
        this.currentSpeed -= (this.currentSpeed - this.targetSpeed.get()) / 20.0;
        this.invalidateMotion();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack;
            if (this.field_145850_b.func_82737_E() % 20L == 0L && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) && (stack = this.findStack()) != null) {
                this.fireStack(stack);
            }
        } else if (this.ticksSinceLastFire < 100) {
            ++this.ticksSinceLastFire;
        }
    }

    private ItemStack findStack() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            ItemStack stack;
            IInventory inventory = InventoryUtils.getInventory((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (ForgeDirection)direction);
            if (inventory == null || (stack = ItemDistribution.removeFromFirstNonEmptySlot((IInventory)inventory)) == null) continue;
            return stack;
        }
        return null;
    }

    private void fireStack(ItemStack stack) {
        ICannon rpc = (ICannon)this.createServerRpcProxy(ICannon.class, new Class[0]);
        rpc.fireCannon();
        EntityItemProjectile item = new EntityItemProjectile(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, stack);
        item.field_145804_b = 20;
        Vec3 motion = this.getMotion();
        item.field_70159_w = motion.field_72450_a;
        item.field_70181_x = motion.field_72448_b;
        item.field_70179_y = motion.field_72449_c;
        this.field_145850_b.func_72838_d((Entity)item);
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "openblocks:cannon.activate", 0.2f, 1.0f);
    }

    @Override
    public void fireCannon() {
        this.ticksSinceLastFire = 0;
        double pitchRad = Math.toRadians(this.currentYaw - 90.0);
        double x = -0.5 * Math.cos(pitchRad);
        double z = -0.5 * Math.sin(pitchRad);
        for (int i = 0; i < 20; ++i) {
            this.field_145850_b.func_72869_a((i < 4 ? "large" : "") + "smoke", x + (double)this.field_145851_c + 0.3 + this.field_145850_b.field_73012_v.nextDouble() * 0.4, (double)this.field_145848_d + 0.7, z + (double)this.field_145849_e + 0.3 + this.field_145850_b.field_73012_v.nextDouble() * 0.4, 0.0, 0.0, 0.0);
        }
    }

    public int getTicksSinceLastFire() {
        return this.ticksSinceLastFire;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB box = super.getRenderBoundingBox();
        return box.func_72314_b(32.0, 32.0, 32.0);
    }

    private Vec3 calcMotionFromAngles() {
        double p = Math.toRadians(this.currentPitch);
        double y = Math.toRadians(180.0 - this.currentYaw);
        double sinPitch = Math.sin(p);
        double cosPitch = Math.cos(p);
        double sinYaw = Math.sin(y);
        double cosYaw = Math.cos(y);
        return Vec3.func_72443_a((double)(-cosPitch * sinYaw * this.currentSpeed), (double)(sinPitch * this.currentSpeed), (double)(-cosPitch * cosYaw * this.currentSpeed));
    }

    private void invalidateMotion() {
        this.motion = null;
    }

    public Vec3 getMotion() {
        if (this.motion == null) {
            this.motion = this.calcMotionFromAngles();
        }
        return this.motion;
    }

    public void setTarget(int x, int y, int z) {
        double dX = (double)this.field_145851_c + 0.5 - ((double)x + 0.5);
        double dY = -(this.field_145848_d - y);
        double dZ = (double)this.field_145849_e + 0.5 - ((double)z + 0.5);
        double atan2 = Math.atan2(dZ, dX);
        double yawDegrees = Math.toDegrees(atan2) + 90.0;
        System.out.println(String.format("%f %f %f %f", dX, dY, dZ, yawDegrees));
        this.targetYaw.set(yawDegrees);
        this.currentYaw = this.targetYaw.get();
        double[] calc = TileEntityCannonLogic.getVariableVelocityTheta(dX, dY, dZ);
        double theta = Math.max(calc[0], calc[1]);
        this.targetPitch.set(Math.toDegrees(theta));
        this.currentPitch = this.targetPitch.get();
        double d = Math.sqrt(dX * dX + dZ * dZ);
        double v = Math.sqrt(d * 0.04000000000000001 / Math.sin(2.0 * theta));
        this.targetSpeed.set(v);
        this.sync();
    }

    public void disableLineRender() {
        this.renderLine = false;
    }

    @Override
    public void onPointingStart(ItemStack itemStack, EntityPlayer player) {
        player.func_146105_b((IChatComponent)new ChatComponentTranslation("openblocks.misc.selected_cannon", new Object[0]));
    }

    @Override
    public void onPointingEnd(ItemStack itemStack, EntityPlayer player, int x, int y, int z) {
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("openblocks.misc.pointed_cannon", new Object[]{x, y, z}));
        this.setTarget(x, y, z);
    }

    public void setSpeed(double speed) {
        this.targetSpeed.set(speed);
        this.sync();
    }

    public void setPitch(double pitch2) {
        this.targetPitch.set(pitch2);
        this.sync();
    }

    public void setYaw(double yaw2) {
        this.targetYaw.set(yaw2);
        this.sync();
    }

    public ForgeDirection getSurfaceDirection() {
        return ForgeDirection.DOWN;
    }

    static class TileEntityCannonLogic {
        public static final int HOURS_WASTED_ON_CANNON_LOGIC = 10;
        public static final double CANNON_VELOCITY = 0.4;
        public static final double WORLD_GRAVITY = -0.04000000000000001;

        TileEntityCannonLogic() {
        }

        public static double[] getThetaByAngle(double deltaX, double deltaY, double deltaZ, double v) {
            double r = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            double e = Math.atan2(deltaY, r);
            double g = -0.04000000000000001;
            double c1 = Math.sqrt(Math.pow(v += 0.5, 4.0) - g * (g * r * r * Math.pow(Math.cos(e), 2.0) + 2.0 * (v * v) * r * Math.sin(e)));
            double c2 = g * r * Math.cos(e);
            return new double[]{Math.atan(v * v + c1 / c2), Math.atan(v * v - c1 * c2)};
        }

        public static double[] getVariableVelocityTheta(double deltaX, double deltaY, double deltaZ) {
            double velocity = 0.4;
            double[] theta = TileEntityCannonLogic.getThetaToPoint(deltaX, deltaY, deltaZ, velocity);
            int iterations = 100;
            while (Double.isNaN(theta[0]) && Double.isNaN(theta[1]) && --iterations > 0) {
                theta = TileEntityCannonLogic.getThetaToPoint(deltaX, deltaY, deltaZ, velocity += 0.025);
            }
            double[] result = new double[]{theta[0], theta[1], velocity};
            return result;
        }

        public static double[] getThetaToPoint(double deltaX, double deltaY, double deltaZ, double velocity) {
            double x = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            double y = deltaY + 0.4;
            double v = velocity;
            double g = -0.04000000000000001;
            double[] theta = new double[2];
            double mComponent = v * v * v * v - g * (g * (x * x) + 2.0 * (y * (v * v)));
            if (mComponent < 0.0) {
                return new double[]{Double.NaN, Double.NaN};
            }
            mComponent *= 100.0;
            mComponent = Math.sqrt(mComponent);
            mComponent /= 10.0;
            theta[0] = Math.atan(v * v + (mComponent /= g * x));
            theta[1] = Math.atan(v * v - mComponent);
            return theta;
        }
    }
}

