/*
 * Decompiled with CFR 0.152.
 */
package mcjty.gui.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.gui.RenderHelper;
import mcjty.gui.Window;
import mcjty.gui.events.ColorChoiceEvent;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class ColorChoiceLabel
extends Label<ColorChoiceLabel> {
    private List<Integer> colorList = new ArrayList<Integer>();
    private Map<Integer, List<String>> tooltipMap = new HashMap<Integer, List<String>>();
    private Integer currentColor = null;
    private List<ColorChoiceEvent> choiceEvents = null;

    public ColorChoiceLabel(Minecraft mc, Gui gui) {
        super(mc, gui);
        this.setText("");
    }

    public ColorChoiceLabel addColors(Integer ... colors) {
        for (Integer color : colors) {
            this.colorList.add(color);
            if (this.currentColor != null) continue;
            this.currentColor = color;
            this.fireChoiceEvents(this.currentColor);
        }
        return this;
    }

    public ColorChoiceLabel setChoiceTooltip(Integer color, String ... tooltips) {
        this.tooltipMap.put(color, Arrays.asList(tooltips));
        return this;
    }

    public ColorChoiceLabel setCurrentColor(Integer color) {
        this.currentColor = color;
        return this;
    }

    public Integer getCurrentColor() {
        return this.currentColor;
    }

    @Override
    public List<String> getTooltips() {
        List<String> tooltips = this.tooltipMap.get(this.currentColor);
        if (tooltips == null) {
            return super.getTooltips();
        }
        return tooltips;
    }

    @Override
    public void draw(Window window, int x, int y) {
        if (!this.visible) {
            return;
        }
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        if (this.isEnabled()) {
            RenderHelper.drawBeveledBox(xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1, -1118482, -13421773, 0xFF000000 | this.getCurrentColor());
        } else {
            RenderHelper.drawBeveledBox(xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1, -7829368, -11184811, -10066330);
        }
        super.draw(window, x, y);
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        if (this.isEnabledAndVisible()) {
            int index = this.colorList.indexOf(this.currentColor);
            if (++index >= this.colorList.size()) {
                index = 0;
            }
            this.currentColor = this.colorList.get(index);
            this.fireChoiceEvents(this.currentColor);
        }
        return null;
    }

    public ColorChoiceLabel addChoiceEvent(ColorChoiceEvent event) {
        if (this.choiceEvents == null) {
            this.choiceEvents = new ArrayList<ColorChoiceEvent>();
        }
        this.choiceEvents.add(event);
        return this;
    }

    public void removeChoiceEvent(ColorChoiceEvent event) {
        if (this.choiceEvents != null) {
            this.choiceEvents.remove(event);
        }
    }

    private void fireChoiceEvents(Integer color) {
        if (this.choiceEvents != null) {
            for (ColorChoiceEvent event : this.choiceEvents) {
                event.choiceChanged(this, color);
            }
        }
    }
}

