/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache.helpers;

import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.DimensionalCoord;
import appeng.me.cache.TickManagerCache;
import appeng.parts.AEBasePart;
import net.minecraft.crash.CrashReportCategory;

public class TickTracker
implements Comparable<TickTracker> {
    public final TickingRequest request;
    public final IGridTickable gt;
    public final IGridNode node;
    public final TickManagerCache host;
    public final long LastFiveTicksTime = 0L;
    public long lastTick;
    public int current_rate;

    public TickTracker(TickingRequest req, IGridNode node, IGridTickable gt, long currentTick, TickManagerCache tickManagerCache) {
        this.request = req;
        this.gt = gt;
        this.node = node;
        this.current_rate = (req.minTickRate + req.maxTickRate) / 2;
        this.lastTick = currentTick;
        this.host = tickManagerCache;
    }

    public long getAvgNanos() {
        return this.LastFiveTicksTime / 5L;
    }

    public void setRate(int rate) {
        this.current_rate = rate;
        if (this.current_rate < this.request.minTickRate) {
            this.current_rate = this.request.minTickRate;
        }
        if (this.current_rate > this.request.maxTickRate) {
            this.current_rate = this.request.maxTickRate;
        }
    }

    @Override
    public int compareTo(TickTracker t) {
        int nextTick = (int)(this.lastTick - this.host.getCurrentTick() + (long)this.current_rate);
        int ts_nextTick = (int)(t.lastTick - this.host.getCurrentTick() + (long)t.current_rate);
        return nextTick - ts_nextTick;
    }

    public void addEntityCrashInfo(CrashReportCategory crashreportcategory) {
        if (this.gt instanceof AEBasePart) {
            AEBasePart part = (AEBasePart)((Object)this.gt);
            part.addEntityCrashInfo(crashreportcategory);
        }
        crashreportcategory.func_71507_a("CurrentTickRate", (Object)this.current_rate);
        crashreportcategory.func_71507_a("MinTickRate", (Object)this.request.minTickRate);
        crashreportcategory.func_71507_a("MaxTickRate", (Object)this.request.maxTickRate);
        crashreportcategory.func_71507_a("MachineType", (Object)this.gt.getClass().getName());
        crashreportcategory.func_71507_a("GridBlockType", (Object)this.node.getGridBlock().getClass().getName());
        crashreportcategory.func_71507_a("ConnectedSides", this.node.getConnectedSides());
        DimensionalCoord dc = this.node.getGridBlock().getLocation();
        if (dc != null) {
            crashreportcategory.func_71507_a("Location", (Object)dc);
        }
    }
}

