/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.endertech.network.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

@ChannelHandler.Sharable
public class PacketHandler
extends MessageToMessageCodec<FMLProxyPacket, PacketBase> {
    public static final PacketHandler instance = new PacketHandler();
    private final LinkedList<Class<? extends PacketBase>> packets = new LinkedList();
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private boolean isPostInitialised = false;

    public static void sendToAll(PacketBase message) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public static void sendTo(PacketBase message, EntityPlayerMP player) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public static void sendTo(PacketBase message, EntityPlayer player) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public static void sendToAllAround(PacketBase message, NetworkRegistry.TargetPoint point) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public static void sendToAllAround(PacketBase message, TileEntity theTile) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(theTile.func_145831_w().field_73011_w.field_76574_g, (double)theTile.field_145851_c, (double)theTile.field_145848_d, (double)theTile.field_145849_e, 192.0));
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public static void sendToAllAround(PacketBase message, World world, int x, int y, int z) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 192.0));
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public static void sendToDimension(PacketBase message, int dimensionId) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public static void sendToServer(PacketBase message) {
        PacketHandler.instance.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        PacketHandler.instance.channels.get(Side.CLIENT).writeAndFlush((Object)message);
    }

    public static Packet toMCPacket(PacketBase packet) {
        return PacketHandler.instance.channels.get(FMLCommonHandler.instance().getEffectiveSide()).generatePacketFrom((Object)packet);
    }

    public boolean registerPacket(Class<? extends PacketBase> packet) {
        if (this.packets.size() > 256) {
            return false;
        }
        if (this.packets.contains(packet)) {
            return false;
        }
        if (this.isPostInitialised) {
            return false;
        }
        this.packets.add(packet);
        return true;
    }

    protected void encode(ChannelHandlerContext ctx, PacketBase msg, List<Object> out) throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        Class<?> packetClass = msg.getClass();
        if (!this.packets.contains(msg.getClass())) {
            throw new NullPointerException("No Packet Registered for: " + msg.getClass().getCanonicalName());
        }
        byte discriminator = (byte)this.packets.indexOf(packetClass);
        buffer.writeByte((int)discriminator);
        msg.encodeInto(ctx, buffer);
        FMLProxyPacket proxyPacket = new FMLProxyPacket(buffer.copy(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        out.add(proxyPacket);
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        ByteBuf payload = msg.payload();
        byte discriminator = payload.readByte();
        Class<? extends PacketBase> packetClass = this.packets.get(discriminator);
        if (packetClass == null) {
            throw new NullPointerException("No packet registered for discriminator: " + discriminator);
        }
        PacketBase pkt = packetClass.newInstance();
        pkt.decodeInto(ctx, payload.slice());
        switch (FMLCommonHandler.instance().getEffectiveSide()) {
            case CLIENT: {
                EntityPlayer player = this.getClientPlayer();
                pkt.handleClientSide(player);
                break;
            }
            case SERVER: {
                INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                EntityPlayerMP player = ((NetHandlerPlayServer)netHandler).field_147369_b;
                pkt.handleServerSide((EntityPlayer)player);
                break;
            }
        }
    }

    public void init() {
        this.channels = NetworkRegistry.INSTANCE.newChannel("EnderTech", new ChannelHandler[]{this});
    }

    public void postInit() {
        if (this.isPostInitialised) {
            return;
        }
        this.isPostInitialised = true;
        Collections.sort(this.packets, new Comparator<Class<? extends PacketBase>>(){

            @Override
            public int compare(Class<? extends PacketBase> packetClass1, Class<? extends PacketBase> packetClass2) {
                int com = String.CASE_INSENSITIVE_ORDER.compare(packetClass1.getCanonicalName(), packetClass2.getCanonicalName());
                if (com == 0) {
                    com = packetClass1.getCanonicalName().compareTo(packetClass2.getCanonicalName());
                }
                return com;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }
}

