/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.addons.vanillamc;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class AddonVanillaEntities
implements IWailaEntityProvider {
    private static String showHorseJump = "wawla.horse.showJump";
    private static String showHorseSpeed = "wawla.horse.showSpeed";
    private static String showZombieType = "wawla.villagerZombie";
    private static String showPlayerLevel = "wawla.playerLevel";

    public Entity getWailaOverride(IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return data.getEntity();
    }

    public List<String> getWailaHead(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaBody(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        EntityZombie zombie;
        if (entity instanceof EntityHorse) {
            EntityHorse horse = (EntityHorse)entity;
            if (cfg.getConfig("wawla.horse.showJump")) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.jumpStrength") + ": " + Utilities.round(horse.func_110215_cj(), 4));
            }
            if (cfg.getConfig("wawla.horse.showSpeed")) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.speed") + ": " + Utilities.round(horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e(), 4));
            }
        } else if (entity instanceof EntityZombie && cfg.getConfig(showZombieType) && (zombie = (EntityZombie)entity).func_82231_m()) {
            tip.add("Zombie Villager");
        }
        return tip;
    }

    public List<String> getWailaTail(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity entity, NBTTagCompound tag, World world) {
        if (entity != null) {
            entity.func_70109_d(tag);
        }
        return tag;
    }

    public static void registerAddon(IWailaRegistrar register) {
        AddonVanillaEntities dataProvider = new AddonVanillaEntities();
        register.registerBodyProvider((IWailaEntityProvider)dataProvider, EntityHorse.class);
        register.registerNBTProvider((IWailaEntityProvider)dataProvider, EntityHorse.class);
        register.registerBodyProvider((IWailaEntityProvider)dataProvider, EntityVillager.class);
        register.registerNBTProvider((IWailaEntityProvider)dataProvider, EntityVillager.class);
        register.addConfig("Wawla-Entity", showHorseJump);
        register.addConfig("Wawla-Entity", showHorseSpeed);
        register.addConfig("Wawla-Entity", showZombieType);
    }
}

