/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib.inventory;

import java.util.HashMap;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import tuhljin.automagy.gui.ContainerEmpty;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;

public class InventoryCraftingCachedResult
extends InventoryCrafting {
    protected final String nbtKey;
    private boolean hasResult = false;
    private ItemStack result = null;
    private World worldObj;
    private HashMap<HashableItemWithoutSize, Integer> map = null;

    public InventoryCraftingCachedResult(Container container, String nbtKey) {
        super(container, 3, 3);
        this.nbtKey = nbtKey;
    }

    public InventoryCraftingCachedResult(String nbtKey) {
        this(new ContainerEmpty(), nbtKey);
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        this.hasResult = false;
        this.result = null;
        this.map = null;
        return super.func_70298_a(p_70298_1_, p_70298_2_);
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.hasResult = false;
        this.result = null;
        this.map = null;
        super.func_70299_a(p_70299_1_, p_70299_2_);
    }

    public int func_70297_j_() {
        return 1;
    }

    public void setWorld(World world) {
        this.worldObj = world;
    }

    public ItemStack getCraftingResult() {
        if (!this.hasResult) {
            this.result = CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this, this.worldObj);
            this.hasResult = true;
        }
        return this.result;
    }

    public boolean containsItem(ItemStack stack) {
        if (this.map == null) {
            this.getItemMap();
        }
        return this.map.containsKey(new HashableItemWithoutSize(stack));
    }

    public HashMap<HashableItemWithoutSize, Integer> getItemMap() {
        if (this.map == null) {
            this.map = new HashMap();
            int size = this.func_70302_i_();
            for (int slot = 0; slot < size; ++slot) {
                ItemStack stack = this.func_70301_a(slot);
                if (stack == null) continue;
                HashableItemWithoutSize item = new HashableItemWithoutSize(stack);
                if (this.map.containsKey(item)) {
                    this.map.put(item, this.map.get(item) + 1);
                    continue;
                }
                this.map.put(item, 1);
            }
        }
        return this.map;
    }

    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = nbttagcompound.func_150295_c(this.nbtKey, 10);
        if (nbttaglist.func_74745_c() > 0) {
            int numSlots = this.func_70302_i_();
            for (int i = 0; i < numSlots; ++i) {
                NBTTagCompound tagList = nbttaglist.func_150305_b(i);
                byte slot = tagList.func_74771_c("Slot");
                if (slot < 0 || slot >= numSlots || this.func_70301_a(slot) != null) continue;
                this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)tagList));
            }
        }
    }

    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        int numSlots = this.func_70302_i_();
        for (int i = 0; i < numSlots; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            NBTTagCompound tagList = new NBTTagCompound();
            tagList.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tagList);
            nbttaglist.func_74742_a((NBTBase)tagList);
        }
        nbttagcompound.func_74782_a(this.nbtKey, (NBTBase)nbttaglist);
    }

    public boolean recipeFitsSmallGrid() {
        boolean top = false;
        boolean left = false;
        if (this.func_70301_a(0) != null) {
            top = true;
            left = true;
        } else {
            if (this.func_70301_a(1) != null || this.func_70301_a(2) != null) {
                top = true;
            }
            if (this.func_70301_a(3) != null || this.func_70301_a(6) != null) {
                left = true;
            }
        }
        if (top && (this.func_70301_a(6) != null || this.func_70301_a(7) != null || this.func_70301_a(8) != null)) {
            return false;
        }
        return !left || this.func_70301_a(2) == null && this.func_70301_a(5) == null && this.func_70301_a(8) == null;
    }
}

