/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.factorization.handlers;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.ReflectionHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.factorization.FactorizationHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.factorization.Crystallizer")
public class Crystallizer {
    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output, IItemStack solution, double output_count) {
        Object recipe = FactorizationHelper.getCrystallizerRecipe(InputHelper.toStack(input), InputHelper.toStack(output), InputHelper.toStack(solution), (float)output_count);
        MineTweakerAPI.apply((IUndoableAction)new Add(InputHelper.toStack(input), recipe));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(output)));
    }

    private static class Remove
    extends BaseListRemoval {
        public Remove(ItemStack stack) {
            super("Crystallizer", FactorizationHelper.crystallizer, stack);
        }

        private ItemStack getOutput(Object o) {
            return (ItemStack)ReflectionHelper.getObject(o, "output");
        }

        public void apply() {
            for (Object r : this.list) {
                ItemStack output;
                if (r == null || (output = this.getOutput(r)) == null || !StackHelper.areEqual(output, this.stack)) continue;
                this.recipe = r;
                break;
            }
            this.list.remove(this.recipe);
        }

        @Override
        public String getRecipeInfo() {
            return this.stack.func_82833_r();
        }
    }

    private static class Add
    extends BaseListAddition {
        private final ItemStack output;

        public Add(ItemStack output, Object recipe) {
            super("Crystallizer", FactorizationHelper.crystallizer, recipe);
            this.output = output;
        }

        @Override
        public String getRecipeInfo() {
            return this.output.func_82833_r();
        }
    }
}

