/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting.ic2;

import cpw.mods.fml.common.eventhandler.Event;
import gcewing.lighting.ic2.BlockFloodlightIC2;
import gcewing.lighting.ic2.GregsLightingIC2;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TEFloodlightIC2
extends TileEntity
implements IEnergySink {
    final double maxEnergy = 64.0;
    final int maxInput = 32;
    final double energyUsedPerTick = 1.0;
    double energy = 0.0;
    boolean addedToEnergyNet = false;

    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.energy = nBTTagCompound.func_74769_h("energy");
    }

    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74780_a("energy", this.energy);
    }

    public int getMaxSafeInput() {
        return 32;
    }

    @Override
    public int getSinkTier() {
        return 1;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return true;
    }

    @Override
    public double getDemandedEnergy() {
        double d = this.energy < 32.0 ? 64.0 - this.energy : 0.0;
        return d;
    }

    @Override
    public double injectEnergy(ForgeDirection forgeDirection, double d, double d2) {
        if (d > (double)this.getMaxSafeInput()) {
            GregsLightingIC2.explodeMachineAt(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return 0.0;
        }
        boolean bl = this.energy > 0.0;
        this.energy += d;
        if (bl != this.energy > 0.0) {
            this.func_70296_d();
            this.updateBlock();
        }
        return 0.0;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.addedToEnergyNet) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
                this.addedToEnergyNet = true;
            }
            if (this.isActive()) {
                this.energy -= 1.0;
                if (this.energy < 0.0) {
                    this.energy = 0.0;
                }
                this.func_70296_d();
                if (!this.isActive()) {
                    this.updateBlock();
                }
            }
        }
    }

    public void func_145843_s() {
        this.removeFromEnergyNet();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.removeFromEnergyNet();
        super.onChunkUnload();
    }

    void removeFromEnergyNet() {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    BlockFloodlightIC2 getBlock() {
        return (BlockFloodlightIC2)this.func_145838_q();
    }

    void updateBlock() {
        BlockFloodlightIC2 blockFloodlightIC2 = this.getBlock();
        blockFloodlightIC2.update(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        blockFloodlightIC2.updateBeam(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isActive() {
        boolean bl = this.switchedOn();
        boolean bl2 = this.receivingRedstoneSignal();
        return this.energy > 0.0 && (bl || bl2);
    }

    public boolean switchedOn() {
        BlockFloodlightIC2 blockFloodlightIC2 = this.getBlock();
        boolean bl = blockFloodlightIC2.switchedOn;
        return bl;
    }

    boolean receivingRedstoneSignal() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

