/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.spawnguard;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.spawnguard.TileSpawnGuard;
import crazypants.util.BlockCoord;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;

public class SpawnGuardController {
    public static SpawnGuardController instance = new SpawnGuardController();
    private Map<Integer, Map<BlockCoord, TileSpawnGuard>> perWorldGuards = new HashMap<Integer, Map<BlockCoord, TileSpawnGuard>>();

    private SpawnGuardController() {
    }

    public void registerGuard(TileSpawnGuard guard) {
        if (guard == null) {
            return;
        }
        Map<BlockCoord, TileSpawnGuard> chargers = this.getGuardsForWorld(guard.func_145831_w());
        chargers.put(guard.getLocation(), guard);
    }

    public void deregisterGuard(TileSpawnGuard guard) {
        if (guard == null) {
            return;
        }
        Map<BlockCoord, TileSpawnGuard> chargers = this.getGuardsForWorld(guard.func_145831_w());
        chargers.remove(guard.getLocation());
    }

    @SubscribeEvent
    public void onEntitySpawn(LivingSpawnEvent evt) {
        if (Config.spawnGuardStopAllSlimesDebug && evt.entity instanceof EntitySlime) {
            evt.setResult(Event.Result.DENY);
            return;
        }
        if (Config.spawnGuardStopAllSquidSpawning && evt.entity.getClass() == EntitySquid.class) {
            evt.setResult(Event.Result.DENY);
            return;
        }
        Map<BlockCoord, TileSpawnGuard> guards = this.getGuardsForWorld(evt.world);
        for (TileSpawnGuard guard : guards.values()) {
            if (!guard.isSpawnPrevented(evt.entityLiving)) continue;
            evt.setResult(Event.Result.DENY);
            return;
        }
    }

    private Map<BlockCoord, TileSpawnGuard> getGuardsForWorld(World world) {
        Map<BlockCoord, TileSpawnGuard> res = this.perWorldGuards.get(world.field_73011_w.field_76574_g);
        if (res == null) {
            res = new HashMap<BlockCoord, TileSpawnGuard>();
            this.perWorldGuards.put(world.field_73011_w.field_76574_g, res);
        }
        return res;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }
}

