/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.net;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import powercrystals.minefactoryreloaded.core.UtilInventory;
import powercrystals.minefactoryreloaded.entity.EntityRocket;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactory;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoAnvil;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoDisenchanter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoEnchanter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoJukebox;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoSpawner;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityBlockSmasher;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityChronotyper;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityChunkLoader;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityEjector;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityEnchantmentRouter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityHarvester;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityItemRouter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityMobRouter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityPlanter;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetLogic;

public class ServerPacketHandler
implements IMessageHandler<MFRMessage, IMessage> {
    public IMessage onMessage(MFRMessage mFRMessage, MessageContext messageContext) {
        if (mFRMessage.packet != null) {
            messageContext.getServerHandler().func_147359_a(mFRMessage.packet);
        }
        return null;
    }

    private static Packet readData(ByteBuf byteBuf) {
        WorldServer worldServer = DimensionManager.getWorld((int)byteBuf.readInt());
        switch (byteBuf.readUnsignedShort()) {
            case 3: {
                int n = byteBuf.readInt();
                int n2 = byteBuf.readInt();
                int n3 = byteBuf.readInt();
                TileEntity tileEntity = worldServer.func_147438_o(n, n2, n3);
                if (!(tileEntity instanceof TileEntityFactory) || !((TileEntityFactory)tileEntity).hasHAM()) break;
                return ((TileEntityFactory)tileEntity).getHAM().getUpgradePacket();
            }
            case 0: {
                int n = byteBuf.readInt();
                int n4 = byteBuf.readInt();
                int n5 = byteBuf.readInt();
                TileEntity tileEntity = worldServer.func_147438_o(n, n4, n5);
                byte by = byteBuf.readByte();
                if (tileEntity instanceof TileEntityAutoEnchanter) {
                    ((TileEntityAutoEnchanter)tileEntity).setTargetLevel(((TileEntityAutoEnchanter)tileEntity).getTargetLevel() + by);
                    break;
                }
                if (tileEntity instanceof TileEntityBlockSmasher) {
                    ((TileEntityBlockSmasher)tileEntity).setFortune(((TileEntityBlockSmasher)tileEntity).getFortune() + by);
                    break;
                }
                if (!(tileEntity instanceof TileEntityAutoDisenchanter)) break;
                ((TileEntityAutoDisenchanter)tileEntity).setRepeatDisenchant(by == 1);
                break;
            }
            case 1: {
                int n = byteBuf.readInt();
                int n6 = byteBuf.readInt();
                int n7 = byteBuf.readInt();
                TileEntity tileEntity = worldServer.func_147438_o(n, n6, n7);
                if (!(tileEntity instanceof TileEntityHarvester)) break;
                ((TileEntityHarvester)tileEntity).getSettings().put(ByteBufUtils.readUTF8String((ByteBuf)byteBuf), byteBuf.readBoolean());
                break;
            }
            case 2: {
                int n = byteBuf.readInt();
                int n8 = byteBuf.readInt();
                int n9 = byteBuf.readInt();
                TileEntity tileEntity = worldServer.func_147438_o(n, n8, n9);
                if (!(tileEntity instanceof TileEntityChronotyper)) break;
                ((TileEntityChronotyper)tileEntity).setMoveOld(!((TileEntityChronotyper)tileEntity).getMoveOld());
                break;
            }
            case 4: {
                int n = byteBuf.readInt();
                int n10 = byteBuf.readInt();
                int n11 = byteBuf.readInt();
                TileEntity tileEntity = worldServer.func_147438_o(n, n10, n11);
                if (!(tileEntity instanceof TileEntityAutoJukebox)) break;
                TileEntityAutoJukebox tileEntityAutoJukebox = (TileEntityAutoJukebox)tileEntity;
                byte by = byteBuf.readByte();
                if (by == 1) {
                    tileEntityAutoJukebox.playRecord();
                    break;
                }
                if (by == 2) {
                    tileEntityAutoJukebox.stopRecord();
                    break;
                }
                if (by != 3) break;
                tileEntityAutoJukebox.copyRecord();
                break;
            }
            case 5: {
                int n = byteBuf.readInt();
                int n12 = byteBuf.readInt();
                int n13 = byteBuf.readInt();
                TileEntity tileEntity = worldServer.func_147438_o(n, n12, n13);
                if (!(tileEntity instanceof TileEntityAutoSpawner)) break;
                ((TileEntityAutoSpawner)tileEntity).setSpawnExact(!((TileEntityAutoSpawner)tileEntity).getSpawnExact());
                break;
            }
            case 6: {
                int n = byteBuf.readInt();
                int n14 = byteBuf.readInt();
                int n15 = byteBuf.readInt();
                TileEntity tileEntity = worldServer.func_147438_o(n, n14, n15);
                if (!(tileEntity instanceof TileEntityRedNetLogic)) break;
                ((TileEntityRedNetLogic)tileEntity).sendCircuitDefinition(byteBuf.readInt());
                break;
            }
            case 7: {
                int n = byteBuf.readInt();
                int n16 = byteBuf.readInt();
                int n17 = byteBuf.readInt();
                TileEntity tileEntity = worldServer.func_147438_o(n, n16, n17);
                int n18 = byteBuf.readInt();
                if (!(tileEntity instanceof TileEntityRedNetLogic)) break;
                ((TileEntityRedNetLogic)tileEntity).initCircuit(n18, ByteBufUtils.readUTF8String((ByteBuf)byteBuf));
                ((TileEntityRedNetLogic)tileEntity).sendCircuitDefinition(n18);
                break;
            }
            case 8: {
                int n = byteBuf.readInt();
                int n19 = byteBuf.readInt();
                int n20 = byteBuf.readInt();
                TileEntity tileEntity = worldServer.func_147438_o(n, n19, n20);
                byte by = byteBuf.readByte();
                int n21 = byteBuf.readInt();
                int n22 = byteBuf.readInt();
                int n23 = byteBuf.readInt();
                int n24 = byteBuf.readInt();
                if (!(tileEntity instanceof TileEntityRedNetLogic)) break;
                if (by == 0) {
                    ((TileEntityRedNetLogic)tileEntity).setInputPinMapping(n21, n22, n23, n24);
                } else if (by == 1) {
                    ((TileEntityRedNetLogic)tileEntity).setOutputPinMapping(n21, n22, n23, n24);
                }
                ((TileEntityRedNetLogic)tileEntity).sendCircuitDefinition(n21);
                break;
            }
            case 9: {
                int n = byteBuf.readInt();
                int n25 = byteBuf.readInt();
                int n26 = byteBuf.readInt();
                TileEntity tileEntity = worldServer.func_147438_o(n, n25, n26);
                EntityPlayer entityPlayer = (EntityPlayer)worldServer.func_73045_a(byteBuf.readInt());
                if (!(tileEntity instanceof TileEntityRedNetLogic)) break;
                ((TileEntityRedNetLogic)tileEntity).reinitialize(entityPlayer);
                break;
            }
            case 10: {
                int n = byteBuf.readInt();
                int n27 = byteBuf.readInt();
                int n28 = byteBuf.readInt();
                TileEntity tileEntity = worldServer.func_147438_o(n, n27, n28);
                int n29 = byteBuf.readInt();
                if (tileEntity instanceof TileEntityEnchantmentRouter) {
                    switch (n29) {
                        case 2: {
                            ((TileEntityItemRouter)tileEntity).setRejectUnmapped(!((TileEntityItemRouter)tileEntity).getRejectUnmapped());
                            break;
                        }
                        case 1: {
                            ((TileEntityEnchantmentRouter)tileEntity).setMatchLevels(!((TileEntityEnchantmentRouter)tileEntity).getMatchLevels());
                        }
                    }
                    break;
                }
                if (tileEntity instanceof TileEntityItemRouter) {
                    ((TileEntityItemRouter)tileEntity).setRejectUnmapped(!((TileEntityItemRouter)tileEntity).getRejectUnmapped());
                    break;
                }
                if (tileEntity instanceof TileEntityEjector) {
                    switch (n29) {
                        case 1: {
                            ((TileEntityEjector)tileEntity).setIsWhitelist(!((TileEntityEjector)tileEntity).getIsWhitelist());
                            break;
                        }
                        case 2: {
                            ((TileEntityEjector)tileEntity).setIsNBTMatch(!((TileEntityEjector)tileEntity).getIsNBTMatch());
                            break;
                        }
                        case 3: {
                            ((TileEntityEjector)tileEntity).setIsIDMatch(!((TileEntityEjector)tileEntity).getIsIDMatch());
                        }
                    }
                    break;
                }
                if (tileEntity instanceof TileEntityAutoAnvil) {
                    ((TileEntityAutoAnvil)tileEntity).setRepairOnly(!((TileEntityAutoAnvil)tileEntity).getRepairOnly());
                    break;
                }
                if (tileEntity instanceof TileEntityChunkLoader) {
                    ((TileEntityChunkLoader)tileEntity).setRadius((short)n29);
                    break;
                }
                if (tileEntity instanceof TileEntityPlanter) {
                    ((TileEntityPlanter)tileEntity).setConsumeAll(!((TileEntityPlanter)tileEntity).getConsumeAll());
                    break;
                }
                if (!(tileEntity instanceof TileEntityMobRouter)) break;
                switch (n29) {
                    case 1: {
                        ((TileEntityMobRouter)tileEntity).setWhiteList(!((TileEntityMobRouter)tileEntity).getWhiteList());
                        break;
                    }
                    case 2: {
                        ((TileEntityMobRouter)tileEntity).setMatchMode(((TileEntityMobRouter)tileEntity).getMatchMode() + 1);
                        break;
                    }
                    case 3: {
                        ((TileEntityMobRouter)tileEntity).setMatchMode(((TileEntityMobRouter)tileEntity).getMatchMode() - 1);
                    }
                }
                break;
            }
            case 20: {
                int n = byteBuf.readInt();
                int n30 = byteBuf.readInt();
                int n31 = byteBuf.readInt();
                TileEntity tileEntity = worldServer.func_147438_o(n, n30, n31);
                EntityPlayer entityPlayer = (EntityPlayer)worldServer.func_73045_a(byteBuf.readInt());
                ItemStack itemStack = entityPlayer.field_71071_by.func_70445_o();
                int n32 = byteBuf.readInt();
                byte by = byteBuf.readByte();
                if (!(tileEntity instanceof IInventory)) break;
                if (itemStack == null) {
                    ((IInventory)tileEntity).func_70299_a(n32, null);
                    break;
                }
                itemStack = itemStack.func_77946_l();
                itemStack.field_77994_a = by == 1 ? -1 : 1;
                ItemStack itemStack2 = ((IInventory)tileEntity).func_70301_a(n32);
                itemStack.field_77994_a = !UtilInventory.stacksEqual(itemStack2, itemStack) ? 1 : Math.max(itemStack.field_77994_a + itemStack2.field_77994_a, 1);
                ((IInventory)tileEntity).func_70299_a(n32, itemStack);
                break;
            }
            case 11: {
                Entity entity = worldServer.func_73045_a(byteBuf.readInt());
                int n = byteBuf.readInt();
                Entity entity2 = null;
                if (n != Integer.MIN_VALUE) {
                    entity2 = worldServer.func_73045_a(n);
                }
                if (!(entity instanceof EntityLivingBase)) break;
                EntityRocket entityRocket = new EntityRocket((World)worldServer, (EntityLivingBase)entity, entity2);
                worldServer.func_72838_d((Entity)entityRocket);
            }
        }
        return null;
    }

    public static class MFRMessage
    implements IMessage {
        public ByteBuf buf;
        public Packet packet;

        public MFRMessage() {
        }

        public MFRMessage(short s, TileEntity tileEntity, Object ... objectArray) {
            ByteBuf byteBuf = Unpooled.buffer();
            byteBuf.writeInt(tileEntity.func_145831_w().field_73011_w.field_76574_g);
            byteBuf.writeShort((int)s);
            byteBuf.writeInt(tileEntity.field_145851_c);
            byteBuf.writeInt(tileEntity.field_145848_d);
            byteBuf.writeInt(tileEntity.field_145849_e);
            MFRMessage.handleObjects(byteBuf, objectArray);
            this.buf = byteBuf;
        }

        public MFRMessage(short s, Entity entity, Object ... objectArray) {
            ByteBuf byteBuf = Unpooled.buffer();
            byteBuf.writeInt(entity.field_70170_p.field_73011_w.field_76574_g);
            byteBuf.writeShort((int)s);
            byteBuf.writeInt(entity.func_145782_y());
            MFRMessage.handleObjects(byteBuf, objectArray);
            this.buf = byteBuf;
        }

        public void fromBytes(ByteBuf byteBuf) {
            this.packet = ServerPacketHandler.readData(byteBuf);
        }

        public void toBytes(ByteBuf byteBuf) {
            byteBuf.writeBytes(this.buf);
        }

        private static void handleObjects(ByteBuf byteBuf, Object[] objectArray) {
            for (Object object : objectArray) {
                Class<?> clazz = object.getClass();
                if (clazz.equals(Integer.class)) {
                    byteBuf.writeInt(((Integer)object).intValue());
                    continue;
                }
                if (clazz.equals(Boolean.class)) {
                    byteBuf.writeBoolean(((Boolean)object).booleanValue());
                    continue;
                }
                if (clazz.equals(Byte.class)) {
                    byteBuf.writeByte((int)((Byte)object).byteValue());
                    continue;
                }
                if (clazz.equals(Short.class)) {
                    byteBuf.writeShort((int)((Short)object).shortValue());
                    continue;
                }
                if (clazz.equals(String.class)) {
                    ByteBufUtils.writeUTF8String((ByteBuf)byteBuf, (String)((String)object));
                    continue;
                }
                if (Entity.class.isAssignableFrom(clazz)) {
                    byteBuf.writeInt(((Entity)object).func_145782_y());
                    continue;
                }
                if (clazz.equals(Double.class)) {
                    byteBuf.writeDouble(((Double)object).doubleValue());
                    continue;
                }
                if (clazz.equals(Float.class)) {
                    byteBuf.writeFloat(((Float)object).floatValue());
                    continue;
                }
                if (!clazz.equals(Long.class)) continue;
                byteBuf.writeLong(((Long)object).longValue());
            }
        }
    }
}

