/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import gcewing.lighting.Trans3;
import gcewing.lighting.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class BaseBlockRenderer<BLOCK extends Block>
implements ISimpleBlockRenderingHandler {
    public int renderID;
    Tessellator tess;
    IBlockAccess world;
    BLOCK block;
    int blockX;
    int blockY;
    int blockZ;
    int metadata;
    double u0;
    double v0;
    double u1;
    double v1;
    double us;
    double vs;
    boolean textureOverridden;
    float cmr;
    float cmg;
    float cmb;
    int blockBrightness;
    public static double[][] cubeFaces = new double[][]{{-0.5, -0.5, 0.5, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 0.0}, {-0.5, 0.5, -0.5, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.5, 0.5, -0.5, 0.0, -1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0}, {-0.5, 0.5, 0.5, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {-0.5, 0.5, -0.5, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0}, {0.5, 0.5, 0.5, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0}};

    public int getRenderId() {
        return this.renderID;
    }

    public boolean shouldRender3DInInventory(int n) {
        return true;
    }

    public void renderInventoryBlock(Block block, int n, int n2, RenderBlocks renderBlocks) {
        this.world = null;
        this.block = block;
        this.blockX = 0;
        this.blockY = 0;
        this.blockZ = 0;
        this.setUpTextureOverride(renderBlocks);
        this.metadata = n;
        this.blockBrightness = 0xF000F0;
        this.setColorMultiplier(0xFFFFFF);
        this.tess = Tessellator.field_78398_a;
        this.tess.func_78386_a(1.0f, 1.0f, 1.0f);
        Trans3 trans3 = this.localToInventoryTransformation(n);
        this.tess.func_78382_b();
        this.renderBlock(trans3);
        this.tess.func_78381_a();
    }

    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int n, int n2, int n3, Block block, int n4, RenderBlocks renderBlocks) {
        return this.renderStandardWorldBlock(iBlockAccess, n, n2, n3, block, n4, renderBlocks);
    }

    public boolean renderStandardWorldBlock(IBlockAccess iBlockAccess, int n, int n2, int n3, Block block, int n4, RenderBlocks renderBlocks) {
        this.world = iBlockAccess;
        this.block = block;
        this.blockX = n;
        this.blockY = n2;
        this.blockZ = n3;
        this.setUpTextureOverride(renderBlocks);
        this.metadata = iBlockAccess.func_72805_g(n, n2, n3);
        this.blockBrightness = block.func_149677_c(iBlockAccess, n, n2, n3);
        this.setColorMultiplier(block.func_149720_d(iBlockAccess, n, n2, n3));
        this.tess = Tessellator.field_78398_a;
        this.tess.func_78386_a(1.0f, 1.0f, 1.0f);
        Trans3 trans3 = this.localToGlobalTransformation();
        return this.renderBlock(trans3);
    }

    Trans3 localToInventoryTransformation(int n) {
        return new Trans3(0.0, 0.0, 0.0);
    }

    Trans3 localToGlobalTransformation() {
        return new Trans3((double)this.blockX + 0.5, (double)this.blockY + 0.5, (double)this.blockZ + 0.5);
    }

    boolean renderBlock(Trans3 trans3) {
        this.renderCube(trans3);
        return true;
    }

    void setColorMultiplier(int n) {
        this.cmr = (float)(n >> 16 & 0xFF) / 255.0f;
        this.cmg = (float)(n >> 8 & 0xFF) / 255.0f;
        this.cmb = (float)(n & 0xFF) / 255.0f;
    }

    void setUpTextureOverride(RenderBlocks renderBlocks) {
        IIcon iIcon;
        this.textureOverridden = false;
        if (renderBlocks != null && (iIcon = renderBlocks.field_147840_d) != null) {
            this.useIcon(iIcon);
            this.textureOverridden = true;
        }
    }

    void selectTile(IIcon iIcon) {
        this.selectTile(iIcon, 16.0, 16.0);
    }

    void selectTile(IIcon iIcon, double d, double d2) {
        if (!this.textureOverridden) {
            this.useIcon(iIcon);
        }
        this.us = (this.u1 - this.u0) / d;
        this.vs = (this.v1 - this.v0) / d2;
    }

    void useIcon(IIcon iIcon) {
        this.u0 = iIcon.func_94209_e();
        this.v0 = iIcon.func_94206_g();
        this.u1 = iIcon.func_94212_f();
        this.v1 = iIcon.func_94210_h();
    }

    void renderCube(Trans3 trans3) {
        this.renderCubeWithFaceDepths(trans3, null);
    }

    void renderCubeWithFaceDepths(Trans3 trans3, double[] dArray) {
        for (int i = 0; i < 6; ++i) {
            this.selectTileForSide(i);
            this.setBrightnessForSide(trans3, i);
            this.cubeFace(trans3, cubeFaces[i]);
            if (dArray == null) continue;
            this.tess.func_78380_c(this.blockBrightness);
            this.cubeBackFace(trans3, cubeFaces[i], dArray[i]);
        }
    }

    void selectTileForSide(int n) {
        this.selectTile(this.block.func_149691_a(n, this.metadata));
    }

    void setBrightnessForSide(Trans3 trans3, int n) {
        if (this.world != null) {
            ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)n);
            Vector3 vector3 = trans3.p(forgeDirection.offsetX, forgeDirection.offsetY, forgeDirection.offsetZ);
            this.tess.func_78380_c(this.block.func_149677_c(this.world, vector3.floorX(), vector3.floorY(), vector3.floorZ()));
        } else {
            this.setBrightnessForBlock();
        }
    }

    void setBrightnessForBlock() {
        this.tess.func_78380_c(this.blockBrightness);
    }

    void setNormal(Trans3 trans3, double d, double d2, double d3) {
        this.setNormal(trans3, d, d2, d3, 1.0);
    }

    void setNormal(Trans3 trans3, double d, double d2, double d3, double d4) {
        Vector3 vector3 = trans3.v(d, d2, d3);
        float f = (float)(d4 * (0.6 * vector3.x * vector3.x + 0.8 * vector3.z * vector3.z + (vector3.y > 0.0 ? 1.0 : 0.5) * vector3.y * vector3.y));
        this.tess.func_78375_b((float)vector3.x, (float)vector3.y, (float)vector3.z);
        this.tess.func_78386_a(f * this.cmr, f * this.cmg, f * this.cmb);
    }

    void cubeFace(Trans3 trans3, double[] dArray) {
        this.setNormal(trans3, dArray[9], dArray[10], dArray[11]);
        this.face(trans3, dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[7], dArray[8], 0.0, 0.0, 16.0, 16.0);
    }

    void cubeBackFace(Trans3 trans3, double[] dArray, double d) {
        double d2 = -dArray[9];
        double d3 = -dArray[10];
        double d4 = -dArray[11];
        this.setNormal(trans3, d2, d3, d4, 0.5);
        this.backFace(trans3, dArray[0] + d * d2, dArray[1] + d * d3, dArray[2] + d * d4, dArray[3], dArray[4], dArray[5], dArray[6], dArray[7], dArray[8], 0.0, 0.0, 16.0, 16.0);
    }

    void face(Trans3 trans3, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        this.vertex(trans3, d, d2, d3, d10, d11);
        this.vertex(trans3, d + d4, d2 + d5, d3 + d6, d10, d11 + d13);
        this.vertex(trans3, d + d4 + d7, d2 + d5 + d8, d3 + d6 + d9, d10 + d12, d11 + d13);
        this.vertex(trans3, d + d7, d2 + d8, d3 + d9, d10 + d12, d11);
    }

    void backFace(Trans3 trans3, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        this.face(trans3, d + d4, d2 + d5, d3 + d6, -d4, -d5, -d6, d7, d8, d9, d10, d11 + d13, d12, -d13);
    }

    void vertex(Trans3 trans3, double d, double d2, double d3, double d4, double d5) {
        Vector3 vector3 = trans3.p(d, d2, d3);
        this.tess.func_78374_a(vector3.x, vector3.y, vector3.z, this.u0 + d4 * this.us, this.v0 + d5 * this.vs);
    }

    void renderBox(Trans3 trans3, AxisAlignedBB axisAlignedBB, IIcon[] iIconArray) {
        this.renderBox(trans3, axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c, axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e - axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f - axisAlignedBB.field_72339_c, iIconArray);
    }

    void renderBox(Trans3 trans3, double d, double d2, double d3, double d4, double d5, double d6, IIcon[] iIconArray) {
        double d7 = d + d4;
        double d8 = d2 + d5;
        double d9 = d3 + d6;
        this.tess.func_78380_c(this.blockBrightness);
        this.boxFace(trans3, d, d2, d9, 0.0, 0.0, -d6, d4, 0.0, 0.0, 0.0, -1.0, 0.0, d4, d6, iIconArray[0]);
        this.boxFace(trans3, d, d8, d3, 0.0, 0.0, d6, d4, 0.0, 0.0, 0.0, 1.0, 0.0, d4, d6, iIconArray[1]);
        this.boxFace(trans3, d7, d8, d3, 0.0, -d5, 0.0, -d4, 0.0, 0.0, 0.0, 0.0, -1.0, d4, d5, iIconArray[2]);
        this.boxFace(trans3, d, d8, d9, 0.0, -d5, 0.0, d4, 0.0, 0.0, 0.0, 0.0, 1.0, d4, d5, iIconArray[3]);
        this.boxFace(trans3, d, d8, d3, 0.0, -d5, 0.0, 0.0, 0.0, d6, -1.0, 0.0, 0.0, d6, d5, iIconArray[4]);
        this.boxFace(trans3, d7, d8, d9, 0.0, -d5, 0.0, 0.0, 0.0, -d6, 1.0, 0.0, 0.0, d6, d5, iIconArray[5]);
    }

    void boxFace(Trans3 trans3, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, IIcon iIcon) {
        if (iIcon != null) {
            this.selectTile(iIcon);
            this.setNormal(trans3, d10, d11, d12);
            this.face(trans3, d, d2, d3, d4, d5, d6, d7, d8, d9, 0.0, 0.0, d13 * 16.0, d14 * 16.0);
        }
    }
}

