/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.helper;

import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreed;
import info.ata4.minecraft.dragon.server.entity.helper.DragonBreedRegistry;
import info.ata4.minecraft.dragon.server.entity.helper.DragonHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonBreedHelper
extends DragonHelper {
    private static final Logger L = LogManager.getLogger();
    private static final int BLOCK_RANGE = 2;
    private static final String NBT_BREED = "Breed";
    private static final String NBT_BREED_POINTS = "breedPoints";
    private static final String DEFAULT_BREED = "end";
    private final DragonBreedRegistry registry = DragonBreedRegistry.getInstance();
    private final int dataIndex;
    private Map<DragonBreed, AtomicInteger> breedPoints = new HashMap<DragonBreed, AtomicInteger>();

    public DragonBreedHelper(EntityTameableDragon dragon, int dataIndex) {
        super(dragon);
        this.dataIndex = dataIndex;
        if (dragon.isServer()) {
            for (DragonBreed breed : this.registry.getBreeds()) {
                this.breedPoints.put(breed, new AtomicInteger());
            }
        }
        this.dataWatcher.func_75682_a(dataIndex, (Object)DEFAULT_BREED);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a(NBT_BREED, this.getBreed().getName());
        NBTTagCompound breedPointTag = new NBTTagCompound();
        for (Map.Entry<DragonBreed, AtomicInteger> breedPoint : this.breedPoints.entrySet()) {
            breedPointTag.func_74768_a(breedPoint.getKey().getName(), breedPoint.getValue().get());
        }
        nbt.func_74782_a(NBT_BREED_POINTS, (NBTBase)breedPointTag);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        String breedName = nbt.func_74779_i(NBT_BREED);
        DragonBreed newBreed = this.registry.getBreedByName(breedName);
        if (newBreed == null) {
            L.warn("Dragon {} loaded with invalid breed type {}, using {} instead", new Object[]{this.dragon.func_145782_y(), breedName, DEFAULT_BREED});
            newBreed = this.registry.getBreedByName(DEFAULT_BREED);
        }
        this.setBreed(newBreed);
        NBTTagCompound breedPointTag = nbt.func_74775_l(NBT_BREED_POINTS);
        for (Map.Entry<DragonBreed, AtomicInteger> breedPoint : this.breedPoints.entrySet()) {
            breedPoint.getValue().set(breedPointTag.func_74762_e(breedPoint.getKey().getName()));
        }
    }

    public Map<DragonBreed, AtomicInteger> getBreedPoints() {
        return Collections.unmodifiableMap(this.breedPoints);
    }

    public DragonBreed getBreed() {
        String breedName = this.dataWatcher.func_75681_e(this.dataIndex);
        DragonBreed breed = this.registry.getBreedByName(breedName);
        if (breed == null) {
            breed = this.registry.getBreedByName(DEFAULT_BREED);
        }
        return breed;
    }

    public void setBreed(DragonBreed newBreed) {
        L.trace("setBreed({})", new Object[]{newBreed});
        if (newBreed == null) {
            throw new NullPointerException();
        }
        if (this.dragon.isClient()) {
            return;
        }
        DragonBreed oldBreed = this.getBreed();
        if (oldBreed == newBreed) {
            return;
        }
        oldBreed.onDisable(this.dragon);
        newBreed.onEnable(this.dragon);
        this.dragon.setImmuneToFire(newBreed.isImmuneToDamage(DamageSource.field_76372_a) || newBreed.isImmuneToDamage(DamageSource.field_76370_b) || newBreed.isImmuneToDamage(DamageSource.field_76371_c));
        this.dataWatcher.func_75692_b(this.dataIndex, (Object)newBreed.getName());
    }

    @Override
    public void onLivingUpdate() {
        DragonBreed currentBreed = this.getBreed();
        if (this.dragon.isEgg()) {
            if (this.dragon.isClient() && this.dragon.field_70173_aa % 2 == 0 && !currentBreed.getName().equals(DEFAULT_BREED)) {
                double px = this.dragon.field_70165_t + (this.rand.nextDouble() - 0.5);
                double py = this.dragon.field_70163_u + (this.rand.nextDouble() - 0.5);
                double pz = this.dragon.field_70161_v + (this.rand.nextDouble() - 0.5);
                this.dragon.field_70170_p.func_72869_a("reddust", px, py + 1.0, pz, (double)currentBreed.getColorR(), (double)currentBreed.getColorG(), (double)currentBreed.getColorB());
            }
            if (this.dragon.isServer() && this.dragon.field_70173_aa % 20 == 0) {
                int bx = MathHelper.func_76128_c((double)this.dragon.field_70165_t);
                int by = MathHelper.func_76128_c((double)this.dragon.field_70163_u);
                int bz = MathHelper.func_76128_c((double)this.dragon.field_70161_v);
                for (int xn = -2; xn <= 2; ++xn) {
                    for (int zn = -2; zn <= 2; ++zn) {
                        for (int yn = -2; yn <= 2; ++yn) {
                            Block block = this.dragon.field_70170_p.func_147439_a(bx + xn, by + yn, bz + zn);
                            for (DragonBreed breed : this.breedPoints.keySet()) {
                                if (!breed.isHabitatBlock(block)) continue;
                                this.breedPoints.get(breed).incrementAndGet();
                            }
                        }
                    }
                }
                BiomeGenBase biome = this.dragon.field_70170_p.func_72807_a(bx, bz);
                for (DragonBreed breed : this.breedPoints.keySet()) {
                    if (breed.isHabitatBiome(biome)) {
                        this.breedPoints.get(breed).incrementAndGet();
                    }
                    if (!breed.isHabitatEnvironment(this.dragon)) continue;
                    this.breedPoints.get(breed).addAndGet(3);
                }
                DragonBreed newBreed = null;
                int maxPoints = 0;
                for (Map.Entry<DragonBreed, AtomicInteger> breedPoint : this.breedPoints.entrySet()) {
                    int points = breedPoint.getValue().get();
                    if (points <= maxPoints) continue;
                    newBreed = breedPoint.getKey();
                    maxPoints = points;
                }
                if (newBreed != null) {
                    this.setBreed(newBreed);
                }
            }
        }
        currentBreed.onUpdate(this.dragon);
    }

    @Override
    public void onDeath() {
        this.getBreed().onDeath(this.dragon);
    }

    public void inheritBreed(EntityTameableDragon parent1, EntityTameableDragon parent2) {
        this.breedPoints.get(parent1.getBreed()).addAndGet(1800 + this.rand.nextInt(1800));
        this.breedPoints.get(parent2.getBreed()).addAndGet(1800 + this.rand.nextInt(1800));
    }
}

