/*
 * Decompiled with CFR 0.152.
 */
package org.wyldmods.simpleachievements.common.networking;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import org.wyldmods.simpleachievements.common.NBTUtils;
import org.wyldmods.simpleachievements.common.TileEntityAchievementStand;
import org.wyldmods.simpleachievements.common.data.DataManager;

public class MessageAchievement
implements IMessage,
IMessageHandler<MessageAchievement, IMessage> {
    private static final MessageType[] VALUES = MessageType.values();
    private int data;
    private boolean state;
    private int x;
    private int y;
    private int z;
    private MessageType type;

    public MessageAchievement(int id) {
        this(id, false, 0, 0, 0, MessageType.PAGE);
    }

    public MessageAchievement(int id, boolean state) {
        this(id, state, 0, 0, 0, MessageType.TOGGLE);
    }

    public MessageAchievement(int page, int x, int y, int z) {
        this(page, false, x, y, z, MessageType.TILE);
    }

    private MessageAchievement(int id, boolean state, int x, int y, int z, MessageType type) {
        this.data = id;
        this.state = state;
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.data = buf.readInt();
        this.state = buf.readBoolean();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.type = VALUES[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.data);
        buf.writeBoolean(this.state);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.type.ordinal());
    }

    public IMessage onMessage(MessageAchievement message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        if (player == null) {
            return null;
        }
        switch (message.type) {
            case PAGE: {
                NBTUtils.getTag(player.func_71045_bC()).func_74768_a("sa:page", message.data);
                break;
            }
            case TILE: {
                TileEntity te = player.field_70170_p.func_147438_o(message.x, message.y, message.z);
                if (!(te instanceof TileEntityAchievementStand)) break;
                ((TileEntityAchievementStand)te).setPage(message.data);
                player.field_70170_p.func_147471_g(message.x, message.y, message.z);
                break;
            }
            case TOGGLE: {
                DataManager.INSTANCE.getHandlerFor((String)player.func_70005_c_()).getAchievement((int)message.data).state = message.state;
            }
        }
        return null;
    }

    public MessageAchievement() {
    }

    public static enum MessageType {
        TOGGLE,
        PAGE,
        TILE;

    }
}

