/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.TreeMap;
import mal.lootbags.BagTypes;
import mal.lootbags.LootBags;
import mal.lootbags.LootItem;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class LootMap {
    private TreeMap<String, LootItem> map = new TreeMap();
    private int totalWeight = 0;
    private Random random = new Random();

    public void addLootCategory(String categoryName) {
        WeightedRandomChestContent[] h = ChestGenHooks.getItems((String)categoryName, (Random)this.random);
        for (int i = 0; i < h.length; ++i) {
            WeightedRandomChestContent c = h[i];
            boolean skip = false;
            for (String modid : LootBags.MODBLACKLIST) {
                if (!GameRegistry.findUniqueIdentifierFor((Item)c.field_76297_b.func_77973_b()).modId.equalsIgnoreCase(modid)) continue;
                skip = true;
            }
            for (ItemStack istack : LootBags.BLACKLIST.get(0)) {
                if (!istack.func_77969_a(c.field_76297_b)) continue;
                skip = true;
            }
            if (skip) continue;
            ArrayList<BagTypes> ty = new ArrayList<BagTypes>();
            for (BagTypes t : BagTypes.droppableValues()) {
                for (ItemStack istack : LootBags.BLACKLIST.get(t.getIndex() + 1)) {
                    if (!istack.func_77969_a(c.field_76297_b)) continue;
                    ty.add(t);
                }
            }
            if (!this.map.containsKey(c.field_76297_b.toString())) {
                LootItem ii = new LootItem(c, BagTypes.Common, BagTypes.Legendary);
                ii.removeBagTypes(ty);
                this.map.put(c.field_76297_b.toString(), ii);
                this.totalWeight += c.field_76292_a;
                continue;
            }
            LootItem item = this.map.get(c.field_76297_b.toString());
            int weight = item.getContentItem().field_76292_a;
            this.totalWeight -= weight;
            item.getContentItem().field_76292_a = weight = (weight + c.field_76292_a) / 2;
            item.removeBagTypes(ty);
            this.map.put(c.field_76297_b.toString(), item);
            this.totalWeight += weight;
        }
    }

    public void addWhitelistedItems(String[][] whitelistlist) {
        for (int i = 0; i < whitelistlist.length; ++i) {
            for (String s : whitelistlist[i]) {
                String trim = s.trim();
                if (trim.isEmpty()) continue;
                String[] words = trim.split("\\s+");
                if (words.length == 3 && !OreDictionary.getOres((String)words[0]).isEmpty()) {
                    FMLLog.log((Level)Level.INFO, (String)("Added Whitelist item from OreDictionary: " + words[0] + "x" + words[1]), (Object[])new Object[0]);
                    ItemStack is = ((ItemStack)OreDictionary.getOres((String)words[0]).get(0)).func_77946_l();
                    is.field_77994_a = Integer.parseInt(words[1]);
                    WeightedRandomChestContent c = new WeightedRandomChestContent(is, 1, is.field_77994_a, Integer.parseInt(words[2]));
                    boolean skip = false;
                    for (String modid : LootBags.MODBLACKLIST) {
                        if (!GameRegistry.findUniqueIdentifierFor((Item)c.field_76297_b.func_77973_b()).modId.equalsIgnoreCase(modid)) continue;
                        skip = true;
                    }
                    for (ItemStack istack : LootBags.BLACKLIST.get(i)) {
                        if (!istack.func_77969_a(c.field_76297_b)) continue;
                        skip = true;
                    }
                    if (!skip) {
                        if (i == 0) {
                            this.map.put(c.field_76297_b.toString(), new LootItem(c, BagTypes.Common, BagTypes.Legendary));
                            this.totalWeight += c.field_76292_a;
                        } else {
                            int tier = i - 1;
                            BagTypes type = BagTypes.droppableValues()[tier].getIndex() == tier ? BagTypes.droppableValues()[tier] : BagTypes.Common;
                            if (!this.map.containsKey(c.field_76297_b.toString())) {
                                this.map.put(c.field_76297_b.toString(), new LootItem(c, type));
                                this.totalWeight += c.field_76292_a;
                            } else {
                                LootItem item = this.map.get(c.field_76297_b.toString());
                                item.addBagType(type);
                            }
                        }
                    } else {
                        FMLLog.log((Level)Level.INFO, (String)("Blacklisted item: " + GameRegistry.findUniqueIdentifierFor((Item)c.field_76297_b.func_77973_b()).toString() + " dropping from the LootBags whitelist from spawning in Loot Bags."), (Object[])new Object[0]);
                    }
                }
                if (words.length != 5) continue;
                ItemStack stack = null;
                Block block = GameRegistry.findBlock((String)words[0], (String)words[1]);
                Item item = GameRegistry.findItem((String)words[0], (String)words[1]);
                if (item != null) {
                    stack = new ItemStack(item, Integer.parseInt(words[3]), Integer.parseInt(words[2]));
                } else if (block != null) {
                    stack = new ItemStack(block, Integer.parseInt(words[3]), Integer.parseInt(words[2]));
                }
                if (stack == null || stack.func_77973_b() == null) continue;
                FMLLog.log((Level)Level.INFO, (String)("Added Whitelist item: " + stack.toString()), (Object[])new Object[0]);
                WeightedRandomChestContent c = new WeightedRandomChestContent(stack, 1, stack.field_77994_a, Integer.parseInt(words[4]));
                boolean skip = false;
                for (String modid : LootBags.MODBLACKLIST) {
                    if (!GameRegistry.findUniqueIdentifierFor((Item)c.field_76297_b.func_77973_b()).modId.equalsIgnoreCase(modid)) continue;
                    skip = true;
                }
                for (ItemStack istack : LootBags.BLACKLIST.get(i)) {
                    if (!istack.func_77969_a(c.field_76297_b)) continue;
                    skip = true;
                }
                if (!skip) {
                    if (i == 0) {
                        this.map.put(c.field_76297_b.toString(), new LootItem(c, BagTypes.Common, BagTypes.Legendary));
                        this.totalWeight += c.field_76292_a;
                        continue;
                    }
                    int tier = i - 1;
                    BagTypes type = BagTypes.droppableValues()[tier].getIndex() == tier ? BagTypes.droppableValues()[tier] : BagTypes.Common;
                    if (!this.map.containsKey(c.field_76297_b.toString())) {
                        this.map.put(c.field_76297_b.toString(), new LootItem(c, type));
                        this.totalWeight += c.field_76292_a;
                        continue;
                    }
                    LootItem iitem = this.map.get(c.field_76297_b.toString());
                    iitem.addBagType(type);
                    continue;
                }
                FMLLog.log((Level)Level.INFO, (String)("Blacklisted item: " + GameRegistry.findUniqueIdentifierFor((Item)c.field_76297_b.func_77973_b()).toString() + " dropping from the LootBags whitelist from spawning in Loot Bags."), (Object[])new Object[0]);
            }
        }
    }

    public ItemStack getRandomItem(int maxWeight, BagTypes type) {
        WeightedRandomChestContent[] content = this.generateContent(maxWeight, type);
        int randWeight = this.random.nextInt(this.generateMaxTotalWeight(content));
        WeightedRandomChestContent item = (WeightedRandomChestContent)WeightedRandom.getItem((WeightedRandom.Item[])content, (int)randWeight);
        for (int r = 0; item == null && r < LootBags.MAXREROLLCOUNT; ++r) {
            System.out.println("reroll null item");
            item = (WeightedRandomChestContent)WeightedRandom.getItem((WeightedRandom.Item[])content, (int)randWeight);
        }
        if (item == null) {
            return null;
        }
        ItemStack[] stacks = ChestGenHooks.generateStacks((Random)this.random, (ItemStack)item.field_76297_b, (int)item.field_76295_d, (int)item.field_76296_e);
        return stacks.length > 0 ? stacks[0] : null;
    }

    private WeightedRandomChestContent[] generateContent(int maxWeight, BagTypes type) {
        ArrayList<WeightedRandomChestContent> list = new ArrayList<WeightedRandomChestContent>();
        for (LootItem c : this.map.values()) {
            if (c.getContentItem().field_76292_a > maxWeight && maxWeight != -1 || !c.canDrop(type)) continue;
            list.add(c.getContentItem());
        }
        return list.toArray(new WeightedRandomChestContent[list.size()]);
    }

    private int generateMaxTotalWeight(WeightedRandomChestContent[] table) {
        int weight = 0;
        for (WeightedRandomChestContent c : table) {
            weight += c.field_76292_a;
        }
        return weight;
    }

    public int generatePercentileWeight(int percentile, BagTypes type) {
        LootItem[] lcontent = this.map.values().toArray(new LootItem[this.map.values().size()]);
        ArrayList<Integer> weights = new ArrayList<Integer>();
        for (LootItem c : lcontent) {
            if (!c.canDrop(type)) continue;
            weights.add(c.getContentItem().field_76292_a);
        }
        Collections.sort(weights);
        double val = (double)percentile / 100.0 * (double)weights.size();
        return (Integer)weights.get((int)Math.floor(val));
    }

    public int getLargestWeight() {
        int weight = 0;
        for (LootItem item : this.map.values()) {
            if (item.getContentItem().field_76292_a <= weight) continue;
            weight = item.getContentItem().field_76292_a;
        }
        return weight;
    }

    public ArrayList<ItemStack> getMapAsList() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (LootItem c : this.map.values()) {
            list.add(c.getContentItem().field_76297_b);
        }
        return list;
    }

    public ArrayList<WeightedRandomChestContent> getMapAsChestList() {
        ArrayList<WeightedRandomChestContent> list = new ArrayList<WeightedRandomChestContent>();
        for (LootItem c : this.map.values()) {
            list.add(c.getContentItem());
        }
        return list;
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }

    public boolean isItemInMap(ItemStack is) {
        ArrayList<ItemStack> list = this.getMapAsList();
        for (ItemStack i : list) {
            if (!LootBags.areItemStacksEqualItem(i, is, false, false)) continue;
            return true;
        }
        return false;
    }

    public void printMap() {
        for (String i : this.map.keySet()) {
            System.out.println(i + ": " + this.map.get((Object)i).getContentItem().field_76292_a + ": " + this.map.get((Object)i).getContentItem().field_76295_d + ": " + this.map.get((Object)i).getContentItem().field_76296_e);
        }
        System.out.println("Total Weight: " + this.totalWeight);
    }
}

