/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.world;

import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.world.WorldGenEnderComet;
import com.brandon3055.draconicevolution.common.world.WorldGenEnderIsland;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class DraconicWorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case 0: {
                this.generateSurface(random, chunkX * 16, chunkZ * 16, world);
                break;
            }
            case 1: {
                this.generateEnd(random, chunkX * 16, chunkZ * 16, world);
                break;
            }
            case -1: {
                this.generateNether(random, chunkX * 16, chunkZ * 16, world);
                break;
            }
            default: {
                int[] arr$ = ConfigHandler.oreGenDimentionBlacklist;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Integer i = arr$[i$];
                    if (i != world.field_73011_w.field_76574_g) continue;
                    return;
                }
                this.addOreSpawn(ModBlocks.draconiumOre, world, random, chunkX * 16, chunkZ * 16, 3, 4, 2, 2, 8);
            }
        }
    }

    public void generateSurface(Random random, int x, int z, World world) {
        if (!ConfigHandler.disableOreSpawnOverworld) {
            this.addOreSpawn(ModBlocks.draconiumOre, world, random, x, z, 3, 4, 2, 2, 8);
        }
    }

    public void generateEnd(Random random, int x, int z, World world) {
        int x1 = x + random.nextInt(16);
        int y = 20 + random.nextInt(170);
        int z1 = z + random.nextInt(16);
        if (ConfigHandler.generateEnderComets && Math.sqrt(x * x + z * z) > 200.0 && random.nextInt(Math.max(1, ConfigHandler.cometRarity)) == 0) {
            new WorldGenEnderComet().func_76484_a(world, random, x1, y, z1);
        }
        int cX = x / 16;
        int cZ = z / 16;
        if (ConfigHandler.generateChaosIslands && Math.sqrt(x * x + z * z) > 9000.0 && cX % 625 == 0 && cZ % 625 == 0) {
            new WorldGenEnderIsland().func_76484_a(world, random, x1, 100, z1);
        }
        if (!ConfigHandler.disableOreSpawnEnd) {
            this.addOreSpawn(ModBlocks.draconiumOre, world, random, x, z, 4, 5, 10, 1, 70);
        }
    }

    public void generateNether(Random random, int chunkX, int chunkZ, World world) {
        if (!ConfigHandler.disableOreSpawnNether) {
            this.addOreSpawn(ModBlocks.draconiumOre, world, random, chunkX, chunkZ, 3, 4, 5, 1, 125);
        }
    }

    public void addOreSpawn(Block block, World world, Random random, int chunkXPos, int chunkZPos, int minVainSize, int maxVainSize, int chancesToSpawn, int minY, int maxY) {
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = chunkXPos + random.nextInt(16);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = chunkZPos + random.nextInt(16);
            new WorldGenMinable(block, 0, minVainSize + random.nextInt(maxVainSize - minVainSize), Blocks.field_150377_bs).func_76484_a(world, random, posX, posY, posZ);
            new WorldGenMinable(block, 0, 3, Blocks.field_150348_b).func_76484_a(world, random, posX, posY, posZ);
            new WorldGenMinable(block, 0, minVainSize + random.nextInt(maxVainSize - minVainSize), Blocks.field_150424_aL).func_76484_a(world, random, posX, posY, posZ);
        }
    }
}

