/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagString;
import openmods.utils.StringUtils;
import openperipheral.addons.api.ITerminalItem;

public class TerminalUtils {
    public static final UUID GLOBAL_SURFACE_UUID = UUID.fromString("df66eff0-1cae-11e4-8c21-0800200c9a66");
    public static final String GLOBAL_MARKER = "GLOBAL";
    public static final String PRIVATE_MARKER = "PRIVATE";

    public static Long extractGuid(NBTTagCompound tag) {
        NBTBase guidTag = tag.func_74781_a("guid");
        if (guidTag instanceof NBTTagString) {
            String value = ((NBTTagString)guidTag).func_150285_a_();
            return Long.parseLong(value.toLowerCase(), 36);
        }
        if (guidTag instanceof NBTTagLong) {
            return ((NBTBase.NBTPrimitive)guidTag).func_150291_c();
        }
        return null;
    }

    public static String formatTerminalId(long terminalId) {
        return Long.toString(terminalId, 36).toUpperCase();
    }

    static long generateGuid() {
        return Long.parseLong(StringUtils.randomString((int)8), 36);
    }

    public static ItemStack getHeadSlot(EntityPlayer player) {
        return player.field_71071_by.func_70440_f(3);
    }

    public static Long tryGetTerminalGuid(ItemStack stack) {
        Item item;
        if (stack != null && (item = stack.func_77973_b()) instanceof ITerminalItem) {
            return ((ITerminalItem)item).getTerminalGuid(stack);
        }
        return null;
    }

    public static Long tryGetTerminalGuid(EntityPlayer player) {
        ItemStack stack = TerminalUtils.getHeadSlot(player);
        return TerminalUtils.tryGetTerminalGuid(stack);
    }
}

