/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.texture.ExtraBlockTextures;
import appeng.helpers.Splotch;
import appeng.tile.misc.TilePaint;
import java.util.EnumSet;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderBlockPaint
extends BaseBlockRender {
    public RenderBlockPaint() {
        super(false, 0.0);
    }

    @Override
    public void renderInventory(AEBaseBlock block, ItemStack is, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] obj) {
    }

    @Override
    public boolean renderInWorld(AEBaseBlock imb, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        TilePaint tp = (TilePaint)imb.getTileEntity(world, x, y, z);
        boolean out = false;
        if (tp != null) {
            IIcon[] icoSet = new IIcon[]{imb.func_149691_a(0, 0), ExtraBlockTextures.BlockPaint2.getIcon(), ExtraBlockTextures.BlockPaint3.getIcon()};
            Tessellator tess = Tessellator.field_78398_a;
            int lumen = 0xE000E0;
            int brightness = imb.func_149677_c(world, x, y, z);
            double offsetConstant = 0.001;
            EnumSet<ForgeDirection> validSides = EnumSet.noneOf(ForgeDirection.class);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                if (!tp.isSideValid(side)) continue;
                validSides.add(side);
            }
            for (Splotch s : tp.getDots()) {
                if (!validSides.contains(s.side)) continue;
                if (s.lumen) {
                    tess.func_78378_d(s.color.whiteVariant);
                    tess.func_78380_c(lumen);
                } else {
                    tess.func_78378_d(s.color.mediumVariant);
                    tess.func_78380_c(brightness);
                }
                double offset = offsetConstant;
                offsetConstant += 0.001;
                double H = 0.1;
                double pos_x = s.x();
                double pos_y = s.y();
                pos_x = Math.max(H, Math.min(1.0 - H, pos_x));
                pos_y = Math.max(H, Math.min(1.0 - H, pos_y));
                if (s.side == ForgeDirection.SOUTH || s.side == ForgeDirection.NORTH) {
                    pos_x += (double)x;
                    pos_y += (double)y;
                } else if (s.side == ForgeDirection.UP || s.side == ForgeDirection.DOWN) {
                    pos_x += (double)x;
                    pos_y += (double)z;
                } else {
                    pos_x += (double)y;
                    pos_y += (double)z;
                }
                IIcon ico = icoSet[s.getSeed() % icoSet.length];
                switch (s.side) {
                    case UP: {
                        offset = 1.0 - offset;
                        tess.func_78374_a(pos_x - H, (double)y + offset, pos_y - H, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                        tess.func_78374_a(pos_x + H, (double)y + offset, pos_y - H, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                        tess.func_78374_a(pos_x + H, (double)y + offset, pos_y + H, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                        tess.func_78374_a(pos_x - H, (double)y + offset, pos_y + H, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                        break;
                    }
                    case DOWN: {
                        tess.func_78374_a(pos_x + H, (double)y + offset, pos_y - H, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                        tess.func_78374_a(pos_x - H, (double)y + offset, pos_y - H, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                        tess.func_78374_a(pos_x - H, (double)y + offset, pos_y + H, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                        tess.func_78374_a(pos_x + H, (double)y + offset, pos_y + H, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                        break;
                    }
                    case EAST: {
                        offset = 1.0 - offset;
                        tess.func_78374_a((double)x + offset, pos_x + H, pos_y - H, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                        tess.func_78374_a((double)x + offset, pos_x - H, pos_y - H, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                        tess.func_78374_a((double)x + offset, pos_x - H, pos_y + H, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                        tess.func_78374_a((double)x + offset, pos_x + H, pos_y + H, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                        break;
                    }
                    case WEST: {
                        tess.func_78374_a((double)x + offset, pos_x - H, pos_y - H, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                        tess.func_78374_a((double)x + offset, pos_x + H, pos_y - H, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                        tess.func_78374_a((double)x + offset, pos_x + H, pos_y + H, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                        tess.func_78374_a((double)x + offset, pos_x - H, pos_y + H, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                        break;
                    }
                    case SOUTH: {
                        offset = 1.0 - offset;
                        tess.func_78374_a(pos_x + H, pos_y - H, (double)z + offset, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                        tess.func_78374_a(pos_x - H, pos_y - H, (double)z + offset, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                        tess.func_78374_a(pos_x - H, pos_y + H, (double)z + offset, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                        tess.func_78374_a(pos_x + H, pos_y + H, (double)z + offset, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                        break;
                    }
                    case NORTH: {
                        tess.func_78374_a(pos_x - H, pos_y - H, (double)z + offset, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                        tess.func_78374_a(pos_x + H, pos_y - H, (double)z + offset, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                        tess.func_78374_a(pos_x + H, pos_y + H, (double)z + offset, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                        tess.func_78374_a(pos_x - H, pos_y + H, (double)z + offset, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                        break;
                    }
                }
            }
            out = true;
        }
        return out;
    }
}

