/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.wrappers;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Set;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.architecture.ExcludeArchitecture;

public class MethodMetaExtractor {
    private static final boolean DEFAULT_ASYNC = false;
    private static final ImmutableSet<String> DEFAULT_BLACKLIST = ImmutableSet.of();
    private final boolean classIsAsync;
    private final Set<String> classExcludedArchitectures;

    private static boolean isAsynchronous(AnnotatedElement element, boolean defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        Asynchronous async = element.getAnnotation(Asynchronous.class);
        return async != null ? async.value() : defaultValue;
    }

    private static Set<String> getArchBlacklist(AnnotatedElement element, Set<String> defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        ExcludeArchitecture blacklist = element.getAnnotation(ExcludeArchitecture.class);
        return blacklist != null ? ImmutableSet.copyOf((Object[])blacklist.value()) : defaultValue;
    }

    public MethodMetaExtractor(Class<?> cls) {
        Package pkg = cls.getPackage();
        this.classIsAsync = MethodMetaExtractor.isAsynchronous(cls, false);
        Set<String> pkgExcludedArchitectures = MethodMetaExtractor.getArchBlacklist(pkg, DEFAULT_BLACKLIST);
        this.classExcludedArchitectures = MethodMetaExtractor.getArchBlacklist(cls, pkgExcludedArchitectures);
    }

    public boolean isAsync(Method method) {
        return MethodMetaExtractor.isAsynchronous(method, this.classIsAsync);
    }

    public Set<String> getExcludedArchitectures(Method method) {
        return MethodMetaExtractor.getArchBlacklist(method, this.classExcludedArchitectures);
    }
}

