/*
 * Decompiled with CFR 0.152.
 */
package openperipheral;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.Loader;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import openmods.Log;
import openperipheral.ApiImplementation;
import openperipheral.ApiSingleton;
import openperipheral.adapter.AdapterRegistryWrapper;
import openperipheral.adapter.TileEntityBlacklist;
import openperipheral.api.ApiAccess;
import openperipheral.api.IApiInterface;
import openperipheral.converter.TypeConvertersProvider;
import openperipheral.interfaces.cc.ModuleComputerCraft;
import openperipheral.interfaces.oc.ModuleOpenComputers;
import openperipheral.meta.EntityMetadataBuilder;
import openperipheral.meta.ItemStackMetadataBuilder;

public class ApiProvider
implements ApiAccess.ApiProvider {
    private final Map<Class<? extends IApiInterface>, IApiInstanceProvider<?>> PROVIDERS = Maps.newHashMap();

    private static void listAllImplementedApis(Collection<Class<? extends IApiInterface>> output, Class<?> ... intfs) {
        for (Class<?> cls : intfs) {
            Preconditions.checkArgument((boolean)cls.isInterface());
            if (cls == IApiInterface.class || !IApiInterface.class.isAssignableFrom(cls)) continue;
            output.add(cls);
        }
    }

    private static void addAllInterfaces(Set<Class<? extends IApiInterface>> interfaces) {
        Class cls;
        LinkedList queue = Lists.newLinkedList(interfaces);
        while ((cls = (Class)queue.poll()) != null) {
            interfaces.add(cls);
            ApiProvider.listAllImplementedApis(queue, cls.getInterfaces());
        }
    }

    private <T extends IApiInterface> void registerInterfaces(Class<? extends T> cls, IApiInstanceProvider<T> provider, boolean includeSuper) {
        HashSet implemented = Sets.newHashSet();
        ApiProvider.listAllImplementedApis(implemented, cls.getInterfaces());
        if (includeSuper) {
            ApiProvider.addAllInterfaces(implemented);
        }
        for (Class impl : implemented) {
            IApiInstanceProvider<T> prev = this.PROVIDERS.put(impl, provider);
            Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Conflict on %s: %s -> %s", (Object[])new Object[]{impl, prev, provider});
        }
    }

    public <T extends IApiInterface> void registerClass(Class<? extends T> cls) {
        Preconditions.checkArgument((!Modifier.isAbstract(cls.getModifiers()) ? 1 : 0) != 0);
        ApiImplementation meta = cls.getAnnotation(ApiImplementation.class);
        Preconditions.checkNotNull((Object)meta);
        IApiInstanceProvider<? extends T> provider = meta.cacheable() ? new SingleInstanceProvider<T>(cls) : new NewInstanceProvider<T>(cls);
        this.registerInterfaces(cls, provider, meta.includeSuper());
    }

    private <T extends IApiInterface> void registerInstance(T obj) {
        Class<?> cls = obj.getClass();
        ApiSingleton meta = cls.getAnnotation(ApiSingleton.class);
        Preconditions.checkNotNull((Object)meta);
        SingletonProvider<T> provider = new SingletonProvider<T>(obj);
        this.registerInterfaces(cls, provider, meta.includeSuper());
    }

    private ApiProvider() {
        this.registerClass(AdapterRegistryWrapper.Peripherals.class);
        this.registerClass(AdapterRegistryWrapper.Objects.class);
        this.registerClass(EntityMetadataBuilder.class);
        this.registerClass(ItemStackMetadataBuilder.class);
        this.registerInstance(TypeConvertersProvider.INSTANCE);
        this.registerInstance(TileEntityBlacklist.INSTANCE);
        if (Loader.isModLoaded((String)"ComputerCraft")) {
            ModuleComputerCraft.installAPI(this);
        }
        if (Loader.isModLoaded((String)"OpenComputers")) {
            ModuleOpenComputers.installAPI(this);
        }
    }

    @Override
    public <T extends IApiInterface> T getApi(Class<T> cls) {
        IApiInstanceProvider<?> provider = this.PROVIDERS.get(cls);
        Preconditions.checkNotNull(provider, (String)"Can't get implementation for class %s", (Object[])new Object[]{cls});
        return (T)provider.getInterface();
    }

    @Override
    public <T extends IApiInterface> boolean isApiPresent(Class<T> cls) {
        return this.PROVIDERS.containsKey(cls);
    }

    static void installApi() {
        String apiSource;
        String presentApiVersion;
        try {
            presentApiVersion = "3.2";
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to get OpenPeripheralCore API version, class missing?", t);
        }
        try {
            apiSource = ApiAccess.class.getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (Throwable t) {
            apiSource = "<unknown, see logs>";
            Log.severe((Throwable)t, (String)"Failed to get OpenPeripheralCore API source", (Object[])new Object[0]);
        }
        Preconditions.checkState((boolean)"3.2".equals(presentApiVersion), (String)"OpenPeripheralCore version mismatch, should be %s, is %s (ApiAccess source: %s)", (Object[])new Object[]{"3.2", presentApiVersion, apiSource});
        try {
            ApiAccess.init(new ApiProvider());
        }
        catch (Throwable t) {
            throw new IllegalStateException(String.format("Failed to register OpenPeripheralCore API provider (ApiAccess source: %s)", apiSource), t);
        }
        Log.info((String)"OPC API v. %s provideded by OpenPeripheralCore, (ApiAccess source: %s)", (Object[])new Object[]{presentApiVersion, apiSource});
    }

    private static class SingletonProvider<T extends IApiInterface>
    implements IApiInstanceProvider<T> {
        private final T obj;

        public SingletonProvider(T obj) {
            this.obj = obj;
        }

        @Override
        public T getInterface() {
            return this.obj;
        }

        public String toString() {
            return "SingletonProvider [obj=" + this.obj + "]";
        }
    }

    private static class NewInstanceProvider<T extends IApiInterface>
    implements IApiInstanceProvider<T> {
        private final Class<? extends T> cls;

        public NewInstanceProvider(Class<? extends T> cls) {
            this.cls = cls;
        }

        @Override
        public T getInterface() {
            try {
                return (T)((IApiInterface)this.cls.newInstance());
            }
            catch (Throwable t) {
                throw Throwables.propagate((Throwable)t);
            }
        }

        public String toString() {
            return "NewInstanceProvider [cls=" + this.cls + "]";
        }
    }

    private static class SingleInstanceProvider<T extends IApiInterface>
    implements IApiInstanceProvider<T> {
        private final T instance;

        public SingleInstanceProvider(Class<? extends T> cls) {
            try {
                this.instance = (IApiInterface)cls.newInstance();
            }
            catch (Throwable t) {
                throw Throwables.propagate((Throwable)t);
            }
        }

        @Override
        public T getInterface() {
            return this.instance;
        }

        public String toString() {
            return "SingleInstanceProvider [instance=" + this.instance + "]";
        }
    }

    public static interface IApiInstanceProvider<T extends IApiInterface> {
        public T getInterface();
    }
}

