/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.lib.inventory.IItemMap;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.network.MessageItemStacksList;
import tuhljin.automagy.network.MessageItemStacksRequested;
import tuhljin.automagy.tiles.IInventariumBook;

public class ContainerScribe
extends Container {
    public IInventariumBook book;
    protected TileEntity te;
    protected IItemMap prevListLocal;
    protected IItemMap prevListInventarium;
    protected IItemMap prevListRequested;
    public static int XOFFSET_DEMAND = 30;
    protected final boolean hasLocalItems;
    protected final boolean hasDemand;
    private WorldSpecificCoordinates invCoord;

    public ContainerScribe(InventoryPlayer inventoryPlayer, IInventariumBook book, boolean hasLocalItems, boolean hasDemand) {
        int i;
        this.book = book;
        this.hasLocalItems = hasLocalItems;
        this.hasDemand = hasDemand;
        if (book instanceof TileEntity) {
            this.te = (TileEntity)book;
        }
        if (book.isInventariumLoaded()) {
            this.invCoord = book.getLinkCoord();
            if (hasLocalItems) {
                this.prevListLocal = book.getLocalItemList();
            }
            this.prevListInventarium = book.getInventariumItemList();
            if (hasDemand) {
                this.prevListRequested = book.getInventariumRequestedItemList().copy();
            }
        }
        int xOffset = hasDemand ? XOFFSET_DEMAND : 0;
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18 + 16 + xOffset, 198));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, 9 + j + i * 9, 8 + j * 18 + 16 + xOffset, 84 + i * 18 + 56));
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.book.isInventariumLoaded() && this.book.isUseableByPlayer(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNum) {
        return null;
    }

    public void func_75142_b() {
        IItemMap itemList;
        ArrayList<ItemStack> list;
        super.func_75142_b();
        if (this.hasLocalItems && (list = ContainerScribe.getUpdatedItems(itemList = this.book.getLocalItemList(), this.prevListLocal)).size() > 0) {
            this.prevListLocal = itemList;
            for (Object player : this.field_75149_d) {
                if (!(player instanceof EntityPlayer)) continue;
                MessageItemStacksList.sendToClient((EntityPlayer)player, this.te.func_145831_w(), this.te.field_145851_c, this.te.field_145848_d, this.te.field_145849_e, list, true, true);
            }
        }
        if ((list = ContainerScribe.getUpdatedItems(itemList = this.book.getInventariumItemList(), this.prevListInventarium)).size() > 0) {
            this.prevListInventarium = itemList;
            for (Object player : this.field_75149_d) {
                if (!(player instanceof EntityPlayer)) continue;
                MessageItemStacksList.sendToClient((EntityPlayer)player, this.invCoord.dim, this.invCoord.x, this.invCoord.y, this.invCoord.z, list, true, false);
            }
        }
        if (this.hasDemand && (list = ContainerScribe.getUpdatedItems(itemList = this.book.getInventariumRequestedItemList(), this.prevListRequested)).size() > 0) {
            this.prevListRequested = itemList.copy();
            for (Object player : this.field_75149_d) {
                if (!(player instanceof EntityPlayer)) continue;
                MessageItemStacksRequested.sendToClient((EntityPlayer)player, this.invCoord.dim, this.invCoord.x, this.invCoord.y, this.invCoord.z, list, true);
            }
        }
    }

    public static ArrayList<ItemStack> getUpdatedItems(IItemMap newList, IItemMap oldList) {
        HashableItemWithoutSize key;
        Map.Entry<HashableItemWithoutSize, Integer> entry;
        Iterator<Map.Entry<HashableItemWithoutSize, Integer>> iter;
        ArrayList<ItemStack> changed = new ArrayList<ItemStack>();
        if (newList != null) {
            iter = newList.getIterator();
            while (iter.hasNext()) {
                entry = iter.next();
                key = entry.getKey();
                int count = entry.getValue();
                if (oldList != null && oldList.get(key) == count) continue;
                changed.add(key.getItemStack(count));
            }
        }
        if (oldList != null) {
            iter = oldList.getIterator();
            while (iter.hasNext()) {
                entry = iter.next();
                key = entry.getKey();
                if (newList != null && newList.containsKey(key)) continue;
                changed.add(key.getItemStack(0));
            }
        }
        return changed;
    }
}

