/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.parts;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.core.WorldSettings;
import appeng.util.Platform;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.grid.AEPartGridBlock;
import thaumicenergistics.gui.ThEGuiHandler;
import thaumicenergistics.registries.AEPartsEnum;
import thaumicenergistics.registries.ItemEnum;
import thaumicenergistics.texture.BlockTextureManager;
import thaumicenergistics.util.EffectiveSide;

public abstract class AbstractAEPartBase
implements IPart,
IGridHost,
IActionHost {
    private static final String NBT_KEY_OWNER = "Owner";
    protected static final int INVENTORY_OVERLAY_COLOR = AEColor.Black.blackVariant;
    protected static final int ACTIVE_BRIGHTNESS = 0xD000D0;
    protected ForgeDirection cableSide;
    protected IGridNode node;
    protected IPartHost host;
    protected boolean isActive;
    protected AEPartGridBlock gridBlock;
    protected TileEntity tile;
    protected TileEntity hostTile;
    protected boolean redstonePowered;
    private int ownerID = -1;
    public final ItemStack associatedItem;

    public AbstractAEPartBase(AEPartsEnum associatedPart) {
        this.associatedItem = ItemEnum.ITEM_AEPART.getItemStackWithDamage(associatedPart.ordinal());
    }

    private void updateStatus() {
        if (EffectiveSide.isClientSide()) {
            return;
        }
        if (this.node != null) {
            this.node.updateState();
            boolean currentlyActive = this.node.isActive();
            if (currentlyActive != this.isActive) {
                this.isActive = currentlyActive;
                this.onNeighborChanged();
                this.host.markForUpdate();
            }
        }
    }

    protected abstract boolean canPlayerOpenGui(int var1);

    protected boolean doesPlayerHaveSecurityClearance(int playerID, SecurityPermissions permission) {
        ISecurityGrid sGrid = this.gridBlock.getSecurityGrid();
        if (sGrid == null) {
            return false;
        }
        return sGrid.hasPermission(playerID, permission);
    }

    protected TileEntity getFacingTile() {
        World world = this.hostTile.func_145831_w();
        int x = this.hostTile.field_145851_c;
        int y = this.hostTile.field_145848_d;
        int z = this.hostTile.field_145849_e;
        return world.func_147438_o(x + this.cableSide.offsetX, y + this.cableSide.offsetY, z + this.cableSide.offsetZ);
    }

    protected boolean isActive() {
        if (EffectiveSide.isServerSide() && this.node != null) {
            this.isActive = this.node.isActive();
        }
        return this.isActive;
    }

    public void addToWorld() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.gridBlock = new AEPartGridBlock(this);
            this.node = AEApi.instance().createGridNode((IGridBlock)this.gridBlock);
            this.node.setPlayerID(this.ownerID);
            this.setPower(null);
        }
    }

    public abstract int cableConnectionRenderTo();

    public boolean canBePlacedOn(BusSupport type) {
        return type != BusSupport.DENSE_CABLE;
    }

    public boolean canConnectRedstone() {
        return false;
    }

    public final boolean doesPlayerHavePermissionToOpenGui(EntityPlayer player) {
        int pID = WorldSettings.getInstance().getPlayerID(player.func_146103_bH());
        return this.canPlayerOpenGui(pID);
    }

    public IGridNode getActionableNode() {
        return this.node;
    }

    public abstract void getBoxes(IPartCollisionHelper var1);

    public abstract IIcon getBreakingTexture();

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    public Object getClientGuiElement(EntityPlayer player) {
        return null;
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
    }

    public final IGridNode getExternalFacingNode() {
        return null;
    }

    public AEPartGridBlock getGridBlock() {
        return this.gridBlock;
    }

    public IGridNode getGridNode() {
        return this.node;
    }

    public IGridNode getGridNode(ForgeDirection direction) {
        return this.node;
    }

    public IPartHost getHost() {
        return this.host;
    }

    public final TileEntity getHostTile() {
        return this.hostTile;
    }

    public abstract double getIdlePowerUsage();

    public ItemStack getItemStack(PartItemStack partItemStack) {
        ItemStack itemStack = new ItemStack(ItemEnum.ITEM_AEPART.getItem(), 1, AEPartsEnum.getPartID(this.getClass()));
        if (partItemStack != PartItemStack.Break) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            this.writeToNBT(itemNBT);
            itemStack.func_77982_d(itemNBT);
        }
        return itemStack;
    }

    public abstract int getLightLevel();

    public final DimensionalCoord getLocation() {
        return new DimensionalCoord(this.tile.func_145831_w(), this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e);
    }

    public Object getServerGuiElement(EntityPlayer player) {
        return null;
    }

    public ForgeDirection getSide() {
        return this.cableSide;
    }

    public String getUnlocalizedName() {
        return this.associatedItem.func_77977_a() + ".name";
    }

    public boolean isLadder(EntityLivingBase entity) {
        return false;
    }

    public int isProvidingStrongPower() {
        return 0;
    }

    public int isProvidingWeakPower() {
        return 0;
    }

    public boolean isSolid() {
        return false;
    }

    public boolean onActivate(EntityPlayer player, Vec3 position) {
        if (player.func_70093_af()) {
            return false;
        }
        if (EffectiveSide.isServerSide()) {
            ThEGuiHandler.launchGui(this, player, this.hostTile.func_145831_w(), this.hostTile.field_145851_c, this.hostTile.field_145848_d, this.hostTile.field_145849_e);
        }
        return true;
    }

    public void onEntityCollision(Entity entity) {
    }

    public void onNeighborChanged() {
        if (this.hostTile != null) {
            World world = this.hostTile.func_145831_w();
            int x = this.hostTile.field_145851_c;
            int y = this.hostTile.field_145848_d;
            int z = this.hostTile.field_145849_e;
            this.redstonePowered = world.func_72864_z(x, y, z);
        }
    }

    public final void onPlacement(EntityPlayer player, ItemStack held, ForgeDirection side) {
        this.ownerID = WorldSettings.getInstance().getPlayerID(player.func_146103_bH());
    }

    public boolean onShiftActivate(EntityPlayer player, Vec3 position) {
        return false;
    }

    public void randomDisplayTick(World world, int x, int y, int z, Random r) {
    }

    public void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b(NBT_KEY_OWNER)) {
            this.ownerID = data.func_74762_e(NBT_KEY_OWNER);
        }
    }

    public boolean readFromStream(ByteBuf data) throws IOException {
        this.isActive = data.readBoolean();
        return true;
    }

    public void removeFromWorld() {
        if (this.node != null) {
            this.node.destroy();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double x, double y, double z, IPartRenderHelper helper, RenderBlocks renderer) {
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderInventory(IPartRenderHelper var1, RenderBlocks var2);

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryBusLights(IPartRenderHelper helper, RenderBlocks renderer) {
        helper.setInvColor(0xFFFFFF);
        IIcon busColorTexture = BlockTextureManager.BUS_COLOR.getTextures()[0];
        IIcon sideTexture = BlockTextureManager.BUS_COLOR.getTextures()[2];
        helper.setTexture(busColorTexture, busColorTexture, sideTexture, sideTexture, busColorTexture, busColorTexture);
        helper.renderInventoryBox(renderer);
        Tessellator.field_78398_a.func_78380_c(0xD000D0);
        helper.setInvColor(AEColor.Transparent.blackVariant);
        IIcon lightTexture = BlockTextureManager.BUS_COLOR.getTextures()[1];
        helper.renderInventoryFace(lightTexture, ForgeDirection.UP, renderer);
        helper.renderInventoryFace(lightTexture, ForgeDirection.DOWN, renderer);
        helper.renderInventoryFace(lightTexture, ForgeDirection.NORTH, renderer);
        helper.renderInventoryFace(lightTexture, ForgeDirection.EAST, renderer);
        helper.renderInventoryFace(lightTexture, ForgeDirection.SOUTH, renderer);
        helper.renderInventoryFace(lightTexture, ForgeDirection.WEST, renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderStatic(int var1, int var2, int var3, IPartRenderHelper var4, RenderBlocks var5);

    @SideOnly(value=Side.CLIENT)
    public void renderStaticBusLights(int x, int y, int z, IPartRenderHelper helper, RenderBlocks renderer) {
        IIcon busColorTexture = BlockTextureManager.BUS_COLOR.getTextures()[0];
        IIcon sideTexture = BlockTextureManager.BUS_COLOR.getTextures()[2];
        helper.setTexture(busColorTexture, busColorTexture, sideTexture, sideTexture, busColorTexture, busColorTexture);
        helper.renderBlock(x, y, z, renderer);
        if (this.isActive()) {
            Tessellator.field_78398_a.func_78380_c(0xD000D0);
            Tessellator.field_78398_a.func_78378_d(this.host.getColor().blackVariant);
        } else {
            Tessellator.field_78398_a.func_78378_d(0);
        }
        IIcon lightTexture = BlockTextureManager.BUS_COLOR.getTextures()[1];
        helper.renderFace(x, y, z, lightTexture, ForgeDirection.UP, renderer);
        helper.renderFace(x, y, z, lightTexture, ForgeDirection.DOWN, renderer);
        helper.renderFace(x, y, z, lightTexture, ForgeDirection.NORTH, renderer);
        helper.renderFace(x, y, z, lightTexture, ForgeDirection.EAST, renderer);
        helper.renderFace(x, y, z, lightTexture, ForgeDirection.SOUTH, renderer);
        helper.renderFace(x, y, z, lightTexture, ForgeDirection.WEST, renderer);
    }

    public boolean requireDynamicRender() {
        return false;
    }

    public void securityBreak() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(this.getItemStack(null));
        this.getDrops(drops, false);
        Platform.spawnDrops((World)this.hostTile.func_145831_w(), (int)this.hostTile.field_145851_c, (int)this.hostTile.field_145848_d, (int)this.hostTile.field_145849_e, drops);
        this.host.removePart(this.cableSide, false);
    }

    public final void setPartHostInfo(ForgeDirection side, IPartHost host, TileEntity tile) {
        this.cableSide = side;
        this.host = host;
        this.tile = tile;
        this.hostTile = tile;
    }

    @MENetworkEventSubscribe
    public final void setPower(MENetworkPowerStatusChange event) {
        this.updateStatus();
        this.host.markForUpdate();
    }

    public void setupPartFromItem(ItemStack itemPart) {
        if (itemPart.func_77942_o()) {
            this.readFromNBT(itemPart.func_77978_p());
        }
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged event) {
        this.updateStatus();
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74768_a(NBT_KEY_OWNER, this.ownerID);
    }

    public void writeToStream(ByteBuf data) throws IOException {
        data.writeBoolean(this.node != null && this.node.isActive());
    }
}

