/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.addons.tinkersconstruct;

import cpw.mods.fml.common.Loader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class AddonTinkersTiles
implements IWailaDataProvider {
    private static String showDryerTime = "wawla.tinkers.showDryerTime";
    private static String showDryerItem = "wawla.tinkers.showDryerItem";
    private static String showFurnaceItem = "wawla.tinkers.showFurnace";
    private static String showBurnTime = "wawla.tinkers.showBurnTime";
    private static String hideLandmine = "wawla.tinkers.hideLandmine";
    public static boolean isEnabled = false;
    public static Class classHarvestTool = null;
    public static Class classDualHarvestTool = null;
    public static Class classDryingRackLogic = null;
    public static Class classFurnaceLogic = null;
    public static Class classBlockLandmine = null;
    public static Class classDryingRack = null;
    public static Class classFurnaceSlab = null;
    public static Method getHarvestType = null;
    public static Method getSecondHarvestType = null;

    public AddonTinkersTiles() {
        if (Loader.isModLoaded((String)"TConstruct")) {
            isEnabled = true;
            try {
                classHarvestTool = Class.forName("tconstruct.library.tools.HarvestTool");
                classDualHarvestTool = Class.forName("tconstruct.library.tools.DualHarvestTool");
                classDryingRackLogic = Class.forName("tconstruct.blocks.logic.DryingRackLogic");
                classFurnaceLogic = Class.forName("tconstruct.tools.logic.FurnaceLogic");
                classBlockLandmine = Class.forName("tconstruct.mechworks.blocks.BlockLandmine");
                classDryingRack = Class.forName("tconstruct.armor.blocks.DryingRack");
                classFurnaceSlab = Class.forName("tconstruct.tools.blocks.FurnaceSlab");
                getHarvestType = classHarvestTool.getDeclaredMethod("getHarvestType", new Class[0]);
                getSecondHarvestType = classDualHarvestTool.getDeclaredMethod("getSecondHarvestType", new Class[0]);
                getHarvestType.setAccessible(true);
                getSecondHarvestType.setAccessible(true);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    public ItemStack getWailaStack(IWailaDataAccessor data, IWailaConfigHandler cfg) {
        ItemStack cover;
        if (cfg.getConfig(hideLandmine) && data.getTileEntity() != null && Utilities.compareByClass(classBlockLandmine, data.getBlock().getClass()) && data.getNBTData() != null && (cover = Utilities.getInventoryStacks(data.getNBTData(), 4)[3]) != null) {
            return cover;
        }
        return data.getStack();
    }

    public List<String> getWailaHead(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        if (data.getBlock() != null && data.getTileEntity() != null) {
            if (Utilities.compareTileEntityByClass(data.getTileEntity(), classDryingRackLogic)) {
                double percent;
                ItemStack item;
                if (cfg.getConfig(showDryerItem) && (item = Utilities.getInventoryStacks(data.getNBTData(), 1)[0]) != null) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.item") + ": " + item.func_82833_r());
                }
                if (cfg.getConfig(showDryerTime) && (percent = Utilities.round(Utilities.getProgression(data.getNBTData().func_74762_e("Time"), data.getNBTData().func_74762_e("MaxTime")), 2)) > 0.0 && !(percent > 100.0)) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.tinkers.dryness") + ": " + percent + "%");
                }
            }
            if (Utilities.compareTileEntityByClass(data.getTileEntity(), classFurnaceLogic)) {
                int burnTime;
                if (cfg.getConfig(showBurnTime) && (burnTime = data.getNBTData().func_74762_e("Fuel") / 20) > 0 && cfg.getConfig("wawla.furnace.burntime")) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.burnTime") + ": " + burnTime + " " + StatCollector.func_74838_a((String)"tooltip.wawla.seconds"));
                }
                if (cfg.getConfig(showFurnaceItem) && data.getPlayer().func_70093_af()) {
                    ItemStack[] furnaceStacks = Utilities.getInventoryStacks(data.getNBTData(), 3);
                    if (furnaceStacks[0] != null && cfg.getConfig("wawla.furnace.input")) {
                        tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.input") + ": " + furnaceStacks[0].func_82833_r() + " X " + furnaceStacks[0].field_77994_a);
                    }
                    if (furnaceStacks[1] != null && cfg.getConfig("wawla.furnace.fuel")) {
                        tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.fuel") + ": " + furnaceStacks[1].func_82833_r() + " X " + furnaceStacks[1].field_77994_a);
                    }
                    if (furnaceStacks[2] != null && cfg.getConfig("wawla.furnace.output")) {
                        tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.output") + ": " + furnaceStacks[2].func_82833_r() + " X " + furnaceStacks[2].field_77994_a);
                    }
                }
            }
        }
        return tip;
    }

    public List<String> getWailaTail(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te != null) {
            te.func_145841_b(tag);
        }
        return tag;
    }

    public static void registerAddon(IWailaRegistrar register) {
        AddonTinkersTiles dataProvider = new AddonTinkersTiles();
        register.addConfig("Tinkers' Construct", hideLandmine);
        register.addConfig("Tinkers' Construct", showDryerTime);
        register.addConfig("Tinkers' Construct", showDryerItem);
        register.addConfig("Tinkers' Construct", showFurnaceItem);
        register.registerBodyProvider((IWailaDataProvider)dataProvider, classDryingRack);
        register.registerBodyProvider((IWailaDataProvider)dataProvider, classFurnaceSlab);
        register.registerNBTProvider((IWailaDataProvider)dataProvider, classDryingRack);
        register.registerNBTProvider((IWailaDataProvider)dataProvider, classBlockLandmine);
        register.registerStackProvider((IWailaDataProvider)dataProvider, classBlockLandmine);
    }

    public static boolean canHarvest(ItemStack item, String required) {
        if (isEnabled) {
            ArrayList<String> tooltypes = new ArrayList<String>();
            if (classDualHarvestTool.isInstance(item.func_77973_b())) {
                try {
                    tooltypes.add((String)getSecondHarvestType.invoke((Object)item.func_77973_b(), new Object[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (classHarvestTool.isInstance(item.func_77973_b())) {
                try {
                    tooltypes.add((String)getHarvestType.invoke((Object)item.func_77973_b(), new Object[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return tooltypes.contains(required);
        }
        return false;
    }
}

