/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import lib.enderwizards.sandstone.blocks.ICustomItemBlock;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.util.ContentHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import xreliquary.Reliquary;
import xreliquary.items.block.ItemFertileLilypad;

@ContentInit
public class BlockFertileLilypad
extends BlockFlower
implements ICustomItemBlock {
    public BlockFertileLilypad() {
        super(0);
        float var3 = 0.5f;
        float var4 = 0.015625f;
        this.func_149675_a(false);
        this.func_149676_a(0.5f - var3, 0.0f, 0.5f - var3, 0.5f + var3, var4, 0.5f + var3);
        this.func_149663_c("lilypad");
        this.func_149647_a(Reliquary.CREATIVE_TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("xreliquary".toLowerCase() + ":" + "lilypad");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.field_149761_L;
    }

    public void func_149674_a(World world, int x, int y, int z, Random par5Random) {
        this.growCropsNearby(world, x, y, z);
    }

    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        world.func_72869_a("mobSpell", (double)x + 0.5 + rand.nextGaussian() / 8.0, (double)y, (double)z + 0.5 + rand.nextGaussian() / 8.0, 0.0, 0.9, 0.5);
    }

    private int secondsBetweenGrowthTicks() {
        return Reliquary.CONFIG.getInt("lilypad", "seconds_between_growth_ticks");
    }

    private int tileRange() {
        return Reliquary.CONFIG.getInt("lilypad", "tile_range");
    }

    private int fullPotencyRange() {
        return Reliquary.CONFIG.getInt("lilypad", "full_potency_range");
    }

    public void growCropsNearby(World world, int xO, int yO, int zO) {
        for (int xD = -this.tileRange(); xD <= this.tileRange(); ++xD) {
            for (int yD = -1; yD <= this.tileRange(); ++yD) {
                for (int zD = -this.tileRange(); zD <= this.tileRange(); ++zD) {
                    int x = xO + xD;
                    int y = yO + yD;
                    int z = zO + zD;
                    double distance = Math.sqrt(Math.pow(x - xO, 2.0) + Math.pow(y - yO, 2.0) + Math.pow(z - zO, 2.0));
                    distance -= (double)this.fullPotencyRange();
                    distance = Math.min(1.0, distance);
                    double distanceCoefficient = 1.0 - distance / (double)this.tileRange();
                    Block block = world.func_147439_a(x, y, z);
                    if (!(block instanceof IPlantable) && !(block instanceof IGrowable) || block instanceof BlockFertileLilypad) continue;
                    world.func_147464_a(x, y, z, block, (int)(distanceCoefficient * (double)this.secondsBetweenGrowthTicks() * 20.0));
                    block.func_149674_a(world, x, y, z, world.field_73012_v);
                }
            }
        }
        world.func_147464_a(xO, yO, zO, world.func_147439_a(xO, yO, zO), this.secondsBetweenGrowthTicks() * 20);
    }

    public int func_149645_b() {
        return 23;
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        if (par7Entity == null || !(par7Entity instanceof EntityBoat)) {
            super.func_149743_a(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
        }
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return AxisAlignedBB.func_72330_a((double)((double)par2 + this.field_149759_B), (double)((double)par3 + this.field_149760_C), (double)((double)par4 + this.field_149754_D), (double)((double)par2 + this.field_149755_E), (double)((double)par3 + this.field_149756_F), (double)((double)par4 + this.field_149757_G));
    }

    protected boolean func_149854_a(Block block) {
        return block != null && ContentHelper.areBlocksEqual(block, Blocks.field_150355_j);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return y >= 0 && y < 256 && world.func_147439_a(x, y - 1, z).func_149688_o() == Material.field_151586_h && world.func_72805_g(x, y - 1, z) == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1));
    }

    @Override
    public Class<? extends ItemBlock> getCustomItemBlock() {
        return ItemFertileLilypad.class;
    }
}

