/*
 * Decompiled with CFR 0.152.
 */
package hats.common.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import hats.api.RenderOnEntityHelper;
import hats.common.Hats;
import hats.common.core.CommonProxy;
import hats.common.core.EventHandler;
import hats.common.core.HatHandler;
import hats.common.core.HatInfo;
import hats.common.core.TimeActiveInfo;
import hats.common.packet.PacketKingOfTheHatInfo;
import hats.common.packet.PacketPing;
import hats.common.trade.TradeInfo;
import hats.common.trade.TradeRequest;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.PacketHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TickHandlerServer {
    public WeakHashMap<EntityLivingBase, String> mobHats = new WeakHashMap();
    public HashMap<String, TreeMap<String, Integer>> playerHats = new HashMap();
    public HashMap<String, TimeActiveInfo> playerActivity = new HashMap();
    public HashMap<String, TradeRequest> playerTradeRequests = new HashMap();
    public ArrayList<TradeInfo> activeTrades = new ArrayList();

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            void var4_8;
            Iterator<Map.Entry<EntityLivingBase, String>> iterator1 = this.mobHats.entrySet().iterator();
            while (iterator1.hasNext()) {
                Map.Entry<EntityLivingBase, String> e = iterator1.next();
                if (!e.getKey().field_70128_L) continue;
                iterator1.remove();
            }
            for (Map.Entry<String, TimeActiveInfo> entry : this.playerActivity.entrySet()) {
                TimeActiveInfo info = entry.getValue();
                info.tick();
                if (info.timeLeft != 0 || !info.active) continue;
                ++info.levels;
                info.timeLeft = Hats.config.getInt("startTime");
                TreeMap<String, Integer> playerHatsList = CommonProxy.tickHandlerServer.getPlayerHatsList(entry.getKey());
                ArrayList<String> newHats = HatHandler.getAllHatNamesAsList();
                for (Map.Entry<String, Integer> e1 : playerHatsList.entrySet()) {
                    newHats.remove(e1.getKey());
                }
                EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152612_a(entry.getKey());
                if (player != null && !newHats.isEmpty()) {
                    HatHandler.unlockHat((EntityPlayer)player, HatHandler.getRandomHatFromList(newHats, (boolean)(Hats.config.getInt((String)"hatRarity") == 1 ? true : false)).hatName);
                }
                for (int i = 0; i < info.levels; ++i) {
                    info.timeLeft = (int)((float)info.timeLeft * (1.0f + (float)Hats.config.getInt("timeIncrement") / 10000.0f));
                }
            }
            Iterator<Map.Entry<String, TradeRequest>> ite = this.playerTradeRequests.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, TradeRequest> entry = ite.next();
                TradeRequest tr = entry.getValue();
                ++tr.timePending;
                if (tr.timePending < 1200) continue;
                ite.remove();
            }
            int n = this.activeTrades.size() - 1;
            while (var4_8 >= 0) {
                TradeInfo ti = this.activeTrades.get((int)var4_8);
                ti.update();
                if (ti.trade1 && ti.trade2) {
                    TreeMap<String, Integer> trader1Hats = CommonProxy.tickHandlerServer.getPlayerHatsList(ti.trader1.func_70005_c_());
                    TreeMap<String, Integer> trader2Hats = CommonProxy.tickHandlerServer.getPlayerHatsList(ti.trader2.func_70005_c_());
                    this.transferHat(trader1Hats, trader2Hats, ti.trader1Hats);
                    this.transferHat(trader2Hats, trader1Hats, ti.trader2Hats);
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry<String, Integer> e1 : trader1Hats.entrySet()) {
                        String hatName = HatHandler.getNameForHat(e1.getKey());
                        sb.append(hatName);
                        if (e1.getValue() > 1) {
                            sb.append(">" + e1.getValue());
                        }
                        sb.append(":");
                    }
                    NBTTagCompound persistentTag = ti.trader1.getEntityData().func_74775_l("PlayerPersisted");
                    persistentTag.func_74778_a("Hats_unlocked", sb.toString().length() > 0 ? sb.toString().substring(0, sb.toString().length() - 1) : sb.toString());
                    ti.trader1.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistentTag);
                    StringBuilder sb1 = new StringBuilder();
                    for (Map.Entry<String, Integer> e1 : trader2Hats.entrySet()) {
                        String hatName = HatHandler.getNameForHat(e1.getKey());
                        sb1.append(hatName);
                        if (e1.getValue() > 1) {
                            sb1.append(">" + e1.getValue());
                        }
                        sb1.append(":");
                    }
                    persistentTag = ti.trader2.getEntityData().func_74775_l("PlayerPersisted");
                    persistentTag.func_74778_a("Hats_unlocked", sb1.toString().length() > 0 ? sb1.toString().substring(0, sb1.toString().length() - 1) : sb1.toString());
                    ti.trader2.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistentTag);
                    EventHandler.sendPlayerSessionInfo(ti.trader1);
                    EventHandler.sendPlayerSessionInfo(ti.trader2);
                    this.removeItems(ti.trader1, ti.trader1Items);
                    this.removeItems(ti.trader2, ti.trader2Items);
                    for (ItemStack is : ti.trader2Items) {
                        if (ti.trader1.field_71071_by.func_70441_a(is)) continue;
                        ti.trader1.func_71019_a(is, false);
                    }
                    for (ItemStack is : ti.trader1Items) {
                        if (ti.trader2.field_71071_by.func_70441_a(is)) continue;
                        ti.trader2.func_71019_a(is, false);
                    }
                    PacketHandler.sendToPlayer(Hats.channels, (AbstractPacket)new PacketPing(3, false), (EntityPlayer)ti.trader1);
                    PacketHandler.sendToPlayer(Hats.channels, (AbstractPacket)new PacketPing(3, false), (EntityPlayer)ti.trader2);
                    ti.terminate = true;
                    this.activeTrades.remove((int)var4_8);
                } else if (ti.terminate) {
                    this.activeTrades.remove((int)var4_8);
                }
                --var4_8;
            }
        }
    }

    public void transferHat(TreeMap<String, Integer> origin, TreeMap<String, Integer> destination, TreeMap<String, Integer> hatsList) {
        HashMap<String, Integer> temp = new HashMap<String, Integer>();
        Iterator<Map.Entry<String, Integer>> ite = origin.entrySet().iterator();
        block0: while (ite.hasNext()) {
            Map.Entry<String, Integer> e = ite.next();
            for (Map.Entry<String, Integer> entry : hatsList.entrySet()) {
                if (!e.getKey().equals(entry.getKey())) continue;
                if (e.getValue() - entry.getValue() <= 0) {
                    ite.remove();
                    continue block0;
                }
                temp.put(e.getKey(), e.getValue() - entry.getValue());
            }
        }
        for (Map.Entry entry : temp.entrySet()) {
            origin.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        temp.clear();
        Iterator<Map.Entry<String, Integer>> ite1 = hatsList.entrySet().iterator();
        block3: while (ite1.hasNext()) {
            Map.Entry<String, Integer> entry = ite1.next();
            for (Map.Entry<String, Integer> e1 : destination.entrySet()) {
                if (!entry.getKey().equals(e1.getKey())) continue;
                temp.put(e1.getKey(), entry.getValue() + e1.getValue());
                ite1.remove();
                continue block3;
            }
        }
        for (Map.Entry entry : temp.entrySet()) {
            destination.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        temp.clear();
        for (Map.Entry<String, Integer> entry : hatsList.entrySet()) {
            destination.put(entry.getKey(), entry.getValue());
        }
    }

    public void removeItems(EntityPlayer origin, ArrayList<ItemStack> itemsList) {
        ItemStack is1;
        ArrayList<ItemStack> itemsListCopy = new ArrayList<ItemStack>();
        for (ItemStack is : itemsList) {
            itemsListCopy.add(is.func_77946_l());
        }
        for (int i = origin.field_71071_by.field_70462_a.length - 1; i >= 0; --i) {
            ItemStack is;
            is = origin.field_71071_by.field_70462_a[i];
            if (is == null) continue;
            for (int j = itemsListCopy.size() - 1; j >= 0; --j) {
                is1 = (ItemStack)itemsListCopy.get(j);
                if (!is1.func_77969_a(is) || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)is1)) continue;
                while (is.field_77994_a > 0 && is1.field_77994_a > 0) {
                    --is.field_77994_a;
                    --is1.field_77994_a;
                }
                if (is1.field_77994_a > 0) continue;
                itemsListCopy.remove(j);
            }
            if (is.field_77994_a <= 0) {
                origin.field_71071_by.field_70462_a[i] = null;
            }
            origin.field_71071_by.func_70296_d();
        }
        for (ItemStack is : itemsListCopy) {
            for (int i = itemsList.size() - 1; i >= 0; --i) {
                is1 = itemsList.get(i);
                if (!is1.func_77969_a(is) || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)is1)) continue;
                while (is.field_77994_a > 0 && is1.field_77994_a > 0) {
                    --is.field_77994_a;
                    --is1.field_77994_a;
                }
                if (is1.field_77994_a > 0) continue;
                itemsList.remove(i);
            }
        }
    }

    public void playerKilledEntity(EntityLivingBase living, EntityPlayer player) {
        String hat = this.mobHats.get(living);
        RenderOnEntityHelper helper = HatHandler.getRenderHelper(living.getClass());
        if ((helper == null || helper.canUnlockHat(living)) && hat != null) {
            HatHandler.unlockHat(player, hat);
        }
        this.mobHats.remove(living);
    }

    public void playerDeath(EntityPlayer player) {
        NBTTagCompound persistentTag = player.getEntityData().func_74775_l("PlayerPersisted");
        persistentTag.func_74778_a("Hats_unlocked", "");
        player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistentTag);
        CommonProxy.playerWornHats.put(player.func_70005_c_(), new HatInfo());
        PacketHandler.sendToPlayer(Hats.channels, (AbstractPacket)new PacketPing(1, false), (EntityPlayer)player);
        Hats.proxy.sendPlayerListOfWornHats(player, false, false);
    }

    public void updateNewKing(String newKing, EntityPlayer player, boolean send) {
        if (!Hats.config.getSessionString("currentKing").equalsIgnoreCase("") && !Hats.config.getSessionString("currentKing").equalsIgnoreCase(newKing)) {
            EntityPlayerMP oldKing = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152612_a(Hats.config.getSessionString("currentKing"));
            if (oldKing != null) {
                this.playerDeath((EntityPlayer)oldKing);
            }
            TreeMap<String, Integer> playerHatsList = CommonProxy.tickHandlerServer.getPlayerHatsList(Hats.config.getSessionString("currentKing"));
            CommonProxy.tickHandlerServer.playerHats.put(Hats.config.getSessionString("currentKing"), null);
            CommonProxy.tickHandlerServer.playerHats.put(newKing, playerHatsList);
        }
        Hats.config.updateSession("currentKing", (Object)newKing);
        if (send) {
            if (player != null) {
                if (player.func_70005_c_().equalsIgnoreCase(Hats.config.getSessionString("currentKing"))) {
                    StringBuilder sb = new StringBuilder();
                    TreeMap<String, Integer> hats = CommonProxy.tickHandlerServer.playerHats.get(newKing);
                    if (hats != null) {
                        for (Map.Entry<String, Integer> e : hats.entrySet()) {
                            sb.append(e.getKey());
                            if (e.getValue() != 1) {
                                sb.append(">" + e.getValue());
                            }
                            sb.append(":");
                        }
                    }
                    PacketHandler.sendToPlayer(Hats.channels, (AbstractPacket)new PacketKingOfTheHatInfo(Hats.config.getSessionString("currentKing"), sb.toString().length() > 0 ? sb.toString().substring(0, sb.toString().length() - 1) : sb.toString()), (EntityPlayer)player);
                } else {
                    PacketHandler.sendToPlayer(Hats.channels, (AbstractPacket)new PacketKingOfTheHatInfo(Hats.config.getSessionString("currentKing"), ""), (EntityPlayer)player);
                }
            } else {
                PacketHandler.sendToAll(Hats.channels, (AbstractPacket)new PacketKingOfTheHatInfo(Hats.config.getSessionString("currentKing"), ""));
            }
        }
    }

    public void initializeTrade(EntityPlayerMP player, EntityPlayerMP plyr) {
        if (player == null || plyr == null) {
            return;
        }
        this.activeTrades.add(new TradeInfo((EntityPlayer)player, (EntityPlayer)plyr).initialize());
    }

    public TreeMap<String, Integer> getPlayerHatsList(String player) {
        TreeMap<String, Integer> playerHatsList = CommonProxy.tickHandlerServer.playerHats.get(player);
        if (playerHatsList == null) {
            playerHatsList = new TreeMap();
            CommonProxy.tickHandlerServer.playerHats.put(player, playerHatsList);
        }
        return playerHatsList;
    }
}

