/*
 * Decompiled with CFR 0.152.
 */
package tterrag.core.common.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraftforge.oredict.OreDictionary;

public class JsonUtils {
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static Object parseStringIntoRecipeItem(String string) {
        return JsonUtils.parseStringIntoRecipeItem(string, false);
    }

    public static Object parseStringIntoRecipeItem(String string, boolean forceItemStack) {
        if ("null".equals(string)) {
            return null;
        }
        if (OreDictionary.getOres((String)string).isEmpty()) {
            ItemStack stack = null;
            String[] info = string.split(";");
            Object temp = null;
            int damage = Short.MAX_VALUE;
            temp = Item.field_150901_e.func_82594_a(info[0]);
            if (info.length > 1) {
                damage = Integer.parseInt(info[1]);
            }
            if (temp instanceof Item) {
                stack = new ItemStack((Item)temp, 1, damage);
            } else if (temp instanceof Block) {
                stack = new ItemStack((Block)temp, 1, damage);
            } else if (temp instanceof ItemStack) {
                stack = ((ItemStack)temp).func_77946_l();
                stack.func_77964_b(damage);
            } else {
                throw new IllegalArgumentException(string + " is not a vaild string. Strings should be either an oredict name, or in the format objectname;damage (damage is optional)");
            }
            return stack;
        }
        if (forceItemStack) {
            return ((ItemStack)OreDictionary.getOres((String)string).get(0)).func_77946_l();
        }
        return string;
    }

    public static ItemStack parseStringIntoItemStack(String string) {
        int size = 1;
        int idx = string.indexOf(35);
        if (idx != -1) {
            String num = string.substring(idx + 1);
            try {
                size = Integer.parseInt(num);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(num + " is not a valid stack size");
            }
            string = string.substring(0, idx);
        }
        ItemStack stack = (ItemStack)JsonUtils.parseStringIntoRecipeItem(string, true);
        stack.field_77994_a = MathHelper.func_76125_a((int)size, (int)1, (int)stack.func_77976_d());
        return stack;
    }

    public static String getStringForItemStack(ItemStack stack, boolean damage, boolean size) {
        if (stack == null) {
            return null;
        }
        String base = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b());
        if (damage) {
            base = base + ";" + stack.func_77960_j();
        }
        if (size) {
            base = base + "#" + stack.field_77994_a;
        }
        return base;
    }
}

