/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater.shared;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class Position {
    public double x;
    public double y;
    public double z;
    public ForgeDirection orientation;

    public Position(double ci, double cj, double ck) {
        this.x = ci;
        this.y = cj;
        this.z = ck;
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public Position(double ci, double cj, double ck, ForgeDirection corientation) {
        this.x = ci;
        this.y = cj;
        this.z = ck;
        this.orientation = corientation;
    }

    public Position(Position p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
        this.orientation = p.orientation;
    }

    public Position(NBTTagCompound nbttagcompound) {
        this.x = nbttagcompound.func_74769_h("i");
        this.y = nbttagcompound.func_74769_h("j");
        this.z = nbttagcompound.func_74769_h("k");
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public Position(TileEntity tile) {
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
    }

    public void moveRight(double step) {
        switch (this.orientation) {
            case SOUTH: {
                this.x -= step;
                break;
            }
            case NORTH: {
                this.x += step;
                break;
            }
            case EAST: {
                this.z += step;
                break;
            }
            case WEST: {
                this.z -= step;
                break;
            }
        }
    }

    public void moveLeft(double step) {
        this.moveRight(-step);
    }

    public void moveForwards(double step) {
        switch (this.orientation) {
            case UP: {
                this.y += step;
                break;
            }
            case DOWN: {
                this.y -= step;
                break;
            }
            case SOUTH: {
                this.z += step;
                break;
            }
            case NORTH: {
                this.z -= step;
                break;
            }
            case EAST: {
                this.x += step;
                break;
            }
            case WEST: {
                this.x -= step;
                break;
            }
        }
    }

    public void moveBackwards(double step) {
        this.moveForwards(-step);
    }

    public void moveUp(double step) {
        switch (this.orientation) {
            case SOUTH: 
            case NORTH: 
            case EAST: 
            case WEST: {
                this.y += step;
                break;
            }
        }
    }

    public void moveDown(double step) {
        this.moveUp(-step);
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74780_a("i", this.x);
        nbttagcompound.func_74780_a("j", this.y);
        nbttagcompound.func_74780_a("k", this.z);
    }

    public String toString() {
        return "{" + this.x + ", " + this.y + ", " + this.z + "}";
    }

    public Position min(Position p) {
        return new Position(p.x > this.x ? this.x : p.x, p.y > this.y ? this.y : p.y, p.z > this.z ? this.z : p.z);
    }

    public Position max(Position p) {
        return new Position(p.x < this.x ? this.x : p.x, p.y < this.y ? this.y : p.y, p.z < this.z ? this.z : p.z);
    }
}

