/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.spawner;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.PoweredTask;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.spawner.BlockPoweredSpawner;
import crazypants.enderio.machine.spawner.DummyRecipe;
import crazypants.enderio.machine.spawner.PoweredSpawnerConfig;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.ICapacitor;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TilePoweredSpawner
extends AbstractPoweredTaskEntity {
    public static final int MIN_SPAWN_DELAY_BASE = Config.poweredSpawnerMinDelayTicks;
    public static final int MAX_SPAWN_DELAY_BASE = Config.poweredSpawnerMaxDelayTicks;
    public static final int POWER_PER_TICK_ONE = Config.poweredSpawnerLevelOnePowerPerTickRF;
    private static final BasicCapacitor CAP_ONE = new BasicCapacitor((int)((double)POWER_PER_TICK_ONE * 1.25), Capacitors.BASIC_CAPACITOR.capacitor.getMaxEnergyStored());
    public static final int POWER_PER_TICK_TWO = Config.poweredSpawnerLevelTwoPowerPerTickRF;
    private static final BasicCapacitor CAP_TWO = new BasicCapacitor((int)((double)POWER_PER_TICK_TWO * 1.25), Capacitors.ACTIVATED_CAPACITOR.capacitor.getMaxEnergyStored());
    public static final int POWER_PER_TICK_THREE = Config.poweredSpawnerLevelThreePowerPerTickRF;
    private static final BasicCapacitor CAP_THREE = new BasicCapacitor((int)((double)POWER_PER_TICK_THREE * 1.25), Capacitors.ENDER_CAPACITOR.capacitor.getMaxEnergyStored());
    public static final int MIN_PLAYER_DISTANCE = Config.poweredSpawnerMaxPlayerDistance;
    public static final boolean USE_VANILLA_SPAWN_CHECKS = Config.poweredSpawnerUseVanillaSpawChecks;
    private final SpawnerLogic logic = new SpawnerLogic();
    private static final String NULL_ENTITY_NAME = "None";
    private ICapacitor capacitor;
    private boolean isSpawnMode = true;

    public TilePoweredSpawner() {
        super(new SlotDefinition(1, 1, 1));
        this.logic.func_98272_a(NULL_ENTITY_NAME);
        this.capacitor = CAP_ONE;
    }

    public boolean isSpawnMode() {
        return this.isSpawnMode;
    }

    public void setSpawnMode(boolean isSpawnMode) {
        if (isSpawnMode != this.isSpawnMode) {
            this.currentTask = null;
        }
        this.isSpawnMode = isSpawnMode;
    }

    @Override
    protected void taskComplete() {
        super.taskComplete();
        if (this.isSpawnMode) {
            this.logic.field_98286_b = 0;
        } else {
            if (this.func_70301_a(0) == null || this.func_70301_a(1) != null) {
                return;
            }
            String name = this.logic.func_98276_e();
            if (name == NULL_ENTITY_NAME) {
                return;
            }
            ItemStack res = EnderIO.itemSoulVessel.createVesselWithEntityStub(this.logic.func_98276_e());
            this.func_70298_a(0, 1);
            this.func_70299_a(1, res);
        }
    }

    @Override
    public void setCapacitor(Capacitors capacitorType) {
        BasicCapacitor refCap;
        this.capacitorType = capacitorType;
        switch (capacitorType) {
            case BASIC_CAPACITOR: {
                refCap = CAP_ONE;
                break;
            }
            case ACTIVATED_CAPACITOR: {
                refCap = CAP_TWO;
                break;
            }
            case ENDER_CAPACITOR: {
                refCap = CAP_THREE;
                break;
            }
            default: {
                refCap = CAP_ONE;
            }
        }
        double multuplier = PoweredSpawnerConfig.getInstance().getCostMultiplierFor(this.logic.func_98276_e());
        this.capacitor = new BasicCapacitor((int)((double)refCap.getMaxEnergyExtracted() * multuplier), refCap.getMaxEnergyStored());
        this.forceClientUpdate = true;
        this.setEnergyStored(this.getEnergyStored());
    }

    @Override
    public ICapacitor getCapacitor() {
        return this.capacitor;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockPoweredSpawner.unlocalisedName;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (itemstack == null || this.isSpawnMode) {
            return false;
        }
        if (this.slotDefinition.isInputSlot(i)) {
            return itemstack.func_77973_b() == EnderIO.itemSoulVessel && !EnderIO.itemSoulVessel.containsSoul(itemstack);
        }
        return false;
    }

    @Override
    protected IMachineRecipe canStartNextTask(float chance) {
        if (this.isSpawnMode ? this.logic.func_98276_e() == null || this.logic.func_98276_e().equals(NULL_ENTITY_NAME) : this.func_70301_a(0) == null || this.func_70301_a(1) != null) {
            return null;
        }
        return new DummyRecipe();
    }

    @Override
    protected boolean startNextTask(IMachineRecipe nextRecipe, float chance) {
        return super.startNextTask(nextRecipe, chance);
    }

    @Override
    public int getPowerUsePerTick() {
        double multuplier = PoweredSpawnerConfig.getInstance().getCostMultiplierFor(this.logic.func_98276_e());
        if (this.capacitorType.ordinal() == 0) {
            return (int)Math.round((double)POWER_PER_TICK_ONE * multuplier);
        }
        if (this.capacitorType.ordinal() == 1) {
            return (int)Math.round((double)POWER_PER_TICK_TWO * multuplier);
        }
        return (int)Math.round((double)POWER_PER_TICK_THREE * multuplier);
    }

    @Override
    protected boolean hasInputStacks() {
        return true;
    }

    @Override
    protected boolean canInsertResult(float chance, IMachineRecipe nextRecipe) {
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        this.logic.func_98270_a(nbtRoot);
        super.readCustomNBT(nbtRoot);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        this.logic.func_98280_b(nbtRoot);
        super.writeCustomNBT(nbtRoot);
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        String mobType = BlockPoweredSpawner.readMobTypeFromNBT(nbtRoot);
        if (mobType == null) {
            mobType = NULL_ENTITY_NAME;
        }
        this.logic.func_98272_a(mobType);
        this.logic.func_98273_j();
        this.isSpawnMode = !nbtRoot.func_74764_b("isSpawnMode") ? true : nbtRoot.func_74767_n("isSpawnMode");
        super.readCommon(nbtRoot);
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        String mobType = this.logic.func_98276_e();
        if (mobType == null || mobType.equals(NULL_ENTITY_NAME)) {
            BlockPoweredSpawner.writeMobTypeToNBT(nbtRoot, null);
        } else {
            BlockPoweredSpawner.writeMobTypeToNBT(nbtRoot, mobType);
        }
        nbtRoot.func_74757_a("isSpawnMode", this.isSpawnMode);
        super.writeCommon(nbtRoot);
    }

    @Override
    public void func_145845_h() {
        this.logic.func_98278_g();
        super.func_145845_h();
    }

    public boolean func_145842_c(int p_145842_1_, int p_145842_2_) {
        return this.logic.func_98268_b(p_145842_1_) ? true : super.func_145842_c(p_145842_1_, p_145842_2_);
    }

    @Override
    protected IPoweredTask createTask(IMachineRecipe nextRecipe, float chance) {
        PoweredTask res = new PoweredTask(nextRecipe, chance, this.getRecipeInputs());
        int ticksDelay = this.isSpawnMode ? MIN_SPAWN_DELAY_BASE + (int)Math.round((double)(MAX_SPAWN_DELAY_BASE - MIN_SPAWN_DELAY_BASE) * Math.random()) : MAX_SPAWN_DELAY_BASE - (MAX_SPAWN_DELAY_BASE - MIN_SPAWN_DELAY_BASE) / 2;
        if (this.capacitorType.ordinal() == 1) {
            ticksDelay /= 2;
        } else if (this.capacitorType.ordinal() == 2) {
            ticksDelay /= 4;
        }
        int powerPerTick = this.getPowerUsePerTick();
        res.setRequiredEnergy(powerPerTick * ticksDelay);
        return res;
    }

    protected boolean canSpawnEntity(EntityLiving entityliving) {
        boolean spaceClear;
        boolean bl = spaceClear = this.field_145850_b.func_72855_b(entityliving.field_70121_D) && this.field_145850_b.func_72945_a((Entity)entityliving, entityliving.field_70121_D).isEmpty() && !this.field_145850_b.func_72953_d(entityliving.field_70121_D);
        if (spaceClear && USE_VANILLA_SPAWN_CHECKS) {
            spaceClear = entityliving.func_70601_bi();
        }
        return spaceClear;
    }

    public String getEntityName() {
        return this.logic.func_98276_e();
    }

    class SpawnerLogic
    extends MobSpawnerBaseLogic {
        private int spawnCount = 4;
        private int maxNearbyEntities = 6;
        private int spawnRange = 4;

        SpawnerLogic() {
        }

        public void func_98267_a(int par1) {
            TilePoweredSpawner.this.field_145850_b.func_147452_c(TilePoweredSpawner.this.field_145851_c, TilePoweredSpawner.this.field_145848_d, TilePoweredSpawner.this.field_145849_e, (Block)EnderIO.blockPoweredSpawner, par1, 0);
        }

        public World func_98271_a() {
            return TilePoweredSpawner.this.field_145850_b;
        }

        public int func_98275_b() {
            return TilePoweredSpawner.this.field_145851_c;
        }

        public int func_98274_c() {
            return TilePoweredSpawner.this.field_145848_d;
        }

        public int func_98266_d() {
            return TilePoweredSpawner.this.field_145849_e;
        }

        public void func_98277_a(MobSpawnerBaseLogic.WeightedRandomMinecart par1WeightedRandomMinecart) {
            super.func_98277_a(par1WeightedRandomMinecart);
            if (this.func_98271_a() != null) {
                this.func_98271_a().func_147471_g(TilePoweredSpawner.this.field_145851_c, TilePoweredSpawner.this.field_145848_d, TilePoweredSpawner.this.field_145849_e);
            }
        }

        public boolean func_98279_f() {
            if (MIN_PLAYER_DISTANCE > 0) {
                boolean playerInRange;
                boolean bl = playerInRange = TilePoweredSpawner.this.field_145850_b.func_72977_a((double)this.func_98275_b() + 0.5, (double)this.func_98274_c() + 0.5, (double)this.func_98266_d() + 0.5, (double)MIN_PLAYER_DISTANCE) != null;
                if (!playerInRange) {
                    return false;
                }
            }
            return TilePoweredSpawner.this.isActive();
        }

        public void func_98278_g() {
            if (this.func_98279_f()) {
                if (this.func_98271_a().field_72995_K) {
                    double d0 = (float)this.func_98275_b() + this.func_98271_a().field_73012_v.nextFloat();
                    double d1 = (float)this.func_98274_c() + this.func_98271_a().field_73012_v.nextFloat();
                    double d2 = (float)this.func_98266_d() + this.func_98271_a().field_73012_v.nextFloat();
                    this.func_98271_a().func_72869_a("smoke", d0, d1, d2, 0.0, 0.0, 0.0);
                    this.func_98271_a().func_72869_a("flame", d0, d1, d2, 0.0, 0.0, 0.0);
                    this.field_98284_d = this.field_98287_c;
                    this.field_98287_c = (this.field_98287_c + (double)(1000.0f / ((float)this.field_98286_b + 200.0f))) % 360.0;
                } else {
                    if (this.field_98286_b > 0) {
                        return;
                    }
                    this.func_98273_j();
                    for (int i = 0; i < this.spawnCount; ++i) {
                        Entity entity = this.createEntity(true);
                        if (entity == null) {
                            return;
                        }
                        int j = this.func_98271_a().func_72872_a(entity.getClass(), AxisAlignedBB.func_72330_a((double)this.func_98275_b(), (double)this.func_98274_c(), (double)this.func_98266_d(), (double)(this.func_98275_b() + 1), (double)(this.func_98274_c() + 1), (double)(this.func_98266_d() + 1)).func_72314_b((double)(this.spawnRange * 2), 4.0, (double)(this.spawnRange * 2))).size();
                        if (j >= this.maxNearbyEntities) {
                            this.func_98273_j();
                            return;
                        }
                        double d2 = (double)this.func_98275_b() + (this.func_98271_a().field_73012_v.nextDouble() - this.func_98271_a().field_73012_v.nextDouble()) * (double)this.spawnRange;
                        double d3 = this.func_98274_c() + this.func_98271_a().field_73012_v.nextInt(3) - 1;
                        double d4 = (double)this.func_98266_d() + (this.func_98271_a().field_73012_v.nextDouble() - this.func_98271_a().field_73012_v.nextDouble()) * (double)this.spawnRange;
                        EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                        entity.func_70012_b(d2, d3, d4, this.func_98271_a().field_73012_v.nextFloat() * 360.0f, 0.0f);
                        if (entityliving == null || !TilePoweredSpawner.this.canSpawnEntity(entityliving)) continue;
                        this.func_98265_a(entity);
                        this.func_98271_a().func_72926_e(2004, this.func_98275_b(), this.func_98274_c(), this.func_98266_d(), 0);
                        if (entityliving == null) continue;
                        entityliving.func_70656_aK();
                    }
                }
            }
        }

        Entity createEntity(boolean forceAlive) {
            Entity ent = EntityList.func_75620_a((String)this.func_98276_e(), (World)this.func_98271_a());
            if (forceAlive && MIN_PLAYER_DISTANCE <= 0 && ent instanceof EntityLiving) {
                ent.getEntityData().func_74772_a("spawnedByPoweredSpawner", this.func_98271_a().func_82737_E());
                ((EntityLiving)ent).func_110163_bv();
            }
            return ent;
        }

        void func_98273_j() {
            this.field_98286_b = Integer.MAX_VALUE;
        }
    }
}

