/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.facade;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.config.Config;
import crazypants.enderio.gui.IAdvancedTooltipProvider;
import crazypants.enderio.gui.IResourceTooltipProvider;
import crazypants.enderio.gui.TooltipAddera;
import crazypants.enderio.machine.painter.BasicPainterTemplate;
import crazypants.enderio.machine.painter.IPaintedBlock;
import crazypants.enderio.machine.painter.PaintSourceValidator;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.util.Lang;
import crazypants.util.Util;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemConduitFacade
extends Item
implements IAdvancedTooltipProvider,
IResourceTooltipProvider {
    private IIcon[] icons;
    protected IIcon overlayIcon;

    public static ItemConduitFacade create() {
        ItemConduitFacade result = new ItemConduitFacade();
        result.init();
        return result;
    }

    protected ItemConduitFacade() {
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77625_d(64);
        this.func_77627_a(true);
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)ModObject.itemConduitFacade.unlocalisedName);
    }

    public void func_150895_a(Item item, CreativeTabs p_150895_2_, List list) {
        for (FacadeType t : FacadeType.values()) {
            list.add(new ItemStack(item, 1, t.ordinal()));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return FacadeType.values()[stack.func_77960_j()].getUnlocName(this);
    }

    public String func_77658_a() {
        return "item.enderio." + ModObject.itemConduitFacade.name();
    }

    public void func_94581_a(IIconRegister IIconRegister2) {
        this.icons = new IIcon[FacadeType.values().length];
        this.icons[0] = this.field_77791_bV = IIconRegister2.func_94245_a("enderio:conduitFacade");
        this.icons[1] = IIconRegister2.func_94245_a("enderio:conduitFacadeHardened");
        this.overlayIcon = IIconRegister2.func_94245_a("enderio:conduitFacadeOverlay");
    }

    public IIcon getOverlayIcon() {
        return this.overlayIcon;
    }

    public IIcon func_77617_a(int damage) {
        return this.icons[damage % this.icons.length];
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        return this.func_77617_a(stack.func_77960_j());
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (world.field_72995_K) {
            return true;
        }
        ForgeDirection dir = ForgeDirection.values()[side];
        int placeX = x + dir.offsetX;
        int placeY = y + dir.offsetY;
        int placeZ = z + dir.offsetZ;
        if (player.func_82247_a(placeX, placeY, placeZ, side, itemStack) && world.func_147437_c(placeX, placeY, placeZ) && PainterUtil.getSourceBlock(itemStack) != null) {
            world.func_147449_b(placeX, placeY, placeZ, (Block)EnderIO.blockConduitBundle);
            IConduitBundle bundle = (IConduitBundle)world.func_147438_o(placeX, placeY, placeZ);
            bundle.setFacadeId(PainterUtil.getSourceBlock(itemStack));
            bundle.setFacadeMetadata(PainterUtil.getSourceBlockMetadata(itemStack));
            bundle.setFacadeType(FacadeType.values()[itemStack.func_77960_j()]);
            if (!player.field_71075_bZ.field_75098_d) {
                --itemStack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public ItemStack createItemStackForSourceBlock(Block id, int itemDamage) {
        if (id == null) {
            id = EnderIO.blockConduitFacade;
        }
        ItemStack result = new ItemStack(id, 1, 0);
        PainterUtil.setSourceBlock(result, id, itemDamage);
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        super.func_77624_a(item, par2EntityPlayer, list, par4);
    }

    @Override
    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_77658_a();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        if (PainterUtil.getSourceBlock(itemstack) == null) {
            list.add(Lang.localize("item.itemConduitFacade.tooltip.notpainted"));
        } else {
            list.add(PainterUtil.getTooltTipText(itemstack));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        TooltipAddera.addDetailedTooltipFromResources(list, itemstack);
        if (itemstack.func_77960_j() == FacadeType.HARDENED.ordinal()) {
            list.add("");
            list.add(Lang.localize(this.func_77667_c(itemstack) + ".tooltip", false));
        }
    }

    public final class FacadePainterRecipe
    extends BasicPainterTemplate {
        public FacadePainterRecipe() {
            super(new Block[0]);
        }

        @Override
        public boolean isValidPaintSource(ItemStack paintSource) {
            if (paintSource == null) {
                return false;
            }
            Block block = Util.getBlockFromItemId(paintSource);
            if (block == null || block instanceof IPaintedBlock) {
                return false;
            }
            if (PaintSourceValidator.instance.isBlacklisted(paintSource)) {
                return false;
            }
            if (PaintSourceValidator.instance.isWhitelisted(paintSource)) {
                return true;
            }
            if (!Config.allowTileEntitiesAsPaintSource && block instanceof ITileEntityProvider) {
                return false;
            }
            if (block == EnderIO.blockFusedQuartz && paintSource.func_77960_j() < 2) {
                return true;
            }
            return block.func_149645_b() == 0 || block.func_149662_c() || block.func_149721_r();
        }

        @Override
        public boolean isValidTarget(ItemStack target) {
            return target != null && target.func_77973_b() == ItemConduitFacade.this;
        }
    }

    public static enum FacadeType {
        BASIC,
        HARDENED;


        public String getUnlocName(Item me) {
            return this == BASIC ? me.func_77658_a() : me.func_77658_a() + ".hardened";
        }
    }
}

