/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import appeng.api.networking.IGridNode;
import appeng.api.util.AECableType;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.facade.ItemConduitFacade;
import crazypants.enderio.conduit.gas.IGasConduit;
import crazypants.enderio.conduit.geom.CollidableCache;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitConnectorType;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.geom.Offset;
import crazypants.enderio.conduit.geom.Offsets;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.me.IMEConduit;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.config.Config;
import crazypants.render.BoundingBox;
import crazypants.util.BlockCoord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TileConduitBundle
extends TileEntityEio
implements IConduitBundle {
    public static final short NBT_VERSION = 1;
    private final List<IConduit> conduits = new ArrayList<IConduit>();
    private Block facadeId = null;
    private int facadeMeta = 0;
    private ItemConduitFacade.FacadeType facadeType = ItemConduitFacade.FacadeType.BASIC;
    private boolean facadeChanged;
    private final List<CollidableComponent> cachedCollidables = new ArrayList<CollidableComponent>();
    private final List<CollidableComponent> cachedConnectors = new ArrayList<CollidableComponent>();
    private boolean conduitsDirty = true;
    private boolean collidablesDirty = true;
    private boolean connectorsDirty = true;
    private boolean clientUpdated = false;
    private int lightOpacity = -1;
    @SideOnly(value=Side.CLIENT)
    private IConduitBundle.FacadeRenderState facadeRenderAs;
    private ConduitDisplayMode lastMode = ConduitDisplayMode.ALL;
    private Object node;

    public TileConduitBundle() {
        this.field_145854_h = EnderIO.blockConduitBundle;
    }

    @Override
    public void dirty() {
        this.conduitsDirty = true;
        this.collidablesDirty = true;
    }

    public boolean shouldRenderInPass(int arg0) {
        if (this.facadeId != null && !ConduitUtil.isFacadeHidden(this, EnderIO.proxy.getClientPlayer())) {
            return false;
        }
        return super.shouldRenderInPass(arg0);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        NBTTagList conduitTags = new NBTTagList();
        for (IConduit conduit : this.conduits) {
            NBTTagCompound conduitRoot = new NBTTagCompound();
            ConduitUtil.writeToNBT(conduit, conduitRoot);
            conduitTags.func_74742_a((NBTBase)conduitRoot);
        }
        nbtRoot.func_74782_a("conduits", (NBTBase)conduitTags);
        if (this.facadeId != null) {
            nbtRoot.func_74778_a("facadeId", Block.field_149771_c.func_148750_c((Object)this.facadeId));
            nbtRoot.func_74778_a("facadeType", this.facadeType.name());
        } else {
            nbtRoot.func_74778_a("facadeId", "null");
        }
        nbtRoot.func_74768_a("facadeMeta", this.facadeMeta);
        nbtRoot.func_74777_a("nbtVersion", (short)1);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        String fs;
        short nbtVersion = nbtRoot.func_74765_d("nbtVersion");
        this.conduits.clear();
        NBTTagList conduitTags = (NBTTagList)nbtRoot.func_74781_a("conduits");
        if (conduitTags != null) {
            for (int i = 0; i < conduitTags.func_74745_c(); ++i) {
                NBTTagCompound conduitTag = conduitTags.func_150305_b(i);
                IConduit conduit = ConduitUtil.readConduitFromNBT(conduitTag, nbtVersion);
                if (conduit == null) continue;
                conduit.setBundle(this);
                this.conduits.add(conduit);
            }
        }
        if ((fs = nbtRoot.func_74779_i("facadeId")) == null || "null".equals(fs)) {
            this.facadeId = null;
            this.facadeType = ItemConduitFacade.FacadeType.BASIC;
        } else {
            this.facadeId = Block.func_149684_b((String)fs);
            if (nbtRoot.func_74764_b("facadeType")) {
                this.facadeType = ItemConduitFacade.FacadeType.valueOf(nbtRoot.func_74779_i("facadeType"));
            }
        }
        this.facadeMeta = nbtRoot.func_74762_e("facadeMeta");
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.clientUpdated = true;
        }
    }

    @Override
    public boolean hasFacade() {
        return this.facadeId != null;
    }

    @Override
    public void setFacadeId(Block blockID, boolean triggerUpdate) {
        this.facadeId = blockID;
        if (triggerUpdate) {
            this.facadeChanged = true;
        }
    }

    @Override
    public void setFacadeId(Block blockID) {
        this.setFacadeId(blockID, true);
    }

    @Override
    public Block getFacadeId() {
        return this.facadeId;
    }

    @Override
    public void setFacadeMetadata(int meta) {
        this.facadeMeta = meta;
    }

    @Override
    public void setFacadeType(ItemConduitFacade.FacadeType type) {
        this.facadeType = type;
    }

    @Override
    public int getFacadeMetadata() {
        return this.facadeMeta;
    }

    @Override
    public ItemConduitFacade.FacadeType getFacadeType() {
        return this.facadeType;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IConduitBundle.FacadeRenderState getFacadeRenderedAs() {
        if (this.facadeRenderAs == null) {
            this.facadeRenderAs = IConduitBundle.FacadeRenderState.NONE;
        }
        return this.facadeRenderAs;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setFacadeRenderAs(IConduitBundle.FacadeRenderState state) {
        this.facadeRenderAs = state;
    }

    @Override
    public int getLightOpacity() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K || this.lightOpacity == -1) {
            return this.hasFacade() ? this.facadeId.func_149717_k() : 0;
        }
        return this.lightOpacity;
    }

    @Override
    public void setLightOpacity(int opacity) {
        this.lightOpacity = opacity;
    }

    public void onChunkUnload() {
        for (IConduit conduit : this.conduits) {
            conduit.onChunkUnload(this.field_145850_b);
        }
    }

    public void func_145845_h() {
        if (this.field_145850_b == null) {
            return;
        }
        for (IConduit conduit : this.conduits) {
            conduit.updateEntity(this.field_145850_b);
        }
        if (this.conduitsDirty) {
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.func_70296_d();
            }
            this.conduitsDirty = false;
        }
        if (this.facadeChanged) {
            ConduitUtil.forceSkylightRecalculation(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.facadeChanged = false;
        }
        if (this.field_145850_b.field_72995_K) {
            boolean markForUpdate = false;
            if (this.clientUpdated) {
                markForUpdate = true;
                this.clientUpdated = false;
            }
            IConduitBundle.FacadeRenderState curRS = this.getFacadeRenderedAs();
            IConduitBundle.FacadeRenderState rs = ConduitUtil.getRequiredFacadeRenderState(this, EnderIO.proxy.getClientPlayer());
            if (Config.updateLightingWhenHidingFacades) {
                int shouldBeLO;
                int curLO = this.getLightOpacity();
                int n = shouldBeLO = rs == IConduitBundle.FacadeRenderState.FULL ? 255 : 0;
                if (curLO != shouldBeLO) {
                    this.setLightOpacity(shouldBeLO);
                    this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            if (curRS != rs) {
                this.setFacadeRenderAs(rs);
                if (!ConduitUtil.forceSkylightRecalculation(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                    markForUpdate = true;
                }
            } else {
                ConduitDisplayMode curMode = ConduitDisplayMode.getDisplayMode(EnderIO.proxy.getClientPlayer().func_71045_bC());
                if (curMode != this.lastMode) {
                    markForUpdate = true;
                    this.lastMode = curMode;
                }
            }
            if (markForUpdate) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    @Override
    public BlockCoord getLocation() {
        return new BlockCoord(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void onNeighborBlockChange(Block blockId) {
        boolean needsUpdate = false;
        for (IConduit conduit : this.conduits) {
            needsUpdate |= conduit.onNeighborBlockChange(blockId);
        }
        if (needsUpdate) {
            this.dirty();
        }
    }

    @Override
    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        boolean needsUpdate = false;
        for (IConduit conduit : this.conduits) {
            needsUpdate |= conduit.onNeighborChange(world, x, y, z, tileX, tileY, tileZ);
        }
        if (needsUpdate) {
            this.dirty();
        }
    }

    @Override
    public TileConduitBundle getEntity() {
        return this;
    }

    @Override
    public boolean hasType(Class<? extends IConduit> type) {
        return this.getConduit(type) != null;
    }

    @Override
    public <T extends IConduit> T getConduit(Class<T> type) {
        if (type == null) {
            return null;
        }
        for (IConduit conduit : this.conduits) {
            if (!type.isInstance(conduit)) continue;
            return (T)conduit;
        }
        return null;
    }

    @Override
    public void addConduit(IConduit conduit) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.conduits.add(conduit);
        conduit.setBundle(this);
        conduit.onAddedToBundle();
        this.dirty();
    }

    @Override
    public void removeConduit(IConduit conduit) {
        if (conduit != null) {
            this.removeConduit(conduit, true);
        }
    }

    public void removeConduit(IConduit conduit, boolean notify) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        conduit.onRemovedFromBundle();
        this.conduits.remove(conduit);
        conduit.setBundle(null);
        if (notify) {
            this.dirty();
        }
    }

    @Override
    public void onBlockRemoved() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ArrayList<IConduit> copy = new ArrayList<IConduit>(this.conduits);
        for (IConduit con : copy) {
            this.removeConduit(con, false);
        }
        this.dirty();
    }

    @Override
    public Collection<IConduit> getConduits() {
        return this.conduits;
    }

    @Override
    public Set<ForgeDirection> getConnections(Class<? extends IConduit> type) {
        IConduit con = this.getConduit(type);
        if (con != null) {
            return con.getConduitConnections();
        }
        return null;
    }

    @Override
    public boolean containsConnection(Class<? extends IConduit> type, ForgeDirection dir) {
        IConduit con = this.getConduit(type);
        if (con != null) {
            return con.containsConduitConnection(dir);
        }
        return false;
    }

    @Override
    public boolean containsConnection(ForgeDirection dir) {
        for (IConduit con : this.conduits) {
            if (!con.containsConduitConnection(dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<ForgeDirection> getAllConnections() {
        HashSet<ForgeDirection> result = new HashSet<ForgeDirection>();
        for (IConduit con : this.conduits) {
            result.addAll(con.getConduitConnections());
        }
        return result;
    }

    @Override
    public Offset getOffset(Class<? extends IConduit> type, ForgeDirection dir) {
        if (this.getConnectionCount(dir) < 2) {
            return Offset.NONE;
        }
        return Offsets.get(type, dir);
    }

    @Override
    public List<CollidableComponent> getCollidableComponents() {
        for (IConduit con : this.conduits) {
            this.collidablesDirty = this.collidablesDirty || con.haveCollidablesChangedSinceLastCall();
        }
        if (this.collidablesDirty) {
            this.connectorsDirty = true;
        }
        if (!this.collidablesDirty && !this.cachedCollidables.isEmpty()) {
            return this.cachedCollidables;
        }
        this.cachedCollidables.clear();
        for (IConduit conduit : this.conduits) {
            this.cachedCollidables.addAll(conduit.getCollidableComponents());
        }
        this.addConnectors(this.cachedCollidables);
        this.collidablesDirty = false;
        return this.cachedCollidables;
    }

    @Override
    public List<CollidableComponent> getConnectors() {
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        this.addConnectors(result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void addConnectors(List<CollidableComponent> result) {
        CollidableComponent cc;
        if (this.conduits.isEmpty()) {
            return;
        }
        for (IConduit con : this.conduits) {
            boolean b = con.haveCollidablesChangedSinceLastCall();
            this.collidablesDirty = this.collidablesDirty || b;
            this.connectorsDirty = this.connectorsDirty || b;
        }
        if (!this.connectorsDirty && !this.cachedConnectors.isEmpty()) {
            result.addAll(this.cachedConnectors);
            return;
        }
        this.cachedConnectors.clear();
        ArrayList<CollidableComponent> coreBounds = new ArrayList<CollidableComponent>();
        for (IConduit con : this.conduits) {
            this.addConduitCores(coreBounds, con);
        }
        this.cachedConnectors.addAll(coreBounds);
        result.addAll(coreBounds);
        ArrayList<CollidableComponent> conduitsBounds = new ArrayList<CollidableComponent>();
        for (IConduit con : this.conduits) {
            conduitsBounds.addAll(con.getCollidableComponents());
            this.addConduitCores(conduitsBounds, con);
        }
        HashSet<Class<? extends IConduit>> collidingTypes = new HashSet<Class<? extends IConduit>>();
        for (CollidableComponent conCC : conduitsBounds) {
            for (CollidableComponent collidableComponent : conduitsBounds) {
                if ("ColorController".equals(collidableComponent.data) || "ColorController".equals(conCC.data) || conCC == collidableComponent || !conCC.bound.intersects(collidableComponent.bound)) continue;
                collidingTypes.add(conCC.conduitType);
            }
        }
        if (!collidingTypes.isEmpty()) {
            ArrayList<CollidableComponent> colCores = new ArrayList<CollidableComponent>();
            for (Class clazz : collidingTypes) {
                Object t = this.getConduit(clazz);
                if (t == null) continue;
                this.addConduitCores((List<CollidableComponent>)colCores, (IConduit)t);
            }
            BoundingBox bb = null;
            for (CollidableComponent collidableComponent : colCores) {
                if (bb == null) {
                    bb = collidableComponent.bound;
                    continue;
                }
                bb = bb.expandBy(collidableComponent.bound);
            }
            if (bb != null) {
                bb = bb.scale(1.05, 1.05, 1.05);
                CollidableComponent collidableComponent = new CollidableComponent(null, bb, ForgeDirection.UNKNOWN, (Object)ConduitConnectorType.INTERNAL);
                result.add(collidableComponent);
                this.cachedConnectors.add(collidableComponent);
            }
        }
        for (IConduit con : this.conduits) {
            void var8_31;
            if (!con.hasConnections()) continue;
            ArrayList<CollidableComponent> arrayList = new ArrayList<CollidableComponent>();
            this.addConduitCores(arrayList, con);
            if (arrayList.size() <= 1) continue;
            BoundingBox boundingBox = ((CollidableComponent)arrayList.get((int)0)).bound;
            float area = boundingBox.getArea();
            for (CollidableComponent cc3 : arrayList) {
                BoundingBox boundingBox2 = var8_31.expandBy(cc3.bound);
            }
            if (!(var8_31.getArea() > area * 1.5f)) continue;
            BoundingBox boundingBox3 = var8_31.scale(1.05, 1.05, 1.05);
            cc = new CollidableComponent(null, boundingBox3, ForgeDirection.UNKNOWN, (Object)ConduitConnectorType.INTERNAL);
            result.add(cc);
            this.cachedConnectors.add(cc);
        }
        BoundingBox conBB = null;
        for (int i = 0; i < result.size(); ++i) {
            CollidableComponent collidableComponent = result.get(i);
            if (collidableComponent.conduitType != null || collidableComponent.data != ConduitConnectorType.INTERNAL) continue;
            conBB = conBB == null ? collidableComponent.bound : conBB.expandBy(collidableComponent.bound);
            result.remove(i);
            --i;
            this.cachedConnectors.remove(collidableComponent);
        }
        if (conBB != null) {
            CollidableComponent cc4 = new CollidableComponent(null, conBB, ForgeDirection.UNKNOWN, (Object)ConduitConnectorType.INTERNAL);
            result.add(cc4);
            this.cachedConnectors.add(cc4);
        }
        HashSet<ForgeDirection> externalDirs = new HashSet<ForgeDirection>();
        for (IConduit iConduit : this.conduits) {
            Set<ForgeDirection> extCons = iConduit.getExternalConnections();
            if (extCons == null) continue;
            for (ForgeDirection dir : extCons) {
                if (iConduit.getConnectionMode(dir) == ConnectionMode.DISABLED) continue;
                externalDirs.add(dir);
            }
        }
        for (ForgeDirection forgeDirection : externalDirs) {
            BoundingBox bb = ConduitGeometryUtil.instance.getExternalConnectorBoundingBox(forgeDirection);
            cc = new CollidableComponent(null, bb, forgeDirection, (Object)ConduitConnectorType.EXTERNAL);
            result.add(cc);
            this.cachedConnectors.add(cc);
        }
        this.connectorsDirty = false;
    }

    private boolean axisOfConnectionsEqual(Set<ForgeDirection> cons) {
        Offsets.Axis axis = null;
        for (ForgeDirection dir : cons) {
            if (axis == null) {
                axis = Offsets.getAxisForDir(dir);
                continue;
            }
            if (axis == Offsets.getAxisForDir(dir)) continue;
            return false;
        }
        return true;
    }

    private void addConduitCores(List<CollidableComponent> result, IConduit con) {
        CollidableCache cc = CollidableCache.instance;
        Class<? extends IConduit> type = con.getCollidableType();
        if (con.hasConnections()) {
            for (ForgeDirection dir : con.getExternalConnections()) {
                result.addAll(cc.getCollidables(cc.createKey(type, this.getOffset(con.getBaseConduitType(), dir), ForgeDirection.UNKNOWN, false), con));
            }
            for (ForgeDirection dir : con.getConduitConnections()) {
                result.addAll(cc.getCollidables(cc.createKey(type, this.getOffset(con.getBaseConduitType(), dir), ForgeDirection.UNKNOWN, false), con));
            }
        } else {
            result.addAll(cc.getCollidables(cc.createKey(type, this.getOffset(con.getBaseConduitType(), ForgeDirection.UNKNOWN), ForgeDirection.UNKNOWN, false), con));
        }
    }

    private int getConnectionCount(ForgeDirection dir) {
        if (dir == ForgeDirection.UNKNOWN) {
            return this.conduits.size();
        }
        int result = 0;
        for (IConduit con : this.conduits) {
            if (!con.containsConduitConnection(dir) && !con.containsExternalConnection(dir)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.receiveEnergy(from, maxReceive, simulate);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.extractEnergy(from, maxExtract, simulate);
        }
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.canConnectEnergy(from);
        }
        return false;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.getEnergyStored(from);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.getMaxEnergyStored(from);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyRecieved(ForgeDirection dir) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.getMaxEnergyRecieved(dir);
        }
        return 0;
    }

    @Override
    public int getEnergyStored() {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.getEnergyStored();
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored() {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.getMaxEnergyStored();
        }
        return 0;
    }

    @Override
    public void setEnergyStored(int stored) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            pc.setEnergyStored(stored);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.fill(from, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.drain(from, resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.drain(from, maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.canFill(from, fluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.canDrain(from, fluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.getTankInfo(from);
        }
        return null;
    }

    @Override
    public ItemStack insertItem(ForgeDirection from, ItemStack item) {
        IItemConduit ic = this.getConduit(IItemConduit.class);
        if (ic != null) {
            return ic.insertItem(from, item);
        }
        return item;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        IGasConduit gc = this.getConduit(IGasConduit.class);
        if (gc != null) {
            return gc.receiveGas(side, stack);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        IGasConduit gc = this.getConduit(IGasConduit.class);
        if (gc != null) {
            return gc.drawGas(side, amount);
        }
        return null;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        IGasConduit gc = this.getConduit(IGasConduit.class);
        if (gc != null) {
            return gc.canReceiveGas(side, type);
        }
        return false;
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        IGasConduit gc = this.getConduit(IGasConduit.class);
        if (gc != null) {
            return gc.canDrawGas(side, type);
        }
        return false;
    }

    @Override
    public World getWorld() {
        return this.func_145831_w();
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(ForgeDirection dir) {
        if (dir == null || dir == ForgeDirection.UNKNOWN) {
            return (IGridNode)this.node;
        }
        IMEConduit cond = this.getConduit(IMEConduit.class);
        if (cond != null) {
            if (cond.getConnectionMode(dir.getOpposite()) == ConnectionMode.IN_OUT) {
                return (IGridNode)this.node;
            }
            return null;
        }
        return (IGridNode)this.node;
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void setGridNode(Object node) {
        this.node = (IGridNode)node;
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(ForgeDirection dir) {
        IMEConduit cond = this.getConduit(IMEConduit.class);
        if (cond == null) {
            return AECableType.NONE;
        }
        return cond.isConnectedTo(dir) ? AECableType.SMART : AECableType.NONE;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
    }

    @Override
    public boolean displayPower() {
        return true;
    }
}

