/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.common.block.BlockFlag;
import openmods.api.IActivateAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.api.ISurfaceAttachment;
import openmods.sync.SyncableByte;
import openmods.sync.SyncableFloat;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;
import openmods.utils.ColorUtils;

public class TileEntityFlag
extends SyncedTileEntity
implements ISurfaceAttachment,
IPlaceAwareTile,
IActivateAwareTile {
    private SyncableFloat angle;
    private SyncableByte colorIndex;

    protected void createSyncedFields() {
        this.angle = new SyncableFloat();
        this.colorIndex = new SyncableByte();
    }

    protected void initialize() {
    }

    public IIcon getIcon() {
        return OpenBlocks.Blocks.flag.func_149691_a(0, 0);
    }

    public void setColorIndex(byte index) {
        this.colorIndex.set(index);
    }

    public void setAngle(float ang) {
        this.angle.set(ang);
    }

    public ColorUtils.RGB getColor() {
        return BlockFlag.COLORS[this.colorIndex.get() & 0xF];
    }

    public ForgeDirection getSurfaceDirection() {
        return this.getRotation();
    }

    public float getAngle() {
        return this.angle.get();
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player != null && player.func_70093_af()) {
            return true;
        }
        if (!this.field_145850_b.field_72995_K && this.getSurfaceDirection() == ForgeDirection.DOWN) {
            this.angle.set(this.angle.get() + 10.0f);
            this.sync();
            return false;
        }
        return true;
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        float ang = player.field_70759_as;
        ForgeDirection rotation = this.getRotation();
        if (rotation != ForgeDirection.DOWN) {
            ang = -BlockUtils.getRotationFromDirection((ForgeDirection)side.getOpposite());
        }
        this.setAngle(ang);
        this.setColorIndex((byte)(stack.func_77960_j() & 0xF));
    }

    @SideOnly(value=Side.CLIENT)
    public void prepareForInventoryRender(Block block, int metadata) {
        super.prepareForInventoryRender(block, metadata);
        this.setColorIndex((byte)metadata);
    }
}

