/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import openblocks.OpenBlocks;
import openblocks.client.renderer.entity.EntitySelectionHandler;
import openblocks.common.MapDataBuilder;
import openblocks.common.entity.EntityAssistant;
import openblocks.common.item.ItemCartographer;
import openblocks.common.item.ItemEmptyMap;
import openblocks.common.item.ItemHeightMap;
import openmods.Log;
import openmods.sync.ISyncMapProvider;
import openmods.sync.SyncMap;
import openmods.sync.SyncMapEntity;
import openmods.sync.SyncObjectScanner;
import openmods.sync.SyncableBoolean;
import openmods.sync.SyncableInt;
import openmods.sync.SyncableObjectBase;
import openmods.utils.BitSet;
import openmods.utils.ByteUtils;
import openmods.utils.ItemUtils;

public class EntityCartographer
extends EntityAssistant
implements EntitySelectionHandler.ISelectAware,
ISyncMapProvider {
    private static final int MAP_JOB_DELAY = 5;
    private static final int MOVE_DELAY = 35;
    public static final Random RANDOM = new Random();
    @SideOnly(value=Side.CLIENT)
    public float eyeYaw;
    @SideOnly(value=Side.CLIENT)
    public float eyePitch;
    @SideOnly(value=Side.CLIENT)
    public float targetYaw;
    @SideOnly(value=Side.CLIENT)
    public float targetPitch;
    public final SyncableInt scale = new SyncableInt(2);
    public final SyncableBoolean isMapping = new SyncableBoolean(false);
    public final MapJobs jobs = new MapJobs();
    private ItemStack mapItem;
    private int mappingDimension;
    private int countdownToAction = 5;
    private int countdownToMove = 35;
    private float randomDelta;
    private final SyncMapEntity<EntityCartographer> syncMap = new SyncMapEntity((Entity)this);

    public EntityCartographer(World world) {
        super(world, null);
        SyncObjectScanner.INSTANCE.registerAllFields(this.syncMap, (Object)this);
        this.func_70105_a(0.2f, 0.2f);
    }

    public EntityCartographer(World world, EntityPlayer owner, ItemStack stack) {
        super(world, owner);
        SyncObjectScanner.INSTANCE.registerAllFields(this.syncMap, (Object)this);
        this.func_70105_a(0.2f, 0.2f);
        this.setSpawnPosition((Entity)owner);
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        this.readOwnDataFromNBT(tag);
    }

    protected void func_70088_a() {
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            float yaw = 0.0f;
            if (this.isMapping.get()) {
                if (this.countdownToMove-- <= 0) {
                    this.countdownToMove = 35;
                    this.randomDelta = (float)Math.PI * 2 * RANDOM.nextFloat();
                }
                yaw = this.randomDelta;
            } else {
                EntityPlayer owner = this.findOwner();
                if (owner != null) {
                    yaw = (float)Math.toRadians(owner.field_70177_z);
                }
            }
            this.ownerOffsetX = MathHelper.func_76126_a((float)(-yaw));
            this.ownerOffsetZ = MathHelper.func_76134_b((float)(-yaw));
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.field_73011_w.field_76574_g == this.mappingDimension && this.isMapping.get() && this.countdownToAction-- <= 0) {
                this.jobs.runJob(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70161_v);
                this.countdownToAction = 5;
            }
            this.syncMap.sync();
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.readOwnDataFromNBT(tag);
    }

    private void readOwnDataFromNBT(NBTTagCompound tag) {
        this.syncMap.readFromNBT(tag);
        if (tag.func_74764_b("MapItem")) {
            NBTTagCompound mapItem = tag.func_74775_l("MapItem");
            this.mapItem = ItemStack.func_77949_a((NBTTagCompound)mapItem);
            if (this.isMapping.get()) {
                int mapId = this.mapItem.func_77960_j();
                this.jobs.resumeMapping(this.field_70170_p, mapId);
            }
            this.mappingDimension = tag.func_74762_e("Dimension");
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        this.writeOwnDataToNBT(tag);
    }

    private void writeOwnDataToNBT(NBTTagCompound tag) {
        this.syncMap.writeToNBT(tag);
        if (this.mapItem != null) {
            NBTTagCompound mapItem = new NBTTagCompound();
            this.mapItem.func_77955_b(mapItem);
            tag.func_74782_a("MapItem", (NBTBase)mapItem);
            tag.func_74768_a("Dimension", this.mappingDimension);
        }
    }

    @Override
    public ItemStack toItemStack() {
        ItemStack result = OpenBlocks.Items.cartographer.createStack(ItemCartographer.AssistantType.CARTOGRAPHER);
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)result);
        this.writeOwnDataToNBT(tag);
        return result;
    }

    @Override
    public boolean func_130002_c(EntityPlayer player) {
        if (player instanceof EntityPlayerMP && player.func_70093_af() && this.func_70032_d((Entity)player) < 3.0f) {
            Item itemType;
            ItemStack holding = player.func_70694_bm();
            if (holding == null && this.mapItem != null) {
                player.func_70062_b(0, this.mapItem);
                this.mapItem = null;
                this.isMapping.toggle();
                this.jobs.stopMapping();
            } else if (holding != null && this.mapItem == null && ((itemType = holding.func_77973_b()) instanceof ItemHeightMap || itemType instanceof ItemEmptyMap)) {
                ItemStack inserted = holding.func_77979_a(1);
                if (holding.field_77994_a <= 0) {
                    player.func_70062_b(0, null);
                }
                this.mapItem = inserted;
                this.mappingDimension = this.field_70170_p.field_73011_w.field_76574_g;
                this.isMapping.toggle();
                this.mapItem = MapDataBuilder.upgradeToMap(this.field_70170_p, this.mapItem);
                int mapId = this.mapItem.func_77960_j();
                this.jobs.startMapping(this.field_70170_p, mapId, this.getNewMapCenterX(), this.getNewMapCenterZ());
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    public SyncMap<EntityCartographer> getSyncMap() {
        return this.syncMap;
    }

    public int getNewMapCenterX() {
        return (int)this.field_70165_t & 0xFFFFFFF0;
    }

    public int getNewMapCenterZ() {
        return (int)this.field_70161_v & 0xFFFFFFF0;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateEye() {
        float diffYaw = (this.targetYaw - this.eyeYaw) % (float)Math.PI;
        float diffPitch = (this.targetPitch - this.eyePitch) % (float)Math.PI;
        if ((double)(Math.abs(diffYaw) + Math.abs(diffPitch)) < 1.0E-4) {
            this.targetPitch = RANDOM.nextFloat() * 2.0f * (float)Math.PI;
            this.targetYaw = RANDOM.nextFloat() * 2.0f * (float)Math.PI;
        } else {
            this.eyeYaw -= diffYaw / 50.0f;
            this.eyePitch -= diffPitch / 50.0f;
        }
    }

    public static class MapJobs
    extends SyncableObjectBase {
        private BitSet bits = new BitSet();
        private Set<MapDataBuilder.ChunkJob> jobs;
        private int size;

        public boolean test(int bit) {
            return this.bits.testBit(bit);
        }

        public void readFromStream(DataInputStream input) throws IOException {
            this.size = ByteUtils.readVLI((DataInput)input);
            this.bits.readFromStream((DataInput)input);
        }

        public void writeToStream(DataOutputStream output) throws IOException {
            ByteUtils.writeVLI((DataOutput)output, (int)this.size);
            this.bits.writeToStream((DataOutput)output);
        }

        public void writeToNBT(NBTTagCompound tag, String name) {
            NBTTagCompound result = new NBTTagCompound();
            this.bits.writeToNBT(result);
            tag.func_74782_a(name, (NBTBase)result);
        }

        public void readFromNBT(NBTTagCompound tag, String name) {
            NBTTagCompound info = tag.func_74775_l(name);
            this.bits.readFromNBT(info);
        }

        public void runJob(World world, int x, int z) {
            MapDataBuilder.ChunkJob job;
            if (this.jobs == null) {
                Log.severe((String)"STOP ABUSING CARTOGRAPHER RIGHT NOW! YOU BROKE IT!", (Object[])new Object[0]);
                this.jobs = ImmutableSet.of();
            }
            if ((job = MapDataBuilder.doNextChunk(world, x, z, this.jobs)) != null) {
                this.jobs.remove(job);
                this.bits.setBit(job.bitNum);
                this.markDirty();
            }
        }

        public void resumeMapping(World world, int mapId) {
            MapDataBuilder builder = new MapDataBuilder(mapId);
            builder.loadMap(world);
            builder.resizeIfNeeded(this.bits);
            this.size = builder.size();
            this.jobs = builder.createJobs(this.bits);
            this.markDirty();
        }

        public void startMapping(World world, int mapId, int x, int z) {
            MapDataBuilder builder = new MapDataBuilder(mapId);
            builder.resetMap(world, x, z);
            builder.resize(this.bits);
            this.size = builder.size();
            this.jobs = builder.createJobs(this.bits);
            this.markDirty();
        }

        public void stopMapping() {
            this.jobs.clear();
            this.bits.resize(0);
            this.size = 0;
            this.markDirty();
        }

        public int size() {
            return this.size;
        }
    }
}

