/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.guicomponents;

import com.brandon3055.draconicevolution.client.gui.guicomponents.ComponentBase;
import com.brandon3055.draconicevolution.client.gui.guicomponents.GUIBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class ComponentCollection
extends ComponentBase {
    protected List<ComponentBase> components = new ArrayList<ComponentBase>();
    protected int xSize;
    protected int ySize;
    protected List<String> deadGroups = new ArrayList<String>();
    protected GUIBase gui;

    public ComponentCollection(int x, int y, int xSize, int ySize, GUIBase gui) {
        super(x, y);
        this.xSize = xSize;
        this.ySize = ySize;
        this.gui = gui;
    }

    @Override
    public int getWidth() {
        return this.xSize;
    }

    @Override
    public int getHeight() {
        return this.ySize;
    }

    public ComponentBase addComponent(ComponentBase component) {
        this.components.add(component);
        component.setWorldAndResolution(Minecraft.func_71410_x(), this.width, this.height);
        return component;
    }

    private boolean isComponentEnabled(ComponentBase component) {
        return component != null && component.isEnabled();
    }

    private boolean isComponentCapturingMouse(ComponentBase component, int mouseX, int mouseY) {
        return this.isComponentEnabled(component) && component.isMouseOver(mouseX, mouseY);
    }

    @Override
    public final void renderBackground(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        for (ComponentBase component : this.components) {
            if (!this.isComponentEnabled(component)) continue;
            component.renderBackground(minecraft, offsetX + this.x, offsetY + this.y, mouseX - this.x, mouseY - this.y);
        }
    }

    @Override
    public final void renderForground(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        for (ComponentBase component : this.components) {
            if (!this.isComponentEnabled(component)) continue;
            component.renderForground(minecraft, offsetX + this.x, offsetY + this.y, mouseX - this.x, mouseY - this.y);
        }
    }

    @Override
    public final void renderFinal(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        for (ComponentBase component : this.components) {
            if (!this.isComponentEnabled(component)) continue;
            component.renderFinal(minecraft, offsetX + this.x, offsetY + this.y, mouseX - this.x, mouseY - this.y);
        }
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        for (ComponentBase component : this.components) {
            if (this.gui.buttonPressed || !component.isEnabled() || !component.isMouseOver(x, y)) continue;
            component.mouseClicked(x, y, button);
        }
    }

    public List<ComponentBase> getComponents() {
        return this.components;
    }

    public ComponentBase getComponent(String name) {
        for (ComponentBase component : this.components) {
            if (component.name == null || !component.name.equals(name)) continue;
            return component;
        }
        return null;
    }

    public void setGroupEnabled(String group, boolean enabled) {
        for (ComponentBase component : this.components) {
            if (!component.getGroup().equals(group)) continue;
            component.setEnabled(enabled);
        }
    }

    public void setOnlyGroupEnabled(String group) {
        for (ComponentBase component : this.components) {
            if (component.getGroup().equals(group)) {
                component.setEnabled(this.enabled);
                continue;
            }
            component.setEnabled(false);
        }
    }

    public void setComponentEnabled(String name, boolean enabled) {
        for (ComponentBase component : this.components) {
            if (component.name == null || !component.name.equals(name)) continue;
            component.setEnabled(enabled);
        }
    }

    public void removeGroup(String group) {
        ArrayList<ComponentBase> list = new ArrayList<ComponentBase>();
        for (ComponentBase component : this.components) {
            if (!component.getGroup().equals(group)) continue;
            list.add(component);
        }
        this.components.removeAll(list);
    }

    @Override
    public void setWorldAndResolution(Minecraft mc, int width, int height) {
        super.setWorldAndResolution(mc, width, height);
        for (ComponentBase component : this.components) {
            component.setWorldAndResolution(mc, width, height);
        }
    }

    public void removeScheduled() {
        if (!this.deadGroups.isEmpty()) {
            for (String s : this.deadGroups) {
                this.removeGroup(s);
            }
            this.deadGroups.clear();
        }
    }

    public void schedulRemoval(String group) {
        this.deadGroups.add(group);
    }

    @Override
    public void updateScreen() {
        for (ComponentBase component : this.components) {
            component.updateScreen();
        }
    }
}

