/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.conduit.IExtractor;
import crazypants.enderio.conduit.packet.AbstractConduitPacket;
import crazypants.enderio.conduit.packet.ConTypeEnum;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.util.DyeColor;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketExtractMode
extends AbstractConduitPacket<IExtractor>
implements IMessageHandler<PacketExtractMode, IMessage> {
    private ForgeDirection dir;
    private RedstoneControlMode mode;
    private DyeColor color;

    public PacketExtractMode() {
    }

    public PacketExtractMode(IExtractor con, ForgeDirection dir) {
        super(con.getBundle().getEntity(), ConTypeEnum.get(con));
        this.dir = dir;
        this.mode = con.getExtractionRedstoneMode(dir);
        this.color = con.getExtractionSignalColor(dir);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort(this.dir.ordinal());
        buf.writeShort(this.mode.ordinal());
        buf.writeShort(this.color.ordinal());
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.dir = ForgeDirection.values()[buf.readShort()];
        this.mode = RedstoneControlMode.values()[buf.readShort()];
        this.color = DyeColor.values()[buf.readShort()];
    }

    public IMessage onMessage(PacketExtractMode message, MessageContext ctx) {
        ((IExtractor)message.getTileCasted(ctx)).setExtractionRedstoneMode(message.mode, message.dir);
        ((IExtractor)message.getTileCasted(ctx)).setExtractionSignalColor(message.dir, message.color);
        message.getWorld(ctx).func_147471_g(message.x, message.y, message.z);
        return null;
    }
}

