/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.util;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import mantle.crash.CallableSuppConfig;
import mantle.crash.CallableUnsuppConfig;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.TConstruct;

public class EnvironmentChecks {
    private static List<String> incompatibilities = new ArrayList<String>();
    private static EnvironmentChecks instance = new EnvironmentChecks();

    private EnvironmentChecks() {
    }

    public static void verifyEnvironmentSanity() {
        ArrayList<String> modIds = new ArrayList<String>();
        if (Loader.isModLoaded((String)"gregtech")) {
            TConstruct.logger.error("Tinkers' Construct and GregTech are incompatible for the following reasons:");
            TConstruct.logger.error(EnvironmentChecks.modCompatDetails("GregTech", true));
            modIds.add("gregtech");
            incompatibilities.add("GregTech");
        }
        if (modIds.size() == 0) {
            CallableSuppConfig callable = new CallableSuppConfig("TConstruct");
            FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)callable);
        } else {
            CallableUnsuppConfig callable = new CallableUnsuppConfig("TConstruct", modIds);
            FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)callable);
        }
        if (incompatibilities.size() > 0 && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }
    }

    public static String modCompatDetails(String type, boolean consoleFormat) {
        String n;
        String string = n = consoleFormat ? System.getProperty("line.separator") : "\n";
        if (type.equals("GregTech")) {
            return "- GregTech is a meta-mod that changes how a lot of mods interact with the base game and with each other." + n + "- The mod restructures the registration of various ores within the Ore Dictionary. This may alter or break the original design intention of various other mods." + n + "- This mod alters various fundamental recipes from vanilla Minecraft.";
        }
        return "";
    }
}

