/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.weaponry.AmmoItem;
import tconstruct.library.weaponry.IAmmo;
import tconstruct.weaponry.weapons.Shuriken;

public class ModAmmoRestock
extends ItemModifier {
    public ModAmmoRestock() {
        super(new ItemStack[0], 0, "");
    }

    @Override
    public boolean matches(ItemStack[] input, ItemStack tool) {
        return this.canModify(tool, input);
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        if (!(tool.func_77973_b() instanceof AmmoItem)) {
            return false;
        }
        IAmmo ammo = (IAmmo)tool.func_77973_b();
        if (ammo.getAmmoCount(tool) >= ammo.getMaxAmmo(tool)) {
            return false;
        }
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        HashSet<Integer> materials = new HashSet<Integer>();
        materials.add(tags.func_74762_e("Head"));
        if (tool.func_77973_b() instanceof Shuriken) {
            materials.add(tags.func_74762_e("Handle"));
            materials.add(tags.func_74762_e("Accessory"));
            materials.add(tags.func_74762_e("Extra"));
        }
        boolean areInputsValid = true;
        for (ItemStack curInput : input) {
            if (curInput == null || materials.contains(PatternBuilder.instance.getPartID(curInput))) continue;
            areInputsValid = false;
            break;
        }
        return areInputsValid;
    }

    private int calculateIncrease(ItemStack tool, int materialValue, int itemsUsed) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        float dur = (float)tags.func_74762_e("BaseDurability") * ((AmmoItem)tool.func_77973_b()).getAmmoModifier();
        float increase = (float)(5 * itemsUsed) + dur * 0.4f * (float)materialValue / 2.0f;
        int modifiers = tags.func_74762_e("Modifiers");
        float mods = 1.0f;
        if (modifiers == 2) {
            mods = 0.9f;
        } else if (modifiers == 1) {
            mods = 0.8f;
        } else if (modifiers == 0) {
            mods = 0.7f;
        }
        increase *= mods;
        int repair = tags.func_74762_e("RepairCount");
        float repairCount = (float)(100 - repair) / 100.0f;
        if (repairCount < 0.5f) {
            repairCount = 0.5f;
        }
        increase *= repairCount;
        return (int)(increase /= ((ToolCore)tool.func_77973_b()).getRepairCost());
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        int itemsUsed = 0;
        int materialValue = 0;
        for (ItemStack curInput : input) {
            if (curInput == null) continue;
            materialValue += PatternBuilder.instance.getPartValue(curInput);
            ++itemsUsed;
        }
        int increase = this.calculateIncrease(tool, materialValue, itemsUsed);
        int repair = tags.func_74762_e("RepairCount");
        tags.func_74768_a("RepairCount", repair += itemsUsed);
        ((IAmmo)tool.func_77973_b()).addAmmo(increase, tool);
    }

    @Override
    public void addMatchingEffect(ItemStack tool) {
    }

    @Override
    public boolean validType(IModifyable input) {
        return input.getModifyType().equals("Tool") || input.getModifyType().equals("Armor");
    }
}

