/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.minecraft;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minetweaker.MineTweakerAPI;
import minetweaker.api.block.IBlock;
import minetweaker.api.block.IBlockDefinition;
import minetweaker.api.data.IData;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IngredientUnknown;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.oredict.IOreDictEntry;
import minetweaker.api.player.IPlayer;
import minetweaker.api.world.IBiome;
import minetweaker.api.world.IDimension;
import minetweaker.mc1710.block.MCBlockDefinition;
import minetweaker.mc1710.block.MCSpecificBlock;
import minetweaker.mc1710.block.MCWorldBlock;
import minetweaker.mc1710.data.NBTConverter;
import minetweaker.mc1710.item.MCItemStack;
import minetweaker.mc1710.liquid.MCLiquidStack;
import minetweaker.mc1710.oredict.MCOreDictEntry;
import minetweaker.mc1710.player.MCPlayer;
import minetweaker.mc1710.world.MCBiome;
import minetweaker.mc1710.world.MCDimension;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class MineTweakerMC {
    private static final Map<Block, MCBlockDefinition> blockDefinitions = new HashMap<Block, MCBlockDefinition>();
    public static final IBiome[] biomes = new IBiome[BiomeGenBase.func_150565_n().length];
    private static final HashMap<List, IOreDictEntry> oreDictArrays;

    private MineTweakerMC() {
    }

    public static ItemStack getItemStack(IItemStack item) {
        if (item == null) {
            return null;
        }
        Object internal = item.getInternal();
        if (internal == null || !(internal instanceof ItemStack)) {
            MineTweakerAPI.logError("Not a valid item stack: " + item);
        }
        return (ItemStack)internal;
    }

    public static ItemStack getItemStack(IIngredient ingredient) {
        if (ingredient == null) {
            return null;
        }
        List<IItemStack> items = ingredient.getItems();
        if (items.size() != 1) {
            MineTweakerAPI.logError("Not an ingredient with a single item: " + ingredient);
        }
        return MineTweakerMC.getItemStack(items.get(0));
    }

    public static IItemStack getIItemStack(ItemStack item) {
        if (item == null) {
            return null;
        }
        return new MCItemStack(item);
    }

    public static IItemStack getIItemStackWildcardSize(ItemStack item) {
        if (item == null) {
            return null;
        }
        return new MCItemStack(item, true);
    }

    public static IItemStack getIItemStackWildcardSize(Item item, int meta) {
        if (item == null) {
            return null;
        }
        return new MCItemStack(new ItemStack(item, 1, meta), true);
    }

    public static IItemStack getIItemStackWildcard(Item item, int amount) {
        if (item == null) {
            return null;
        }
        return new MCItemStack(new ItemStack(item, 1, Short.MAX_VALUE));
    }

    public static ItemStack[] getExamples(IIngredient ingredient) {
        List<IItemStack> examples = ingredient.getItems();
        ItemStack[] result = new ItemStack[examples.size()];
        for (int i = 0; i < examples.size(); ++i) {
            result[i] = MineTweakerMC.getItemStack(examples.get(i));
        }
        return result;
    }

    public static IItemStack getItemStack(Item item, int amount, int damage) {
        if (item == null) {
            return null;
        }
        return new MCItemStack(new ItemStack(item, amount, damage));
    }

    public static ItemStack[] getItemStacks(IItemStack ... items) {
        if (items == null) {
            return null;
        }
        ItemStack[] output = new ItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            Object internal = items[i].getInternal();
            if (internal == null || !(internal instanceof ItemStack)) continue;
            output[i] = (ItemStack)internal;
        }
        return output;
    }

    public static ItemStack[] getItemStacks(List<IItemStack> items) {
        if (items == null) {
            return null;
        }
        ItemStack[] output = new ItemStack[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            Object internal = items.get(i).getInternal();
            if (internal != null && internal instanceof ItemStack) {
                output[i] = (ItemStack)internal;
                continue;
            }
            MineTweakerAPI.logError("Invalid item stack: " + items.get(i));
        }
        return output;
    }

    public static IItemStack[] getIItemStacks(ItemStack ... items) {
        if (items == null) {
            return null;
        }
        IItemStack[] result = new IItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            result[i] = new MCItemStack(items[i]);
        }
        return result;
    }

    public static IItemStack[] getIItemStacks(List<ItemStack> items) {
        if (items == null) {
            return null;
        }
        IItemStack[] result = new IItemStack[items.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new MCItemStack(items.get(i));
        }
        return result;
    }

    public static IOreDictEntry getOreDict(String name) {
        return new MCOreDictEntry(name);
    }

    public static IPlayer getIPlayer(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        return new MCPlayer(player);
    }

    public static EntityPlayer getPlayer(IPlayer player) {
        if (player == null) {
            return null;
        }
        if (!(player instanceof MCPlayer)) {
            MineTweakerAPI.logError("Invalid player: " + player);
        }
        return ((MCPlayer)player).getInternal();
    }

    public static IData getIData(NBTBase nbt) {
        if (nbt == null) {
            return null;
        }
        return NBTConverter.from(nbt, true);
    }

    public static IData getIDataModifyable(NBTBase nbt) {
        if (nbt == null) {
            return null;
        }
        return NBTConverter.from(nbt, false);
    }

    public static NBTBase getNBT(IData data) {
        if (data == null) {
            return null;
        }
        return NBTConverter.from(data);
    }

    public static NBTTagCompound getNBTCompound(IData data) {
        if (data == null) {
            return null;
        }
        return (NBTTagCompound)NBTConverter.from(data);
    }

    public static IBlock getBlock(IBlockAccess blocks, int x, int y, int z) {
        return new MCWorldBlock(blocks, x, y, z);
    }

    public static IBlockDefinition getBlockDefinition(Block block) {
        if (!blockDefinitions.containsKey(block)) {
            blockDefinitions.put(block, new MCBlockDefinition(block));
        }
        return blockDefinitions.get(block);
    }

    public static IDimension getDimension(World world) {
        if (world == null) {
            return null;
        }
        return new MCDimension(world);
    }

    public static IBlock getBlockAnyMeta(Block block) {
        return new MCSpecificBlock(block, Short.MAX_VALUE);
    }

    public static IBlock getBlock(Block block, int meta) {
        return new MCSpecificBlock(block, meta);
    }

    public static Block getBlock(IItemStack itemStack) {
        return ((MCBlockDefinition)itemStack.asBlock().getDefinition()).getInternalBlock();
    }

    public static Block getBlock(IBlock block) {
        return ((MCBlockDefinition)block.getDefinition()).getInternalBlock();
    }

    public static FluidStack getLiquidStack(ILiquidStack stack) {
        if (stack == null) {
            return null;
        }
        return (FluidStack)stack.getInternal();
    }

    public static IOreDictEntry getOreDictEntryFromArray(List array) {
        if (!oreDictArrays.containsKey(array)) {
            for (String ore : OreDictionary.getOreNames()) {
                if (OreDictionary.getOres((String)ore) != array) continue;
                oreDictArrays.put(array, MineTweakerAPI.oreDict.get(ore));
            }
        }
        return oreDictArrays.get(array);
    }

    public static IIngredient getIIngredient(Object ingredient) {
        if (ingredient == null) {
            return null;
        }
        if (ingredient instanceof String) {
            return MineTweakerAPI.oreDict.get((String)ingredient);
        }
        if (ingredient instanceof Item) {
            return MineTweakerMC.getIItemStack(new ItemStack((Item)ingredient, 1, 0));
        }
        if (ingredient instanceof ItemStack) {
            return MineTweakerMC.getIItemStack((ItemStack)ingredient);
        }
        if (ingredient instanceof List) {
            IOreDictEntry entry = MineTweakerMC.getOreDictEntryFromArray((List)ingredient);
            if (entry == null) {
                return IngredientUnknown.INSTANCE;
            }
            return entry;
        }
        if (ingredient instanceof FluidStack) {
            return new MCLiquidStack((FluidStack)ingredient);
        }
        throw new IllegalArgumentException("Not a valid ingredient: " + ingredient);
    }

    static {
        for (int i = 0; i < BiomeGenBase.func_150565_n().length; ++i) {
            if (BiomeGenBase.func_150565_n()[i] == null) continue;
            MineTweakerMC.biomes[i] = new MCBiome(BiomeGenBase.func_150565_n()[i]);
        }
        oreDictArrays = new HashMap();
    }
}

