/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.ChunkLoaderManager;
import codechicken.chunkloader.ChunkLoaderSPH;
import codechicken.chunkloader.ChunkLoaderShape;
import codechicken.chunkloader.TileChunkLoaderBase;
import codechicken.lib.packet.PacketCustom;
import java.util.HashSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class TileChunkLoader
extends TileChunkLoaderBase {
    public int radius;
    public ChunkLoaderShape shape = ChunkLoaderShape.Square;

    public static void handleDescriptionPacket(PacketCustom packet, World world) {
        TileEntity tile = world.func_147438_o(packet.readInt(), packet.readInt(), packet.readInt());
        if (tile instanceof TileChunkLoader) {
            TileChunkLoader ctile = (TileChunkLoader)tile;
            ctile.setShapeAndRadius(ChunkLoaderShape.values()[packet.readUByte()], packet.readUByte());
            ctile.active = packet.readBoolean();
            if (packet.readBoolean()) {
                ctile.owner = packet.readString();
            }
        }
    }

    public boolean setShapeAndRadius(ChunkLoaderShape newShape, int newRadius) {
        if (this.field_145850_b.field_72995_K) {
            this.radius = newRadius;
            this.shape = newShape;
            return true;
        }
        HashSet<ChunkCoordIntPair> chunks = TileChunkLoader.getContainedChunks(newShape, this.field_145851_c, this.field_145849_e, newRadius);
        if (chunks.size() > ChunkLoaderManager.maxChunksPerLoader()) {
            return false;
        }
        if (this.powered) {
            this.radius = newRadius;
            this.shape = newShape;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (ChunkLoaderManager.canLoaderAdd(this, chunks)) {
            this.radius = newRadius;
            this.shape = newShape;
            ChunkLoaderManager.updateLoader(this);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public Packet func_145844_m() {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 10);
        packet.writeCoord(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        packet.writeByte(this.shape.ordinal());
        packet.writeByte(this.radius);
        packet.writeBoolean(this.active);
        packet.writeBoolean(this.owner != null);
        if (this.owner != null) {
            packet.writeString(this.owner);
        }
        return packet.toPacket();
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("radius", (byte)this.radius);
        tag.func_74774_a("shape", (byte)this.shape.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.radius = tag.func_74771_c("radius");
        this.shape = ChunkLoaderShape.values()[tag.func_74771_c("shape")];
    }

    public HashSet<ChunkCoordIntPair> getChunks() {
        return TileChunkLoader.getContainedChunks(this.shape, this.field_145851_c, this.field_145849_e, this.radius);
    }

    public static HashSet<ChunkCoordIntPair> getContainedChunks(ChunkLoaderShape shape, int xCoord, int zCoord, int radius) {
        return shape.getLoadedChunks(xCoord >> 4, zCoord >> 4, radius - 1);
    }

    public int countLoadedChunks() {
        return ((HashSet)this.getChunks()).size();
    }

    @Override
    public void activate() {
        if (this.radius == 0) {
            this.radius = 1;
            this.shape = ChunkLoaderShape.Square;
            this.setShapeAndRadius(ChunkLoaderShape.Square, 2);
        }
        super.activate();
    }
}

