/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.utils;

import java.util.List;
import minetweaker.IUndoableAction;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class BaseListAddition
implements IUndoableAction {
    protected final List list;
    protected final Object recipe;
    protected String description;

    public BaseListAddition(String description, List list, Object recipe) {
        this(list, recipe);
        this.description = description;
    }

    public BaseListAddition(List list, Object recipe) {
        this.list = list;
        this.recipe = recipe;
    }

    public void apply() {
        this.list.add(this.recipe);
    }

    public boolean canUndo() {
        return this.list != null;
    }

    public void undo() {
        this.list.remove(this.recipe);
    }

    public String getRecipeInfo() {
        return "Unknown Item";
    }

    public String describe() {
        if (this.recipe instanceof ItemStack) {
            return "Adding " + this.description + " Recipe for :" + ((ItemStack)this.recipe).func_82833_r();
        }
        if (this.recipe instanceof FluidStack) {
            return "Adding " + this.description + " Recipe for :" + ((FluidStack)this.recipe).getFluid().getLocalizedName();
        }
        return "Adding " + this.description + " Recipe for :" + this.getRecipeInfo();
    }

    public String describeUndo() {
        if (this.recipe instanceof ItemStack) {
            return "Removing " + this.description + " Recipe for :" + ((ItemStack)this.recipe).func_82833_r();
        }
        if (this.recipe instanceof FluidStack) {
            return "Removing " + this.description + " Recipe for :" + ((FluidStack)this.recipe).getFluid().getLocalizedName();
        }
        return "Removing " + this.description + " Recipe for :" + this.getRecipeInfo();
    }

    public Object getOverrideKey() {
        return null;
    }
}

