/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import tuhljin.automagy.blocks.BlockRedcrystalMerc;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.data.RedstoneMirrorNetwork;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.tiles.TileEntityRedcrystal;

public class TileEntityRedcrystalMerc
extends TileEntityRedcrystal {
    public static final int MAX_DISTANCE = 8;
    public int mirrorX;
    public int mirrorY = -1;
    public int mirrorZ;
    public int mirrorDim;
    public int mirrorLinkedX;
    public int mirrorLinkedY = -1;
    public int mirrorLinkedZ;
    public int mirrorLinkedDim;
    public int strengthWithoutMirror;
    protected boolean mirrorValid = false;
    protected boolean mirrorStartedValid = false;
    private int ticksSinceMirrorCheck = 0;
    public static int rotationSpeedFactor = 3240;
    public static double clientRenderFloatingTop_unpowered = -0.2;
    public static double clientRenderFloatingTop_powered = 0.1;
    public static double clientRenderFloatingBtm_unpowered = -0.3;
    public static double clientRenderFloatingBtm_powered = -0.1;
    public int clientRenderRotationHelper = 0;
    public double clientRenderFloatingDistance = clientRenderFloatingTop_unpowered;
    public boolean clientRenderGoingUp = false;

    public TileEntityRedcrystalMerc() {
    }

    public TileEntityRedcrystalMerc(short orientation, boolean noConnection) {
        super(orientation, noConnection);
    }

    public boolean hasValidMirrorConnection() {
        return this.mirrorValid;
    }

    public void setMirrorLink(int dimensionID, int x, int y, int z) {
        this.mirrorX = x;
        this.mirrorY = y;
        this.mirrorZ = z;
        this.mirrorDim = dimensionID;
        this.extraData = 0;
        if (this.mirrorY == -1) {
            this.mirrorValid = false;
        } else if (this.mirrorDim == this.field_145850_b.field_73011_w.field_76574_g) {
            float distance = TjUtil.getDistanceBetweenPoints(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.mirrorX, this.mirrorY, this.mirrorZ);
            if (distance <= 8.0f) {
                TileEntity te = this.field_145850_b.func_147438_o(this.mirrorX, this.mirrorY, this.mirrorZ);
                if (ThaumcraftExtension.tileIsMirror(te)) {
                    this.mirrorValid = true;
                    this.mirrorStartedValid = true;
                    WorldSpecificCoordinates coord = ThaumcraftExtension.getLinkedMirrorCoordinates(te);
                    if (coord == null) {
                        this.mirrorLinkedY = -1;
                    } else {
                        this.mirrorLinkedDim = coord.dim;
                        this.mirrorLinkedX = coord.x;
                        this.mirrorLinkedY = coord.y;
                        this.mirrorLinkedZ = coord.z;
                    }
                } else if (TjUtil.isChunkLoaded(this.field_145850_b, x, z)) {
                    this.mirrorY = -1;
                    this.mirrorValid = false;
                }
            } else {
                this.mirrorValid = false;
            }
        } else {
            this.mirrorValid = false;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.updateMirrorNetwork();
        }
        this.func_70296_d();
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            boolean powered;
            this.clientRenderRotationHelper += 3;
            boolean bl = powered = this.func_145832_p() > 0;
            if (powered) {
                this.clientRenderRotationHelper += 7;
            }
            if (this.clientRenderRotationHelper >= rotationSpeedFactor) {
                this.clientRenderRotationHelper -= rotationSpeedFactor;
            }
            double adj = 0.0;
            double d = powered ? clientRenderFloatingBtm_powered : clientRenderFloatingBtm_unpowered;
            if (this.clientRenderFloatingDistance < d) {
                this.clientRenderGoingUp = true;
            } else {
                double d2 = powered ? clientRenderFloatingTop_powered : clientRenderFloatingTop_unpowered;
                if (this.clientRenderFloatingDistance > d2) {
                    this.clientRenderGoingUp = false;
                }
            }
            adj += this.clientRenderGoingUp ? 5.0E-4 : -5.0E-4;
            if (powered) {
                adj *= (double)(this.clientRenderFloatingDistance < clientRenderFloatingBtm_powered ? 12 : 3);
            } else if (this.clientRenderFloatingDistance > clientRenderFloatingTop_unpowered) {
                adj *= 7.0;
            }
            this.clientRenderFloatingDistance += adj;
        } else if (this.mirrorStartedValid) {
            RedstoneMirrorNetwork farMirrorData;
            int mirrorStrength;
            ++this.ticksSinceMirrorCheck;
            if (this.ticksSinceMirrorCheck >= 100) {
                this.ticksSinceMirrorCheck = 0;
                TileEntity te = this.field_145850_b.func_147438_o(this.mirrorX, this.mirrorY, this.mirrorZ);
                if (ThaumcraftExtension.tileIsMirror(te)) {
                    WorldSpecificCoordinates coord = ThaumcraftExtension.getLinkedMirrorCoordinates(te);
                    if (coord == null) {
                        this.mirrorLinkedY = -1;
                    } else {
                        this.mirrorLinkedDim = coord.dim;
                        this.mirrorLinkedX = coord.x;
                        this.mirrorLinkedY = coord.y;
                        this.mirrorLinkedZ = coord.z;
                    }
                    if (!this.mirrorValid) {
                        this.mirrorValid = true;
                        this.func_70296_d();
                        return;
                    }
                    this.markDirty(false);
                } else if (this.mirrorValid && TjUtil.isChunkLoaded(this.field_145850_b, this.mirrorX, this.mirrorZ)) {
                    this.mirrorValid = false;
                    this.mirrorLinkedY = -1;
                    this.extraData = 0;
                    this.func_70296_d();
                    RedstoneMirrorNetwork closeMirrorData = RedstoneMirrorNetwork.getData(this.mirrorDim);
                    closeMirrorData.removeSignal(this.mirrorX, this.mirrorY, this.mirrorZ);
                    this.updateBlock();
                    return;
                }
            }
            if (this.mirrorValid && this.mirrorLinkedY != -1 && this.extraData != (mirrorStrength = (farMirrorData = RedstoneMirrorNetwork.getData(this.mirrorLinkedDim)).getSignalGoingIn(this.mirrorLinkedX, this.mirrorLinkedY, this.mirrorLinkedZ))) {
                this.extraData = mirrorStrength;
                int strength = this.func_145832_p() + this.powerStability;
                this.updateBlock();
            }
        }
    }

    public void removeFromMirrorNetwork() {
        if (this.mirrorStartedValid) {
            RedstoneMirrorNetwork closeMirrorData = RedstoneMirrorNetwork.getData(this.mirrorDim);
            closeMirrorData.removeContributor(this.mirrorX, this.mirrorY, this.mirrorZ, this);
        }
    }

    public void updateMirrorNetwork() {
        if (this.mirrorStartedValid) {
            RedstoneMirrorNetwork closeMirrorData = RedstoneMirrorNetwork.getData(this.mirrorDim);
            closeMirrorData.contributeToSignalInto(this.mirrorX, this.mirrorY, this.mirrorZ, this, this.strengthWithoutMirror);
        }
    }

    protected void updateBlock() {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (block instanceof BlockRedcrystalMerc) {
            ((BlockRedcrystalMerc)block).updateAndPropagateChanges(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, true, false, false, false);
        }
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock || oldBlock != ModBlocks.redcrystalMerc;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        if (this.mirrorY != -1) {
            nbttagcompound.func_74768_a("mirrorX", this.mirrorX);
            nbttagcompound.func_74768_a("mirrorY", this.mirrorY);
            nbttagcompound.func_74768_a("mirrorZ", this.mirrorZ);
            nbttagcompound.func_74768_a("mirrorDim", this.mirrorDim);
            nbttagcompound.func_74757_a("mirrorValid", this.mirrorValid);
            nbttagcompound.func_74757_a("mirrorStartedValid", this.mirrorStartedValid);
            nbttagcompound.func_74768_a("strengthWithoutMirror", this.strengthWithoutMirror);
            if (this.mirrorLinkedY != -1) {
                nbttagcompound.func_74768_a("mirrorLinkedX", this.mirrorLinkedX);
                nbttagcompound.func_74768_a("mirrorLinkedY", this.mirrorLinkedY);
                nbttagcompound.func_74768_a("mirrorLinkedZ", this.mirrorLinkedZ);
                nbttagcompound.func_74768_a("mirrorLinkedDim", this.mirrorLinkedDim);
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.mirrorX = nbttagcompound.func_74762_e("mirrorX");
        this.mirrorY = nbttagcompound.func_74764_b("mirrorY") ? nbttagcompound.func_74762_e("mirrorY") : -1;
        this.mirrorZ = nbttagcompound.func_74762_e("mirrorZ");
        this.mirrorDim = nbttagcompound.func_74762_e("mirrorDim");
        this.mirrorValid = nbttagcompound.func_74767_n("mirrorValid");
        this.mirrorStartedValid = nbttagcompound.func_74767_n("mirrorStartedValid");
        this.strengthWithoutMirror = nbttagcompound.func_74762_e("strengthWithoutMirror");
        this.mirrorLinkedX = nbttagcompound.func_74762_e("mirrorLinkedX");
        this.mirrorLinkedY = nbttagcompound.func_74764_b("mirrorLinkedY") ? nbttagcompound.func_74762_e("mirrorLinkedY") : -1;
        this.mirrorLinkedZ = nbttagcompound.func_74762_e("mirrorLinkedZ");
        this.mirrorLinkedDim = nbttagcompound.func_74762_e("mirrorLinkedDim");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
        return bb;
    }
}

